/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.Function1;
import io.vavr.PartialFunction;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import io.vavr.collection.Array;
import io.vavr.collection.Collections;
import io.vavr.collection.Comparators;
import io.vavr.collection.HashSet;
import io.vavr.collection.Iterator;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.Map;
import io.vavr.collection.Set;
import io.vavr.collection.SortedSet;
import io.vavr.collection.Stream;
import io.vavr.collection.TreeSet;
import io.vavr.control.Option;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;

public abstract class BitSet<T>
implements SortedSet<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;

    private BitSet() {
    }

    public static <T> Builder<T> withRelations(Function1<Integer, T> fromInt, Function1<T, Integer> toInt) {
        return new Builder(fromInt, toInt);
    }

    public static <T extends Enum<T>> Builder<T> withEnum(Class<T> enumClass) {
        return new Builder(i -> ((Enum[])enumClass.getEnumConstants())[i], Enum::ordinal);
    }

    public static Builder<Character> withCharacters() {
        return new Builder<Character>(i -> Character.valueOf((char)i.intValue()), c -> c.charValue());
    }

    public static Builder<Byte> withBytes() {
        return new Builder<Byte>(Integer::byteValue, Byte::intValue);
    }

    public static Builder<Long> withLongs() {
        return new Builder<Long>(Integer::longValue, Long::intValue);
    }

    public static Builder<Short> withShorts() {
        return new Builder<Short>(Integer::shortValue, Short::intValue);
    }

    public static Collector<Integer, ArrayList<Integer>, BitSet<Integer>> collector() {
        return Builder.DEFAULT.collector();
    }

    public static BitSet<Integer> empty() {
        return Builder.DEFAULT.empty();
    }

    public static BitSet<Integer> of(Integer value) {
        return Builder.DEFAULT.of(value);
    }

    public static BitSet<Integer> of(Integer ... values) {
        return Builder.DEFAULT.of((T[])values);
    }

    public static BitSet<Integer> tabulate(int n, Function<Integer, Integer> f) {
        return Builder.DEFAULT.tabulate(n, f);
    }

    public static BitSet<Integer> fill(int n, Supplier<Integer> s) {
        return Builder.DEFAULT.fill(n, s);
    }

    public static BitSet<Integer> ofAll(Iterable<Integer> values) {
        return Builder.DEFAULT.ofAll(values);
    }

    public static BitSet<Integer> ofAll(java.util.stream.Stream<Integer> javaStream) {
        return Builder.DEFAULT.ofAll(javaStream);
    }

    public static BitSet<Boolean> ofAll(boolean ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return BitSet.withRelations(i -> i != 0, b -> b != false ? 1 : 0).ofAll(Iterator.ofAll(elements));
    }

    public static BitSet<Byte> ofAll(byte ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return BitSet.withBytes().ofAll(Iterator.ofAll(elements));
    }

    public static BitSet<Character> ofAll(char ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return BitSet.withCharacters().ofAll(Iterator.ofAll(elements));
    }

    public static BitSet<Integer> ofAll(int ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return BitSet.ofAll(Iterator.ofAll(elements));
    }

    public static BitSet<Long> ofAll(long ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return BitSet.withLongs().ofAll(Iterator.ofAll(elements));
    }

    public static BitSet<Short> ofAll(short ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return BitSet.withShorts().ofAll(Iterator.ofAll(elements));
    }

    public static BitSet<Integer> range(int from, int toExclusive) {
        return BitSet.ofAll(Iterator.range(from, toExclusive));
    }

    public static BitSet<Character> range(char from, char toExclusive) {
        return BitSet.withCharacters().ofAll(Iterator.range(from, toExclusive));
    }

    public static BitSet<Long> range(long from, long toExclusive) {
        return BitSet.withLongs().ofAll(Iterator.range(from, toExclusive));
    }

    public static BitSet<Integer> rangeBy(int from, int toExclusive, int step) {
        return BitSet.ofAll(Iterator.rangeBy(from, toExclusive, step));
    }

    public static BitSet<Character> rangeBy(char from, char toExclusive, int step) {
        return BitSet.withCharacters().ofAll(Iterator.rangeBy(from, toExclusive, step));
    }

    public static BitSet<Long> rangeBy(long from, long toExclusive, long step) {
        return BitSet.withLongs().ofAll(Iterator.rangeBy(from, toExclusive, step));
    }

    public static BitSet<Integer> rangeClosed(int from, int toInclusive) {
        return BitSet.ofAll(Iterator.rangeClosed(from, toInclusive));
    }

    public static BitSet<Character> rangeClosed(char from, char toInclusive) {
        return BitSet.withCharacters().ofAll(Iterator.rangeClosed(from, toInclusive));
    }

    public static BitSet<Long> rangeClosed(long from, long toInclusive) {
        return BitSet.withLongs().ofAll(Iterator.rangeClosed(from, toInclusive));
    }

    public static BitSet<Integer> rangeClosedBy(int from, int toInclusive, int step) {
        return BitSet.ofAll(Iterator.rangeClosedBy(from, toInclusive, step));
    }

    public static BitSet<Character> rangeClosedBy(char from, char toInclusive, int step) {
        return BitSet.withCharacters().ofAll(Iterator.rangeClosedBy(from, toInclusive, step));
    }

    public static BitSet<Long> rangeClosedBy(long from, long toInclusive, long step) {
        return BitSet.withLongs().ofAll(Iterator.rangeClosedBy(from, toInclusive, step));
    }

    @Override
    public abstract BitSet<T> add(T var1);

    @Override
    public abstract BitSet<T> addAll(Iterable<? extends T> var1);

    @Override
    public final <R> SortedSet<R> collect(PartialFunction<? super T, ? extends R> partialFunction) {
        Objects.requireNonNull(partialFunction, "partialFunction is null");
        return TreeSet.ofAll(Comparators.naturalComparator(), this.iterator().collect(partialFunction));
    }

    @Override
    public final BitSet<T> diff(Set<? extends T> elements) {
        return this.removeAll(elements);
    }

    @Override
    public final BitSet<T> distinct() {
        return this;
    }

    @Override
    public abstract BitSet<T> distinctBy(Comparator<? super T> var1);

    @Override
    public abstract <U> BitSet<T> distinctBy(Function<? super T, ? extends U> var1);

    @Override
    public abstract BitSet<T> drop(int var1);

    @Override
    public abstract BitSet<T> dropRight(int var1);

    @Override
    public final BitSet<T> dropUntil(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.dropWhile((Predicate)predicate.negate());
    }

    @Override
    public abstract BitSet<T> dropWhile(Predicate<? super T> var1);

    @Override
    public abstract BitSet<T> filter(Predicate<? super T> var1);

    @Override
    public abstract BitSet<T> filterNot(Predicate<? super T> var1);

    @Override
    @Deprecated
    public abstract BitSet<T> reject(Predicate<? super T> var1);

    @Override
    public final <U> SortedSet<U> flatMap(Comparator<? super U> comparator, Function<? super T, ? extends Iterable<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return TreeSet.ofAll(comparator, this.iterator().flatMap(mapper));
    }

    @Override
    public final <U> SortedSet<U> flatMap(Function<? super T, ? extends Iterable<? extends U>> mapper) {
        return this.flatMap(Comparators.naturalComparator(), mapper);
    }

    @Override
    public final <U> U foldRight(U zero, BiFunction<? super T, ? super U, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        return this.iterator().foldRight(zero, f);
    }

    @Override
    public abstract <C> Map<C, BitSet<T>> groupBy(Function<? super T, ? extends C> var1);

    @Override
    public final Iterator<BitSet<T>> grouped(int size) {
        return this.sliding(size, size);
    }

    @Override
    public final boolean hasDefiniteSize() {
        return true;
    }

    @Override
    public abstract BitSet<T> init();

    @Override
    public final Option<BitSet<T>> initOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.init());
    }

    @Override
    public final boolean isAsync() {
        return false;
    }

    @Override
    public final boolean isTraversableAgain() {
        return true;
    }

    @Override
    public final boolean isLazy() {
        return false;
    }

    @Override
    public abstract BitSet<T> intersect(Set<? extends T> var1);

    @Override
    public final T last() {
        return Collections.last(this);
    }

    @Override
    public abstract Tuple2<BitSet<T>, BitSet<T>> partition(Predicate<? super T> var1);

    @Override
    public final BitSet<T> peek(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action is null");
        if (!this.isEmpty()) {
            action.accept(this.head());
        }
        return this;
    }

    @Override
    public final String stringPrefix() {
        return "BitSet";
    }

    @Override
    public final <U> SortedSet<U> map(Comparator<? super U> comparator, Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return TreeSet.ofAll(comparator, this.iterator().map(mapper));
    }

    @Override
    public final <U> SortedSet<U> map(Function<? super T, ? extends U> mapper) {
        return this.map(Comparators.naturalComparator(), mapper);
    }

    @Override
    public abstract BitSet<T> remove(T var1);

    @Override
    public abstract BitSet<T> removeAll(Iterable<? extends T> var1);

    @Override
    public final BitSet<T> replace(T currentElement, T newElement) {
        if (this.contains(currentElement)) {
            return ((BitSet)this.remove((Object)currentElement)).add((Object)newElement);
        }
        return this;
    }

    @Override
    public final BitSet<T> replaceAll(T currentElement, T newElement) {
        return this.replace((Object)currentElement, (Object)newElement);
    }

    @Override
    public final BitSet<T> retainAll(Iterable<? extends T> elements) {
        return Collections.retainAll(this, elements);
    }

    @Override
    public abstract BitSet<T> scan(T var1, BiFunction<? super T, ? super T, ? extends T> var2);

    @Override
    public final <U> Set<U> scanLeft(U zero, BiFunction<? super U, ? super T, ? extends U> operation) {
        return Collections.scanLeft(this, zero, operation, HashSet::ofAll);
    }

    @Override
    public final <U> Set<U> scanRight(U zero, BiFunction<? super T, ? super U, ? extends U> operation) {
        return Collections.scanRight(this, zero, operation, HashSet::ofAll);
    }

    @Override
    public abstract Iterator<BitSet<T>> slideBy(Function<? super T, ?> var1);

    @Override
    public final Iterator<BitSet<T>> sliding(int size) {
        return this.sliding(size, 1);
    }

    @Override
    public abstract Iterator<BitSet<T>> sliding(int var1, int var2);

    @Override
    public abstract Tuple2<BitSet<T>, BitSet<T>> span(Predicate<? super T> var1);

    @Override
    public final BitSet<T> tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty BitSet");
        }
        return this.drop(1);
    }

    @Override
    public final Option<BitSet<T>> tailOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.tail());
    }

    @Override
    public abstract BitSet<T> take(int var1);

    @Override
    public abstract BitSet<T> takeRight(int var1);

    @Override
    public final BitSet<T> takeUntil(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.takeWhile((Predicate)predicate.negate());
    }

    @Override
    public abstract BitSet<T> takeWhile(Predicate<? super T> var1);

    @Override
    public final java.util.SortedSet<T> toJavaSet() {
        return this.toJavaSet(ignore -> new java.util.TreeSet(this.comparator()));
    }

    @Override
    public final BitSet<T> union(Set<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        return elements.isEmpty() ? this : this.addAll(elements);
    }

    @Override
    public final <T1, T2> Tuple2<TreeSet<T1>, TreeSet<T2>> unzip(Function<? super T, Tuple2<? extends T1, ? extends T2>> unzipper) {
        Objects.requireNonNull(unzipper, "unzipper is null");
        return this.iterator().unzip(unzipper).map((? super T1 i1) -> TreeSet.ofAll(Comparators.naturalComparator(), i1), (? super T2 i2) -> TreeSet.ofAll(Comparators.naturalComparator(), i2));
    }

    @Override
    public final <T1, T2, T3> Tuple3<TreeSet<T1>, TreeSet<T2>, TreeSet<T3>> unzip3(Function<? super T, Tuple3<? extends T1, ? extends T2, ? extends T3>> unzipper) {
        Objects.requireNonNull(unzipper, "unzipper is null");
        return this.iterator().unzip3(unzipper).map(i1 -> TreeSet.ofAll(Comparators.naturalComparator(), i1), i2 -> TreeSet.ofAll(Comparators.naturalComparator(), i2), i3 -> TreeSet.ofAll(Comparators.naturalComparator(), i3));
    }

    @Override
    public final <U> TreeSet<Tuple2<T, U>> zip(Iterable<? extends U> that) {
        Objects.requireNonNull(that, "that is null");
        Comparator tuple2Comparator = Tuple2.comparator(this.comparator(), Comparators.naturalComparator());
        return TreeSet.ofAll(tuple2Comparator, this.iterator().zip(that));
    }

    @Override
    public final <U, R> TreeSet<R> zipWith(Iterable<? extends U> that, BiFunction<? super T, ? super U, ? extends R> mapper) {
        Objects.requireNonNull(that, "that is null");
        Objects.requireNonNull(mapper, "mapper is null");
        return TreeSet.ofAll(Comparators.naturalComparator(), this.iterator().zipWith(that, mapper));
    }

    @Override
    public final <U> TreeSet<Tuple2<T, U>> zipAll(Iterable<? extends U> that, T thisElem, U thatElem) {
        Objects.requireNonNull(that, "that is null");
        Comparator tuple2Comparator = Tuple2.comparator(this.comparator(), Comparators.naturalComparator());
        return TreeSet.ofAll(tuple2Comparator, this.iterator().zipAll(that, thisElem, thatElem));
    }

    @Override
    public final TreeSet<Tuple2<T, Integer>> zipWithIndex() {
        Comparator component1Comparator = this.comparator();
        Comparator tuple2Comparator = (t1, t2) -> component1Comparator.compare(t1._1, t2._1);
        return TreeSet.ofAll(tuple2Comparator, this.iterator().zipWithIndex());
    }

    @Override
    public final <U> TreeSet<U> zipWithIndex(BiFunction<? super T, ? super Integer, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return TreeSet.ofAll(Comparators.naturalComparator(), this.iterator().zipWithIndex(mapper));
    }

    private static final class BitSetN<T>
    extends AbstractBitSet<T> {
        private static final long serialVersionUID = 1L;
        private final long[] elements;
        private final int len;

        BitSetN(Function1<Integer, T> fromInt, Function1<T, Integer> toInt, long[] elements) {
            super(fromInt, toInt);
            this.elements = elements;
            this.len = BitSetN.calcLength(elements);
        }

        private static int calcLength(long[] elements) {
            int len = 0;
            for (long element : elements) {
                len += Long.bitCount(element);
            }
            return len;
        }

        @Override
        int getWordsNum() {
            return this.elements.length;
        }

        @Override
        long[] copyExpand(int wordsNum) {
            if (wordsNum < this.elements.length) {
                wordsNum = this.elements.length;
            }
            long[] arr = new long[wordsNum];
            System.arraycopy(this.elements, 0, arr, 0, this.elements.length);
            return arr;
        }

        @Override
        long getWord(int index) {
            return this.elements[index];
        }

        @Override
        public T head() {
            int offset = 0;
            int element = 0;
            for (int i = 0; i < this.getWordsNum(); ++i) {
                if (this.elements[i] == 0L) {
                    offset += 64;
                    continue;
                }
                element = offset + Long.numberOfTrailingZeros(this.elements[i]);
                break;
            }
            return (T)this.fromInt.apply(element);
        }

        @Override
        public int length() {
            return this.len;
        }

        @Override
        public BitSet<T> add(T t) {
            if (this.contains(t)) {
                return this;
            }
            return this.addElement((Integer)this.toInt.apply(t));
        }
    }

    private static final class BitSet2<T>
    extends AbstractBitSet<T> {
        private static final long serialVersionUID = 1L;
        private final long elements1;
        private final long elements2;
        private final int len;

        BitSet2(Function1<Integer, T> fromInt, Function1<T, Integer> toInt, long elements1, long elements2) {
            super(fromInt, toInt);
            this.elements1 = elements1;
            this.elements2 = elements2;
            this.len = Long.bitCount(elements1) + Long.bitCount(elements2);
        }

        @Override
        int getWordsNum() {
            return 2;
        }

        @Override
        long[] copyExpand(int wordsNum) {
            if (wordsNum < 2) {
                wordsNum = 2;
            }
            long[] arr = new long[wordsNum];
            arr[0] = this.elements1;
            arr[1] = this.elements2;
            return arr;
        }

        @Override
        long getWord(int index) {
            if (index == 0) {
                return this.elements1;
            }
            return this.elements2;
        }

        @Override
        public T head() {
            if (this.elements1 == 0L) {
                return (T)this.fromInt.apply(64 + Long.numberOfTrailingZeros(this.elements2));
            }
            return (T)this.fromInt.apply(Long.numberOfTrailingZeros(this.elements1));
        }

        @Override
        public int length() {
            return this.len;
        }

        @Override
        public BitSet<T> add(T t) {
            int element = (Integer)this.toInt.apply(t);
            if (element < 0) {
                throw new IllegalArgumentException("bitset element must be >= 0");
            }
            long mask = 1L << element;
            if (element < 64) {
                if ((this.elements1 & mask) != 0L) {
                    return this;
                }
                return new BitSet2<T>(this.fromInt, this.toInt, this.elements1 | mask, this.elements2);
            }
            if (element < 128) {
                if ((this.elements2 & mask) != 0L) {
                    return this;
                }
                return new BitSet2<T>(this.fromInt, this.toInt, this.elements1, this.elements2 | mask);
            }
            return this.addElement(element);
        }
    }

    private static final class BitSet1<T>
    extends AbstractBitSet<T> {
        private static final long serialVersionUID = 1L;
        private final long elements;
        private final int len;

        BitSet1(Function1<Integer, T> fromInt, Function1<T, Integer> toInt, long elements) {
            super(fromInt, toInt);
            this.elements = elements;
            this.len = Long.bitCount(elements);
        }

        @Override
        int getWordsNum() {
            return 1;
        }

        @Override
        long[] copyExpand(int wordsNum) {
            if (wordsNum < 1) {
                wordsNum = 1;
            }
            long[] arr = new long[wordsNum];
            arr[0] = this.elements;
            return arr;
        }

        @Override
        long getWord(int index) {
            return this.elements;
        }

        @Override
        public T head() {
            if (this.elements == 0L) {
                throw new NoSuchElementException("head of empty BitSet");
            }
            return (T)this.fromInt.apply(Long.numberOfTrailingZeros(this.elements));
        }

        @Override
        public int length() {
            return this.len;
        }

        @Override
        public BitSet<T> add(T t) {
            int element = (Integer)this.toInt.apply(t);
            if (element < 0) {
                throw new IllegalArgumentException("bitset element must be >= 0");
            }
            if (element < 64) {
                long mask = 1L << element;
                if ((this.elements & mask) != 0L) {
                    return this;
                }
                return new BitSet1<T>(this.fromInt, this.toInt, this.elements | mask);
            }
            return this.addElement(element);
        }
    }

    private static final class BitSetIterator<T>
    implements Iterator<T> {
        private final AbstractBitSet<T> bitSet;
        private long element;
        private int index;

        BitSetIterator(AbstractBitSet<T> bitSet) {
            this.bitSet = bitSet;
            this.element = bitSet.getWord(0);
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.element == 0L) {
                while (this.element == 0L && this.index < this.bitSet.getWordsNum() - 1) {
                    this.element = this.bitSet.getWord(++this.index);
                }
                return this.element != 0L;
            }
            return true;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int pos = Long.numberOfTrailingZeros(this.element);
            this.element &= 1L << pos ^ 0xFFFFFFFFFFFFFFFFL;
            return this.bitSet.fromInt.apply(pos + (this.index << 6));
        }
    }

    private static abstract class AbstractBitSet<T>
    extends BitSet<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final Function1<Integer, T> fromInt;
        final Function1<T, Integer> toInt;

        AbstractBitSet(Function1<Integer, T> fromInt, Function1<T, Integer> toInt) {
            this.fromInt = fromInt;
            this.toInt = toInt;
        }

        abstract int getWordsNum();

        abstract long[] copyExpand(int var1);

        abstract long getWord(int var1);

        BitSet<T> createEmpty() {
            return new BitSet1<T>(this.fromInt, this.toInt, 0L);
        }

        BitSet<T> createFromAll(Iterable<? extends T> values) {
            return values instanceof BitSet ? (BitSet)values : this.createEmpty().addAll((Iterable)values);
        }

        BitSet<T> fromBitMaskNoCopy(long[] elements) {
            switch (elements.length) {
                case 0: {
                    return this.createEmpty();
                }
                case 1: {
                    return new BitSet1<T>(this.fromInt, this.toInt, elements[0]);
                }
                case 2: {
                    return new BitSet2<T>(this.fromInt, this.toInt, elements[0], elements[1]);
                }
            }
            return new BitSetN<T>(this.fromInt, this.toInt, elements);
        }

        private void setElement(long[] words, int element) {
            int index;
            int n = index = element >> 6;
            words[n] = words[n] | 1L << element;
        }

        private void unsetElement(long[] words, int element) {
            int index;
            int n = index = element >> 6;
            words[n] = words[n] & (1L << element ^ 0xFFFFFFFFFFFFFFFFL);
        }

        long[] shrink(long[] elements) {
            int newlen;
            for (newlen = elements.length; newlen > 0 && elements[newlen - 1] == 0L; --newlen) {
            }
            long[] newelems = new long[newlen];
            System.arraycopy(elements, 0, newelems, 0, newlen);
            return newelems;
        }

        BitSet<T> addElement(int element) {
            long[] copy = this.copyExpand(1 + (element >> 6));
            this.setElement(copy, element);
            return this.fromBitMaskNoCopy(copy);
        }

        @Override
        public BitSet<T> distinctBy(Comparator<? super T> comparator) {
            Objects.requireNonNull(comparator, "comparator is null");
            return this.isEmpty() ? this : this.createFromAll(this.iterator().distinctBy(comparator));
        }

        @Override
        public <U> BitSet<T> distinctBy(Function<? super T, ? extends U> keyExtractor) {
            Objects.requireNonNull(keyExtractor, "keyExtractor is null");
            return this.isEmpty() ? this : this.createFromAll(this.iterator().distinctBy(keyExtractor));
        }

        @Override
        public BitSet<T> drop(int n) {
            if (n <= 0 || this.isEmpty()) {
                return this;
            }
            if (n >= this.length()) {
                return this.createEmpty();
            }
            return this.createFromAll(this.iterator().drop(n));
        }

        @Override
        public BitSet<T> dropRight(int n) {
            if (n <= 0 || this.isEmpty()) {
                return this;
            }
            if (n >= this.length()) {
                return this.createEmpty();
            }
            return this.createFromAll(this.iterator().dropRight(n));
        }

        @Override
        public BitSet<T> dropWhile(Predicate<? super T> predicate) {
            Objects.requireNonNull(predicate, "predicate is null");
            BitSet<T> bitSet = this.createFromAll(this.iterator().dropWhile(predicate));
            return bitSet.length() == this.length() ? this : bitSet;
        }

        @Override
        public BitSet<T> intersect(Set<? extends T> elements) {
            Objects.requireNonNull(elements, "elements is null");
            if (this.isEmpty()) {
                return this;
            }
            if (elements.isEmpty()) {
                return this.createEmpty();
            }
            int size = this.size();
            if (size <= elements.size()) {
                return this.retainAll(elements);
            }
            SortedSet results = this.createFromAll(elements).retainAll((Iterable)this);
            return size == results.size() ? this : results;
        }

        @Override
        public BitSet<T> orElse(Iterable<? extends T> other) {
            return this.isEmpty() ? this.createFromAll(other) : this;
        }

        @Override
        public BitSet<T> orElse(Supplier<? extends Iterable<? extends T>> supplier) {
            return this.isEmpty() ? this.createFromAll(supplier.get()) : this;
        }

        @Override
        public Iterator<BitSet<T>> slideBy(Function<? super T, ?> classifier) {
            return this.iterator().slideBy(classifier).map(this::createFromAll);
        }

        @Override
        public Iterator<BitSet<T>> sliding(int size, int step) {
            return this.iterator().sliding(size, step).map(this::createFromAll);
        }

        @Override
        public Tuple2<BitSet<T>, BitSet<T>> span(Predicate<? super T> predicate) {
            Objects.requireNonNull(predicate, "predicate is null");
            return this.iterator().span(predicate).map(this::createFromAll, this::createFromAll);
        }

        @Override
        public BitSet<T> scan(T zero, BiFunction<? super T, ? super T, ? extends T> operation) {
            return Collections.scanLeft(this, zero, operation, this::createFromAll);
        }

        @Override
        public Tuple2<BitSet<T>, BitSet<T>> partition(Predicate<? super T> predicate) {
            Objects.requireNonNull(predicate, "predicate is null");
            return this.iterator().partition(predicate).map(this::createFromAll, this::createFromAll);
        }

        @Override
        public BitSet<T> filter(Predicate<? super T> predicate) {
            Objects.requireNonNull(predicate, "predicate is null");
            BitSet<T> bitSet = this.createFromAll(this.iterator().filter(predicate));
            return bitSet.length() == this.length() ? this : bitSet;
        }

        @Override
        public BitSet<T> filterNot(Predicate<? super T> predicate) {
            Objects.requireNonNull(predicate, "predicate is null");
            BitSet<T> bitSet = this.createFromAll(this.iterator().filterNot(predicate));
            return bitSet.length() == this.length() ? this : bitSet;
        }

        @Override
        @Deprecated
        public BitSet<T> reject(Predicate<? super T> predicate) {
            Objects.requireNonNull(predicate, "predicate is null");
            BitSet<T> bitSet = this.createFromAll(this.iterator().reject(predicate));
            return bitSet.length() == this.length() ? this : bitSet;
        }

        @Override
        public <C> Map<C, BitSet<T>> groupBy(Function<? super T, ? extends C> classifier) {
            return Collections.groupBy(this, classifier, this::createFromAll);
        }

        @Override
        public Comparator<T> comparator() {
            return Comparator.comparing(this.toInt);
        }

        @Override
        public BitSet<T> takeWhile(Predicate<? super T> predicate) {
            Objects.requireNonNull(predicate, "predicate is null");
            BitSet<T> result = this.createFromAll(this.iterator().takeWhile(predicate));
            return result.length() == this.length() ? this : result;
        }

        @Override
        public BitSet<T> addAll(Iterable<? extends T> elements) {
            LinearSeq source = Stream.ofAll(elements).map(this.toInt);
            if (source.isEmpty()) {
                return this;
            }
            long[] copy = this.copyExpand(1 + (source.max().getOrElse(0) >> 6));
            source.forEach(element -> {
                if (element < 0) {
                    throw new IllegalArgumentException("bitset element must be >= 0");
                }
                this.setElement(copy, (int)element);
            });
            BitSet<T> bitSet = this.fromBitMaskNoCopy(copy);
            return bitSet.length() == this.length() ? this : bitSet;
        }

        @Override
        public boolean contains(T t) {
            int element = this.toInt.apply(t);
            if (element < 0) {
                throw new IllegalArgumentException("bitset element must be >= 0");
            }
            int index = element >> 6;
            return index < this.getWordsNum() && (this.getWord(index) & 1L << element) != 0L;
        }

        @Override
        public BitSet<T> init() {
            if (this.isEmpty()) {
                throw new UnsupportedOperationException("init of empty TreeSet");
            }
            long last = this.getWord(this.getWordsNum() - 1);
            int element = 64 * (this.getWordsNum() - 1) + 64 - Long.numberOfLeadingZeros(last) - 1;
            return this.remove((Object)this.fromInt.apply(element));
        }

        @Override
        public Iterator<T> iterator() {
            return new BitSetIterator(this);
        }

        @Override
        public BitSet<T> take(int n) {
            if (this.isEmpty() || n >= this.length()) {
                return this;
            }
            if (n <= 0) {
                return this.createEmpty();
            }
            return this.createFromAll(this.iterator().take(n));
        }

        @Override
        public BitSet<T> takeRight(int n) {
            if (this.isEmpty() || n >= this.length()) {
                return this;
            }
            if (n <= 0) {
                return this.createEmpty();
            }
            return this.createFromAll(this.iterator().takeRight(n));
        }

        @Override
        public BitSet<T> remove(T t) {
            if (this.contains(t)) {
                int element = this.toInt.apply(t);
                long[] copy = this.copyExpand(this.getWordsNum());
                this.unsetElement(copy, element);
                return this.fromBitMaskNoCopy(this.shrink(copy));
            }
            return this;
        }

        @Override
        public BitSet<T> removeAll(Iterable<? extends T> elements) {
            if (this.isEmpty()) {
                return this;
            }
            LinearSeq source = Stream.ofAll(elements).map(this.toInt);
            if (source.isEmpty()) {
                return this;
            }
            long[] copy = this.copyExpand(this.getWordsNum());
            source.forEach(element -> this.unsetElement(copy, (int)element));
            return this.fromBitMaskNoCopy(this.shrink(copy));
        }

        @Override
        public String toString() {
            return this.mkString(this.stringPrefix() + "(", ", ", ")");
        }

        @Override
        public boolean equals(Object o) {
            return Collections.equals(this, o);
        }

        @Override
        public int hashCode() {
            return Collections.hashUnordered(this);
        }
    }

    public static final class Builder<T> {
        private static final Builder<Integer> DEFAULT = new Builder<Integer>(i -> i, i -> i);
        private final Function1<Integer, T> fromInt;
        private final Function1<T, Integer> toInt;

        private Builder(Function1<Integer, T> fromInt, Function1<T, Integer> toInt) {
            this.fromInt = fromInt;
            this.toInt = toInt;
        }

        public Collector<T, ArrayList<T>, BitSet<T>> collector() {
            BinaryOperator combiner = (left, right) -> {
                left.addAll(right);
                return left;
            };
            return Collector.of(ArrayList::new, ArrayList::add, combiner, this::ofAll, new Collector.Characteristics[0]);
        }

        public BitSet<T> empty() {
            return new BitSet1<T>(this.fromInt, this.toInt, 0L);
        }

        public BitSet<T> of(T t) {
            int value = this.toInt.apply(t);
            if (value < 64) {
                return new BitSet1<T>(this.fromInt, this.toInt, 1L << value);
            }
            if (value < 128) {
                return new BitSet2<T>(this.fromInt, this.toInt, 0L, 1L << value);
            }
            return this.empty().add((Object)t);
        }

        @SafeVarargs
        public final BitSet<T> of(T ... values) {
            return this.empty().addAll((Iterable)Array.wrap(values));
        }

        public BitSet<T> ofAll(Iterable<? extends T> values) {
            Objects.requireNonNull(values, "values is null");
            return this.empty().addAll((Iterable)values);
        }

        public BitSet<T> ofAll(java.util.stream.Stream<? extends T> javaStream) {
            Objects.requireNonNull(javaStream, "javaStream is null");
            return this.empty().addAll((Iterable)Iterator.ofAll(javaStream.iterator()));
        }

        public BitSet<T> tabulate(int n, Function<? super Integer, ? extends T> f) {
            Objects.requireNonNull(f, "f is null");
            return this.empty().addAll((Iterable)Collections.tabulate(n, f));
        }

        public BitSet<T> fill(int n, Supplier<? extends T> s) {
            Objects.requireNonNull(s, "s is null");
            return this.empty().addAll((Iterable)Collections.fill(n, s));
        }
    }
}

