/*
 * Decompiled with CFR 0.152.
 */
package vivid.lib.messages;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.vavr.control.Option;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import vivid.lib.I18n;
import vivid.lib.messages.Message;
import vivid.lib.messages.MessageType;

public abstract class CodedMessage {
    private static final Pattern CODED_MESSAGE_CLASSNAME_PREFIX = Pattern.compile("^(VTE|VTW)([\\d]+)");
    private final String messageCode;
    private final MessageType messageType;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    protected CodedMessage() {
        String simpleClassName = this.getClass().getSimpleName();
        Matcher m = CODED_MESSAGE_CLASSNAME_PREFIX.matcher(simpleClassName);
        if (!m.find()) {
            throw new ExceptionInInitializerError(new Message.MessageBuilder(MessageType.ERROR, I18n.getText(Option.none(), "vivid.trace.error.vte-19-internal-error", new Serializable[0])).code("VTE-19").addDetail("supplementary-message", "Cannot determine the message code and type from class name: " + simpleClassName).build().getMessage());
        }
        String discriminator = m.group(1);
        String serial = m.group(2);
        this.messageType = discriminator.compareToIgnoreCase("VTE") == 0 ? MessageType.ERROR : MessageType.WARNING;
        this.messageCode = discriminator + "-" + serial;
    }

    public String getMessageCode() {
        return this.messageCode;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }
}

