/*
 * Decompiled with CFR 0.152.
 */
package vivid.lib.rest;

import io.vavr.control.Either;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import vivid.lib.ClassLoaderUtils;
import vivid.lib.I18n;
import vivid.lib.compatibility.Jackson;
import vivid.lib.messages.Message;
import vivid.lib.messages.VTE19InternalError;
import vivid.lib.rest.Rest;

public class OpenAPIDefinitionCache {
    private static Either<Message, String> cachedOpenAPIDefinition = null;

    private OpenAPIDefinitionCache() {
    }

    public static synchronized Response getOpenAPIDefinition(Option<I18n.ResolverAdapter> i18nResolverAdapterOption, UriInfo uriInfo, String openAPIDefinitionFileResourcePath) {
        if (cachedOpenAPIDefinition == null) {
            cachedOpenAPIDefinition = OpenAPIDefinitionCache.createDefinition(i18nResolverAdapterOption, uriInfo, openAPIDefinitionFileResourcePath);
        }
        if (cachedOpenAPIDefinition.isLeft()) {
            return Rest.responseWithMessage(Response.Status.INTERNAL_SERVER_ERROR, cachedOpenAPIDefinition.getLeft());
        }
        return Response.status((Response.Status)Response.Status.OK).type("application/json").entity((Object)cachedOpenAPIDefinition.get()).build();
    }

    private static Object[] openAPIServerUrls(UriInfo uriInfo) {
        TreeMap<String, String> server = new TreeMap<String, String>();
        String rawPath = uriInfo.getBaseUri().getPath();
        int indexOfLastSlashInRawPath = rawPath.lastIndexOf(47);
        if (indexOfLastSlashInRawPath >= 0) {
            String baseUrl = rawPath.substring(0, indexOfLastSlashInRawPath);
            server.put("url", baseUrl);
        }
        return new Object[]{server};
    }

    private static Either<Message, String> createDefinition(Option<I18n.ResolverAdapter> i18nResolverAdapterOption, UriInfo uriInfo, String openAPIDefinitionFileResourcePath) {
        InputStream resource = ClassLoaderUtils.getResourceAsStream(openAPIDefinitionFileResourcePath, OpenAPIDefinitionCache.class);
        if (Objects.isNull(resource)) {
            return Either.left(VTE19InternalError.message(i18nResolverAdapterOption, "Could not read the OpenAPI document at resource path: " + openAPIDefinitionFileResourcePath));
        }
        try {
            Map<Object, Object> doc = Jackson.readValue(resource, new Jackson.TypeReference<Map<Object, Object>>(){});
            doc.put("servers", OpenAPIDefinitionCache.openAPIServerUrls(uriInfo));
            return Either.right(Jackson.writeValueAsString(doc));
        }
        catch (IOException e) {
            return Either.left(VTE19InternalError.message(i18nResolverAdapterOption, "Could not process the OpenAPI document at resource path: " + openAPIDefinitionFileResourcePath));
        }
    }
}

