/*
 * Decompiled with CFR 0.152.
 */
package vivid.license;

import io.vavr.collection.HashSet;
import io.vavr.collection.Map;
import io.vavr.collection.Stream;
import io.vavr.control.Option;
import java.util.function.Function;
import vivid.license.Flag;

public enum LicenseType {
    ACADEMIC("academic", "vivid.trace.license-banner.academic-license", Flag.DISPLAY_BANNER, Flag.USABLE_AFTER_EXPIRATION),
    COMMERCIAL("commercial", "vivid.trace.license-banner.commercial-license", Flag.USABLE_AFTER_EXPIRATION),
    DEMONSTRATION("demonstration", "vivid.trace.license-banner.demonstration-license", Flag.DISPLAY_BANNER),
    NON_PROFIT("non-profit", "vivid.trace.license-banner.non-profit-license", Flag.DISPLAY_BANNER, Flag.USABLE_AFTER_EXPIRATION),
    OPEN_SOURCE("open-source", "vivid.trace.license-banner.open-source-license", Flag.DISPLAY_BANNER, Flag.USABLE_AFTER_EXPIRATION),
    TRIAL("trial", "vivid.trace.license-banner.trial-license", Flag.DISPLAY_BANNER);

    private static final Map<String, LicenseType> BY_LABEL;
    public final String label;
    public final String i18nKey;
    public final boolean displayBanner;
    public final boolean usableAfterExpiration;

    private LicenseType(String label, String i18nKey, Flag ... flags) {
        this.label = label;
        this.i18nKey = i18nKey;
        HashSet<Flag> fs = HashSet.of(flags);
        this.displayBanner = fs.contains(Flag.DISPLAY_BANNER);
        this.usableAfterExpiration = fs.contains(Flag.USABLE_AFTER_EXPIRATION);
    }

    public static Option<LicenseType> valueForLabel(String label) {
        return BY_LABEL.get(label);
    }

    static {
        BY_LABEL = Stream.of(LicenseType.values()).toMap(t -> t.label, Function.identity());
    }
}

