/*
 * Decompiled with CFR 0.152.
 */
package vivid.shaded.org.msgpack.template;

import java.io.IOException;
import vivid.shaded.org.msgpack.MessageTypeException;
import vivid.shaded.org.msgpack.packer.Packer;
import vivid.shaded.org.msgpack.template.AbstractTemplate;
import vivid.shaded.org.msgpack.template.TemplateRegistry;
import vivid.shaded.org.msgpack.unpacker.Unpacker;

public class AnyTemplate<T>
extends AbstractTemplate<T> {
    private TemplateRegistry registry;

    public AnyTemplate(TemplateRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void write(Packer pk, T target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
        } else {
            this.registry.lookup(target.getClass()).write(pk, target);
        }
    }

    @Override
    public T read(Unpacker u, T to, boolean required) throws IOException, MessageTypeException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        if (to == null) {
            throw new MessageTypeException("convert into unknown type is invalid");
        }
        T o = u.read(to);
        if (required && o == null) {
            throw new MessageTypeException("Unexpected nil value");
        }
        return o;
    }
}

