/*
 * Decompiled with CFR 0.152.
 */
package vivid.shaded.org.msgpack.template;

import java.io.IOException;
import vivid.shaded.org.msgpack.MessageTypeException;
import vivid.shaded.org.msgpack.packer.Packer;
import vivid.shaded.org.msgpack.template.AbstractTemplate;
import vivid.shaded.org.msgpack.unpacker.Unpacker;

public class BooleanArrayTemplate
extends AbstractTemplate<boolean[]> {
    static final BooleanArrayTemplate instance = new BooleanArrayTemplate();

    private BooleanArrayTemplate() {
    }

    @Override
    public void write(Packer pk, boolean[] target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        pk.writeArrayBegin(target.length);
        for (boolean a : target) {
            pk.write(a);
        }
        pk.writeArrayEnd();
    }

    @Override
    public boolean[] read(Unpacker u, boolean[] to, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        int n = u.readArrayBegin();
        if (to == null || to.length != n) {
            to = new boolean[n];
        }
        for (int i = 0; i < n; ++i) {
            to[i] = u.readBoolean();
        }
        u.readArrayEnd();
        return to;
    }

    public static BooleanArrayTemplate getInstance() {
        return instance;
    }
}

