/*
 * Decompiled with CFR 0.152.
 */
package vivid.shaded.org.msgpack.template;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import vivid.shaded.org.msgpack.MessagePackable;
import vivid.shaded.org.msgpack.MessageTypeException;
import vivid.shaded.org.msgpack.template.AnyTemplate;
import vivid.shaded.org.msgpack.template.BigDecimalTemplate;
import vivid.shaded.org.msgpack.template.BigIntegerTemplate;
import vivid.shaded.org.msgpack.template.BooleanArrayTemplate;
import vivid.shaded.org.msgpack.template.BooleanTemplate;
import vivid.shaded.org.msgpack.template.ByteArrayTemplate;
import vivid.shaded.org.msgpack.template.ByteBufferTemplate;
import vivid.shaded.org.msgpack.template.ByteTemplate;
import vivid.shaded.org.msgpack.template.CharacterTemplate;
import vivid.shaded.org.msgpack.template.CollectionTemplate;
import vivid.shaded.org.msgpack.template.DateTemplate;
import vivid.shaded.org.msgpack.template.DoubleArrayTemplate;
import vivid.shaded.org.msgpack.template.DoubleTemplate;
import vivid.shaded.org.msgpack.template.FieldList;
import vivid.shaded.org.msgpack.template.FloatArrayTemplate;
import vivid.shaded.org.msgpack.template.FloatTemplate;
import vivid.shaded.org.msgpack.template.GenericCollectionTemplate;
import vivid.shaded.org.msgpack.template.GenericMapTemplate;
import vivid.shaded.org.msgpack.template.GenericTemplate;
import vivid.shaded.org.msgpack.template.IntegerArrayTemplate;
import vivid.shaded.org.msgpack.template.IntegerTemplate;
import vivid.shaded.org.msgpack.template.ListTemplate;
import vivid.shaded.org.msgpack.template.LongArrayTemplate;
import vivid.shaded.org.msgpack.template.LongTemplate;
import vivid.shaded.org.msgpack.template.MapTemplate;
import vivid.shaded.org.msgpack.template.MessagePackableTemplate;
import vivid.shaded.org.msgpack.template.SetTemplate;
import vivid.shaded.org.msgpack.template.ShortArrayTemplate;
import vivid.shaded.org.msgpack.template.ShortTemplate;
import vivid.shaded.org.msgpack.template.StringTemplate;
import vivid.shaded.org.msgpack.template.Template;
import vivid.shaded.org.msgpack.template.TemplateReference;
import vivid.shaded.org.msgpack.template.ValueTemplate;
import vivid.shaded.org.msgpack.template.builder.TemplateBuilder;
import vivid.shaded.org.msgpack.template.builder.TemplateBuilderChain;
import vivid.shaded.org.msgpack.type.Value;

public class TemplateRegistry {
    private TemplateRegistry parent = null;
    private TemplateBuilderChain chain;
    Map<Type, Template<Type>> cache;
    private Map<Type, GenericTemplate> genericCache;

    private TemplateRegistry() {
        this.parent = null;
        this.chain = this.createTemplateBuilderChain();
        this.genericCache = new HashMap<Type, GenericTemplate>();
        this.cache = new HashMap<Type, Template<Type>>();
        this.registerTemplates();
        this.cache = Collections.unmodifiableMap(this.cache);
    }

    public TemplateRegistry(TemplateRegistry registry) {
        this.parent = registry != null ? registry : new TemplateRegistry();
        this.chain = this.createTemplateBuilderChain();
        this.cache = new HashMap<Type, Template<Type>>();
        this.genericCache = new HashMap<Type, GenericTemplate>();
        this.registerTemplatesWhichRefersRegistry();
    }

    protected TemplateBuilderChain createTemplateBuilderChain() {
        return new TemplateBuilderChain(this);
    }

    public void setClassLoader(ClassLoader cl) {
        this.chain = new TemplateBuilderChain(this, cl);
    }

    private void registerTemplates() {
        this.register(Boolean.TYPE, BooleanTemplate.getInstance());
        this.register((Type)((Object)Boolean.class), BooleanTemplate.getInstance());
        this.register(Byte.TYPE, ByteTemplate.getInstance());
        this.register((Type)((Object)Byte.class), ByteTemplate.getInstance());
        this.register(Short.TYPE, ShortTemplate.getInstance());
        this.register((Type)((Object)Short.class), ShortTemplate.getInstance());
        this.register(Integer.TYPE, IntegerTemplate.getInstance());
        this.register((Type)((Object)Integer.class), IntegerTemplate.getInstance());
        this.register(Long.TYPE, LongTemplate.getInstance());
        this.register((Type)((Object)Long.class), LongTemplate.getInstance());
        this.register(Float.TYPE, FloatTemplate.getInstance());
        this.register((Type)((Object)Float.class), FloatTemplate.getInstance());
        this.register(Double.TYPE, DoubleTemplate.getInstance());
        this.register((Type)((Object)Double.class), DoubleTemplate.getInstance());
        this.register((Type)((Object)BigInteger.class), BigIntegerTemplate.getInstance());
        this.register(Character.TYPE, CharacterTemplate.getInstance());
        this.register((Type)((Object)Character.class), CharacterTemplate.getInstance());
        this.register((Type)((Object)boolean[].class), BooleanArrayTemplate.getInstance());
        this.register((Type)((Object)short[].class), ShortArrayTemplate.getInstance());
        this.register((Type)((Object)int[].class), IntegerArrayTemplate.getInstance());
        this.register((Type)((Object)long[].class), LongArrayTemplate.getInstance());
        this.register((Type)((Object)float[].class), FloatArrayTemplate.getInstance());
        this.register((Type)((Object)double[].class), DoubleArrayTemplate.getInstance());
        this.register((Type)((Object)String.class), StringTemplate.getInstance());
        this.register((Type)((Object)byte[].class), ByteArrayTemplate.getInstance());
        this.register((Type)((Object)ByteBuffer.class), ByteBufferTemplate.getInstance());
        this.register((Type)((Object)Value.class), ValueTemplate.getInstance());
        this.register((Type)((Object)BigDecimal.class), BigDecimalTemplate.getInstance());
        this.register((Type)((Object)Date.class), DateTemplate.getInstance());
        this.registerTemplatesWhichRefersRegistry();
    }

    protected void registerTemplatesWhichRefersRegistry() {
        AnyTemplate anyTemplate = new AnyTemplate(this);
        this.register((Type)((Object)List.class), new ListTemplate(anyTemplate));
        this.register((Type)((Object)Set.class), new SetTemplate(anyTemplate));
        this.register((Type)((Object)Collection.class), new CollectionTemplate(anyTemplate));
        this.register((Type)((Object)Map.class), new MapTemplate(anyTemplate, anyTemplate));
        this.registerGeneric((Type)((Object)List.class), new GenericCollectionTemplate(this, ListTemplate.class));
        this.registerGeneric((Type)((Object)Set.class), new GenericCollectionTemplate(this, SetTemplate.class));
        this.registerGeneric((Type)((Object)Collection.class), new GenericCollectionTemplate(this, CollectionTemplate.class));
        this.registerGeneric((Type)((Object)Map.class), new GenericMapTemplate(this, MapTemplate.class));
    }

    public void register(Class<?> targetClass) {
        this.buildAndRegister(null, targetClass, false, null);
    }

    public void register(Class<?> targetClass, FieldList flist) {
        if (flist == null) {
            throw new NullPointerException("FieldList object is null");
        }
        this.buildAndRegister(null, targetClass, false, flist);
    }

    public synchronized void register(Type targetType, Template tmpl) {
        if (tmpl == null) {
            throw new NullPointerException("Template object is null");
        }
        if (targetType instanceof ParameterizedType) {
            this.cache.put(((ParameterizedType)targetType).getRawType(), tmpl);
        } else {
            this.cache.put(targetType, tmpl);
        }
    }

    public synchronized void registerGeneric(Type targetType, GenericTemplate tmpl) {
        if (targetType instanceof ParameterizedType) {
            this.genericCache.put(((ParameterizedType)targetType).getRawType(), tmpl);
        } else {
            this.genericCache.put(targetType, tmpl);
        }
    }

    public synchronized boolean unregister(Type targetType) {
        Template<Type> tmpl = this.cache.remove(targetType);
        return tmpl != null;
    }

    public synchronized void unregister() {
        this.cache.clear();
    }

    public synchronized Template lookup(Type targetType) {
        Template<MessagePackable> tmpl;
        if (targetType instanceof ParameterizedType) {
            ParameterizedType paramedType = (ParameterizedType)targetType;
            tmpl = this.lookupGenericType(paramedType);
            if (tmpl != null) {
                return tmpl;
            }
            targetType = paramedType.getRawType();
        }
        if ((tmpl = this.lookupGenericArrayType(targetType)) != null) {
            return tmpl;
        }
        tmpl = this.lookupCache(targetType);
        if (tmpl != null) {
            return tmpl;
        }
        if (targetType instanceof WildcardType || targetType instanceof TypeVariable) {
            tmpl = new AnyTemplate<Type>(this);
            this.register(targetType, tmpl);
            return tmpl;
        }
        Class targetClass = (Class)targetType;
        if (MessagePackable.class.isAssignableFrom(targetClass)) {
            tmpl = new MessagePackableTemplate(targetClass);
            this.register((Type)targetClass, tmpl);
            return tmpl;
        }
        if (targetClass.isInterface()) {
            tmpl = new AnyTemplate(this);
            this.register(targetType, tmpl);
            return tmpl;
        }
        tmpl = this.lookupAfterBuilding(targetClass);
        if (tmpl != null) {
            return tmpl;
        }
        tmpl = this.lookupInterfaceTypes(targetClass);
        if (tmpl != null) {
            return tmpl;
        }
        tmpl = this.lookupSuperclasses(targetClass);
        if (tmpl != null) {
            return tmpl;
        }
        tmpl = this.lookupSuperclassInterfaceTypes(targetClass);
        if (tmpl != null) {
            return tmpl;
        }
        throw new MessageTypeException("Cannot find template for " + targetClass + " class.  " + "Try to add @Message annotation to the class or call MessagePack.register(Type).");
    }

    private Template<Type> lookupGenericType(ParameterizedType paramedType) {
        Template<Type> tmpl = this.lookupGenericTypeImpl(paramedType);
        if (tmpl != null) {
            return tmpl;
        }
        try {
            tmpl = this.parent.lookupGenericTypeImpl(paramedType);
            if (tmpl != null) {
                return tmpl;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        tmpl = this.lookupGenericInterfaceTypes(paramedType);
        if (tmpl != null) {
            return tmpl;
        }
        tmpl = this.lookupGenericSuperclasses(paramedType);
        if (tmpl != null) {
            return tmpl;
        }
        return null;
    }

    private Template lookupGenericTypeImpl(ParameterizedType targetType) {
        Type rawType = targetType.getRawType();
        return this.lookupGenericTypeImpl0(targetType, rawType);
    }

    private Template lookupGenericTypeImpl0(ParameterizedType targetType, Type rawType) {
        GenericTemplate gtmpl = this.genericCache.get(rawType);
        if (gtmpl == null) {
            return null;
        }
        Type[] types = targetType.getActualTypeArguments();
        Template[] tmpls = new Template[types.length];
        for (int i = 0; i < types.length; ++i) {
            tmpls[i] = this.lookup(types[i]);
        }
        return gtmpl.build(tmpls);
    }

    private <T> Template<T> lookupGenericInterfaceTypes(ParameterizedType targetType) {
        Type rawType = targetType.getRawType();
        Template tmpl = null;
        try {
            Class<?>[] infTypes;
            for (Class<?> infType : infTypes = ((Class)rawType).getInterfaces()) {
                tmpl = this.lookupGenericTypeImpl0(targetType, infType);
                if (tmpl == null) continue;
                return tmpl;
            }
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        return tmpl;
    }

    private <T> Template<T> lookupGenericSuperclasses(ParameterizedType targetType) {
        Type rawType = targetType.getRawType();
        Template tmpl = null;
        try {
            Class superClass;
            if (superClass == null) {
                return null;
            }
            for (superClass = ((Class)rawType).getSuperclass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
                tmpl = this.lookupGenericTypeImpl0(targetType, superClass);
                if (tmpl == null) continue;
                this.register(targetType, tmpl);
                return tmpl;
            }
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        return tmpl;
    }

    private Template<Type> lookupGenericArrayType(Type targetType) {
        if (!(targetType instanceof GenericArrayType)) {
            return null;
        }
        GenericArrayType genericArrayType = (GenericArrayType)targetType;
        Template tmpl = this.lookupGenericArrayTypeImpl(genericArrayType);
        if (tmpl != null) {
            return tmpl;
        }
        try {
            tmpl = this.parent.lookupGenericArrayTypeImpl(genericArrayType);
            if (tmpl != null) {
                return tmpl;
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        return null;
    }

    private Template lookupGenericArrayTypeImpl(GenericArrayType genericArrayType) {
        String genericArrayTypeName = "" + genericArrayType;
        int dim = genericArrayTypeName.split("\\[").length - 1;
        if (dim <= 0) {
            throw new MessageTypeException(String.format("fatal error: type=", genericArrayTypeName));
        }
        if (dim > 1) {
            throw new UnsupportedOperationException(String.format("Not implemented template generation of %s", genericArrayTypeName));
        }
        String genericCompTypeName = "" + genericArrayType.getGenericComponentType();
        boolean isPrimitiveType = TemplateRegistry.isPrimitiveType(genericCompTypeName);
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < dim; ++i) {
            sbuf.append('[');
        }
        if (!isPrimitiveType) {
            sbuf.append('L');
            sbuf.append(TemplateRegistry.toJvmReferenceTypeName(genericCompTypeName));
            sbuf.append(';');
        } else {
            sbuf.append(TemplateRegistry.toJvmPrimitiveTypeName(genericCompTypeName));
        }
        String jvmArrayClassName = sbuf.toString();
        Class<?> jvmArrayClass = null;
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
            if (cl != null && (jvmArrayClass = cl.loadClass(jvmArrayClassName)) != null) {
                return this.lookupAfterBuilding(jvmArrayClass);
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            cl = this.getClass().getClassLoader();
            if (cl != null && (jvmArrayClass = cl.loadClass(jvmArrayClassName)) != null) {
                return this.lookupAfterBuilding(jvmArrayClass);
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            jvmArrayClass = Class.forName(jvmArrayClassName);
            if (jvmArrayClass != null) {
                return this.lookupAfterBuilding(jvmArrayClass);
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        throw new MessageTypeException(String.format("cannot find template of %s", jvmArrayClassName));
    }

    private Template<Type> lookupCache(Type targetType) {
        Template<Type> tmpl = this.cache.get(targetType);
        if (tmpl != null) {
            return tmpl;
        }
        try {
            tmpl = this.parent.lookupCache(targetType);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return tmpl;
    }

    private <T> Template<T> lookupAfterBuilding(Class<T> targetClass) {
        TemplateBuilder builder = this.chain.select(targetClass, true);
        Template tmpl = null;
        if (builder != null) {
            tmpl = this.chain.getForceBuilder().loadTemplate(targetClass);
            if (tmpl != null) {
                this.register(targetClass, tmpl);
                return tmpl;
            }
            tmpl = this.buildAndRegister(builder, targetClass, true, null);
        }
        return tmpl;
    }

    private <T> Template<T> lookupInterfaceTypes(Class<T> targetClass) {
        Class<?>[] infTypes = targetClass.getInterfaces();
        Template<Type> tmpl = null;
        for (Class<?> infType : infTypes) {
            tmpl = this.cache.get(infType);
            if (tmpl != null) {
                this.register(targetClass, tmpl);
                return tmpl;
            }
            try {
                tmpl = this.parent.lookupCache(infType);
                if (tmpl == null) continue;
                this.register(targetClass, tmpl);
                return tmpl;
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        return tmpl;
    }

    private <T> Template<T> lookupSuperclasses(Class<T> targetClass) {
        Class<T> superClass;
        Template<Type> tmpl = null;
        if (superClass != null) {
            for (superClass = targetClass.getSuperclass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
                tmpl = this.cache.get(superClass);
                if (tmpl != null) {
                    this.register(targetClass, tmpl);
                    return tmpl;
                }
                try {
                    tmpl = this.parent.lookupCache(superClass);
                    if (tmpl != null) {
                        this.register(targetClass, tmpl);
                        return tmpl;
                    }
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        return tmpl;
    }

    private <T> Template<T> lookupSuperclassInterfaceTypes(Class<T> targetClass) {
        Class<T> superClass;
        Template<Object> tmpl = null;
        if (superClass != null) {
            for (superClass = targetClass.getSuperclass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
                tmpl = this.lookupInterfaceTypes(superClass);
                if (tmpl != null) {
                    this.register(targetClass, tmpl);
                    return tmpl;
                }
                try {
                    tmpl = this.parent.lookupCache(superClass);
                    if (tmpl != null) {
                        this.register(targetClass, tmpl);
                        return tmpl;
                    }
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        return tmpl;
    }

    private synchronized Template buildAndRegister(TemplateBuilder builder, Class targetClass, boolean hasAnnotation, FieldList flist) {
        Template newTmpl = null;
        Template<Type> oldTmpl = null;
        try {
            if (this.cache.containsKey(targetClass)) {
                oldTmpl = this.cache.get(targetClass);
            }
            newTmpl = new TemplateReference(this, targetClass);
            this.cache.put(targetClass, newTmpl);
            if (builder == null) {
                builder = this.chain.select(targetClass, hasAnnotation);
            }
            Template template = newTmpl = flist != null ? builder.buildTemplate(targetClass, flist) : builder.buildTemplate(targetClass);
            return template;
        }
        catch (Exception e) {
            if (oldTmpl != null) {
                this.cache.put(targetClass, oldTmpl);
            } else {
                this.cache.remove(targetClass);
            }
            newTmpl = null;
            if (e instanceof MessageTypeException) {
                throw (MessageTypeException)e;
            }
            throw new MessageTypeException(e);
        }
        finally {
            if (newTmpl != null) {
                this.cache.put(targetClass, newTmpl);
            }
        }
    }

    private static boolean isPrimitiveType(String genericCompTypeName) {
        return genericCompTypeName.equals("byte") || genericCompTypeName.equals("short") || genericCompTypeName.equals("int") || genericCompTypeName.equals("long") || genericCompTypeName.equals("float") || genericCompTypeName.equals("double") || genericCompTypeName.equals("boolean") || genericCompTypeName.equals("char");
    }

    private static String toJvmReferenceTypeName(String typeName) {
        return typeName.substring(6);
    }

    private static String toJvmPrimitiveTypeName(String typeName) {
        if (typeName.equals("byte")) {
            return "B";
        }
        if (typeName.equals("short")) {
            return "S";
        }
        if (typeName.equals("int")) {
            return "I";
        }
        if (typeName.equals("long")) {
            return "J";
        }
        if (typeName.equals("float")) {
            return "F";
        }
        if (typeName.equals("double")) {
            return "D";
        }
        if (typeName.equals("boolean")) {
            return "Z";
        }
        if (typeName.equals("char")) {
            return "C";
        }
        throw new MessageTypeException(String.format("fatal error: type=%s", typeName));
    }
}

