/*
 * Decompiled with CFR 0.152.
 */
package vivid.shaded.org.msgpack.type;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import vivid.shaded.org.msgpack.packer.Packer;
import vivid.shaded.org.msgpack.type.FloatValue;
import vivid.shaded.org.msgpack.type.Value;

class FloatValueImpl
extends FloatValue {
    private float value;

    FloatValueImpl(float value) {
        this.value = value;
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public BigInteger bigIntegerValue() {
        return new BigDecimal(this.value).toBigInteger();
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        Value v = (Value)o;
        if (!v.isFloatValue()) {
            return false;
        }
        return (double)this.value == v.asFloatValue().getDouble();
    }

    @Override
    public void writeTo(Packer pk) throws IOException {
        pk.write(this.value);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public String toString() {
        return Float.toString(this.value);
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        return sb.append(Float.toString(this.value));
    }
}

