/*
 * Decompiled with CFR 0.152.
 */
package vivid.shaded.org.msgpack.type;

import java.io.IOException;
import java.math.BigInteger;
import vivid.shaded.org.msgpack.MessageTypeException;
import vivid.shaded.org.msgpack.packer.Packer;
import vivid.shaded.org.msgpack.type.IntegerValue;
import vivid.shaded.org.msgpack.type.Value;

class LongValueImpl
extends IntegerValue {
    private long value;
    private static long BYTE_MAX = 127L;
    private static long SHORT_MAX = 32767L;
    private static long INT_MAX = Integer.MAX_VALUE;
    private static long BYTE_MIN = -128L;
    private static long SHORT_MIN = -32768L;
    private static long INT_MIN = Integer.MIN_VALUE;

    LongValueImpl(long value) {
        this.value = value;
    }

    @Override
    public byte getByte() {
        if (this.value > BYTE_MAX || this.value < BYTE_MIN) {
            throw new MessageTypeException();
        }
        return (byte)this.value;
    }

    @Override
    public short getShort() {
        if (this.value > SHORT_MAX || this.value < SHORT_MIN) {
            throw new MessageTypeException();
        }
        return (short)this.value;
    }

    @Override
    public int getInt() {
        if (this.value > INT_MAX || this.value < INT_MIN) {
            throw new MessageTypeException();
        }
        return (int)this.value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public void writeTo(Packer pk) throws IOException {
        pk.write(this.value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        Value v = (Value)o;
        if (!v.isIntegerValue()) {
            return false;
        }
        try {
            return this.value == v.asIntegerValue().getLong();
        }
        catch (MessageTypeException ex) {
            return false;
        }
    }

    public int hashCode() {
        if (INT_MIN <= this.value && this.value <= INT_MAX) {
            return (int)this.value;
        }
        return (int)(this.value ^ this.value >>> 32);
    }

    public String toString() {
        return Long.toString(this.value);
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        return sb.append(Long.toString(this.value));
    }
}

