/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.accesscontrols;

import com.atlassian.crowd.embedded.api.Group;
import io.vavr.collection.HashMap;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import vivid.trace.accesscontrols.ACPrincipal;
import vivid.trace.components.Factory;
import vivid.trace.components.Providers;

public class GroupACPrincipal
implements ACPrincipal,
Providers.Provider<Factory> {
    public static final String TYPE_group = "group";

    @Override
    public String getKey() {
        return TYPE_group;
    }

    @Override
    public boolean isEqual(String id, ACPrincipal.Context context) {
        return context.f.groupManager.isUserInGroup(context.user, context.f.groupManager.getGroup(id));
    }

    @Override
    public Option<String> nameFor(String id, Option<Factory> factoryOption) {
        return Option.of(id);
    }

    @Override
    public void provideData(Factory factory, Map<String, Object> accumulator) {
        Collection systemGroups = factory.groupManager.getAllGroups();
        ArrayList<Map> groups = new ArrayList<Map>(systemGroups.size());
        for (Group group : systemGroups) {
            groups.add(HashMap.of("id", group.getName(), "name", group.getName(), "type", TYPE_group).toJavaMap());
        }
        accumulator.put(this.getKey(), groups);
    }
}

