/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.accesscontrols;

import com.atlassian.jira.security.roles.ProjectRole;
import io.vavr.collection.HashMap;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import vivid.trace.accesscontrols.ACPrincipal;
import vivid.trace.components.Factory;
import vivid.trace.components.Providers;

public class ProjectRoleACPrincipal
implements ACPrincipal,
Providers.Provider<Factory> {
    public static final String TYPE_project_role = "project-role";

    @Override
    public String getKey() {
        return TYPE_project_role;
    }

    @Override
    public boolean isEqual(String id, ACPrincipal.Context context) {
        try {
            ProjectRole projectRole = context.f.projectRoleManager.getProjectRole(Long.valueOf(id));
            if (context.f.projectRoleManager.isUserInProjectRole(context.user, projectRole, context.project)) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public static Option<ProjectRole> projectRoleForId(String id, Factory factory) {
        try {
            Long idLong = Long.parseLong(id);
            ProjectRole projectRole = factory.projectRoleManager.getProjectRole(idLong);
            return Option.of(projectRole);
        }
        catch (Exception e) {
            return Option.none();
        }
    }

    @Override
    public Option<String> nameFor(String id, Option<Factory> factoryOption) {
        if (factoryOption.isDefined()) {
            Option<ProjectRole> projectRole = ProjectRoleACPrincipal.projectRoleForId(id, factoryOption.get());
            return projectRole.map(ProjectRole::getName);
        }
        return Option.none();
    }

    @Override
    public void provideData(Factory factory, Map<String, Object> accumulator) {
        Collection projectRoles = factory.projectRoleManager.getProjectRoles();
        ArrayList<Map> roles = new ArrayList<Map>(projectRoles.size());
        for (ProjectRole role : projectRoles) {
            roles.add(HashMap.of("id", role.getId(), "name", role.getName(), "type", TYPE_project_role).toJavaMap());
        }
        accumulator.put(this.getKey(), roles);
    }
}

