/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.accesscontrols;

import com.atlassian.jira.user.ApplicationUser;
import io.vavr.Tuple2;
import io.vavr.collection.Stream;
import io.vavr.control.Option;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import vivid.trace.accesscontrols.ACLAlgorithm;
import vivid.trace.accesscontrols.AccessControls;

@Named
public class TraceConfigurationAccessControl {
    public static final String TRACE_CONFIGURATION_AO_OBJECT_TYPE = "trace-configuration";
    private final AccessControls accessControls;
    private final ACLAlgorithm aclAlgorithm;

    @Inject
    public TraceConfigurationAccessControl(AccessControls accessControls, ACLAlgorithm aclAlgorithm) {
        this.accessControls = accessControls;
        this.aclAlgorithm = aclAlgorithm;
    }

    public boolean canAccess(int traceConfigurationId, ApplicationUser user, TraceConfigurationAccess requestedLevel) {
        return (Boolean)this.canAccessPlusAcl((int)traceConfigurationId, (ApplicationUser)user, (TraceConfigurationAccess)requestedLevel)._1;
    }

    public Tuple2<Boolean, Collection<Map<String, String>>> canAccessPlusAcl(int traceConfigurationId, ApplicationUser user, TraceConfigurationAccess requestedLevel) {
        Collection<Map<String, String>> acl = this.getAcl(traceConfigurationId);
        boolean canAccess = this.aclAlgorithm.hasAccessP(acl, user, requestedLevel::satisfies);
        return new Tuple2<Boolean, Collection<Map<String, String>>>(canAccess, acl);
    }

    private static Collection<Map<String, String>> defaultACL(ApplicationUser user) {
        return Collections.singletonList(AccessControls.makeInterchangeValue("user", user.getKey()));
    }

    public void delete(Integer traceConfigurationId) {
        this.accessControls.deleteObject(TRACE_CONFIGURATION_AO_OBJECT_TYPE, traceConfigurationId.toString());
    }

    public Option<TraceConfigurationAccess> effectiveAccess(int traceConfigurationId, ApplicationUser user) {
        Collection<Map<String, String>> aces = this.aclAlgorithm.accessAcesP(this.getAcl(traceConfigurationId), user, TraceConfigurationAccess.VIEWER::satisfies, ACLAlgorithm.Mode.ALL_ACES);
        Option<TraceConfigurationAccess> effectiveAccess = Option.none();
        for (Map<String, String> ace : aces) {
            boolean isHigher;
            Option<TraceConfigurationAccess> access = TraceConfigurationAccess.getByValue(ace.get("aspect"));
            if (!access.isDefined() || !(isHigher = effectiveAccess.isEmpty() || access.get().exceeds(effectiveAccess.get()))) continue;
            effectiveAccess = access;
        }
        return effectiveAccess;
    }

    public Collection<Map<String, String>> getAcl(int traceConfigurationId) {
        return this.accessControls.getValues(TRACE_CONFIGURATION_AO_OBJECT_TYPE, Integer.toString(traceConfigurationId), TraceConfigurationAccess.all);
    }

    public boolean hasAtLeastOneOwner(Collection<Map<String, String>> acl) {
        for (Map<String, String> ace : acl) {
            String aspect = ace.get("aspect");
            if (!TraceConfigurationAccess.OWNER.value.equalsIgnoreCase(aspect)) continue;
            return true;
        }
        return false;
    }

    public void set(Integer traceId, ApplicationUser user, TraceConfigurationAccess traceConfigurationAccess) {
        this.accessControls.setValues(TRACE_CONFIGURATION_AO_OBJECT_TYPE, traceId.toString(), traceConfigurationAccess.value, TraceConfigurationAccessControl.defaultACL(user));
    }

    public void setACL(String traceId, Collection<Map<String, String>> acl) {
        this.accessControls.setValues(TRACE_CONFIGURATION_AO_OBJECT_TYPE, traceId, acl, TraceConfigurationAccess.all);
    }

    public static enum TraceConfigurationAccess {
        VIEWER("viewer", 1),
        EDITOR("editor", 2),
        OWNER("owner", 3);

        final String value;
        private final int level;
        private static final io.vavr.collection.Map<String, TraceConfigurationAccess> byValue;
        protected static final List<String> all;

        private TraceConfigurationAccess(String key, int level) {
            this.value = key;
            this.level = level;
        }

        public static Option<TraceConfigurationAccess> getByValue(String value) {
            return byValue.get(value);
        }

        public final boolean satisfies(Option<TraceConfigurationAccess> aceAccess) {
            return aceAccess.isDefined() && this.level <= aceAccess.get().level;
        }

        public final boolean exceeds(TraceConfigurationAccess extantLevel) {
            return this.level > extantLevel.level;
        }

        public String toString() {
            return this.value.toLowerCase();
        }

        static {
            byValue = Stream.ofAll(Arrays.asList(TraceConfigurationAccess.values())).toMap(v -> new Tuple2<String, TraceConfigurationAccess>(v.value, (TraceConfigurationAccess)((Object)v)));
            all = Stream.ofAll(Arrays.asList(TraceConfigurationAccess.values())).map(x -> x.value).toJavaList();
        }
    }
}

