/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.accesscontrols;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import io.vavr.Tuple2;
import io.vavr.collection.Map;
import io.vavr.collection.Stream;
import io.vavr.collection.TreeMap;
import io.vavr.control.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import vivid.trace.accesscontrols.ACPrincipal;
import vivid.trace.accesscontrols.AccessControls;
import vivid.trace.accesscontrols.GroupACPrincipal;
import vivid.trace.accesscontrols.ProjectRoleACPrincipal;
import vivid.trace.accesscontrols.SystemACPrincipal;
import vivid.trace.accesscontrols.UserACPrincipal;
import vivid.trace.components.Factory;

@Named
public class TraceVisibilityAccessControl {
    private static final String INTERCHANGE_ACTIVE_KEY = "active";
    private static final String INTERCHANGE_NAME_KEY = "name";
    private static final Collection<java.util.Map<String, String>> DEFAULT_PROJECT_CONTEXTUAL_TRACE_VISIBILITY = Collections.singletonList(AccessControls.makeInterchangeValue("system", "signed-in-users"));
    private static final java.util.Map<String, String> EMPTY_MARKER = AccessControls.makeInterchangeValue("system", "defined");
    private static final Collection<java.util.Map<String, String>> EMPTY_TRACE_VISIBILITY = Collections.singletonList(EMPTY_MARKER);
    private static final io.vavr.collection.List<ACPrincipal> ALL_AC_PRINCIPALS = io.vavr.collection.List.of(new SystemACPrincipal(), new GroupACPrincipal(), new UserACPrincipal(), new ProjectRoleACPrincipal());
    private static final Map<String, ACPrincipal> PRINCIPAL_MAP = ALL_AC_PRINCIPALS.toMap(acPrincipal -> new Tuple2<String, ACPrincipal>(acPrincipal.getKey(), (ACPrincipal)acPrincipal));
    private final AccessControls accessControls;
    private final Factory factory;

    @Inject
    public TraceVisibilityAccessControl(AccessControls accessControls, Factory factory) {
        this.accessControls = accessControls;
        this.factory = factory;
    }

    private static String nameFor(Option<Factory> factoryOption, String type, String id) {
        Option<String> nameOption;
        Option<ACPrincipal> principalOpt = PRINCIPAL_MAP.get(type);
        if (principalOpt.isDefined() && (nameOption = principalOpt.get().nameFor(id, factoryOption)).isDefined()) {
            return nameOption.get();
        }
        return id;
    }

    private static boolean isSystemDefinedEmptyMarker(java.util.Map<String, String> member) {
        return EMPTY_MARKER.equals(member);
    }

    public void deleteForAddOn() {
        this.accessControls.deleteObjectAspect("addon", "0", "trace-visibility");
    }

    public void deleteForProject(Project project) {
        this.accessControls.deleteObjectAspect("project", project.getId().toString(), "trace-visibility");
    }

    private static Map<String, String> accountData(java.util.Map<String, String> member, Option<Factory> factoryOption) {
        ApplicationUser user;
        String principalType;
        if (factoryOption.isDefined() && "user".equals(principalType = member.get("type")) && ((user = factoryOption.get().userManager.getUserByKey(member.get("id"))) == null || !user.isActive())) {
            return TreeMap.of(INTERCHANGE_ACTIVE_KEY, "false");
        }
        return TreeMap.empty();
    }

    public static List<java.util.Map<String, String>> embellishWithFields(Collection<java.util.Map<String, String>> members, OptionalFields[] fields, Factory factory) {
        return Stream.ofAll(members).map(member -> ((TreeMap)((TreeMap)TreeMap.ofAll(member).merge(TraceVisibilityAccessControl.accountData(member, Option.of(factory)))).merge(Stream.of(fields).toMap(optionalFields -> optionalFields.embellish((java.util.Map<String, String>)member, Option.of(factory))))).toJavaMap()).toJavaList();
    }

    public Collection<java.util.Map<String, String>> getForAddOn(OptionalFields ... fields) {
        Collection<java.util.Map<String, String>> members = this.accessControls.getValues("addon", "0", Collections.singleton("trace-visibility"));
        if (members == null || members.isEmpty()) {
            return TraceVisibilityAccessControl.embellishWithFields(DEFAULT_PROJECT_CONTEXTUAL_TRACE_VISIBILITY, fields, this.factory);
        }
        if (members.size() == 1 && TraceVisibilityAccessControl.isSystemDefinedEmptyMarker(members.iterator().next())) {
            return Collections.emptyList();
        }
        return TraceVisibilityAccessControl.embellishWithFields(members, fields, this.factory);
    }

    public Option<Collection<java.util.Map<String, String>>> getForProject(Project project, OptionalFields ... fields) {
        Collection<java.util.Map<String, String>> members = this.accessControls.getValues("project", project.getId().toString(), Collections.singleton("trace-visibility"));
        if (members == null || members.isEmpty()) {
            return Option.none();
        }
        if (members.size() == 1 && TraceVisibilityAccessControl.isSystemDefinedEmptyMarker(members.iterator().next())) {
            return Option.of(Collections.emptyList());
        }
        return Option.of(TraceVisibilityAccessControl.embellishWithFields(members, fields, this.factory));
    }

    public Collection<java.util.Map<String, String>> getComputedForProject(Project project, OptionalFields ... fields) {
        Option<Collection<java.util.Map<String, String>>> projectValue = this.getForProject(project, fields);
        return projectValue.isDefined() ? projectValue.get() : this.getForAddOn(fields);
    }

    public boolean isVisibleToUser(Project project, ApplicationUser user, Factory f) {
        ACPrincipal.Context context = new ACPrincipal.Context(project, user, f);
        Collection<java.util.Map<String, String>> visibility = this.getComputedForProject(project, new OptionalFields[0]);
        for (java.util.Map<String, String> entry : visibility) {
            Option<ACPrincipal> principalOpt;
            String type = entry.get("type");
            String id = entry.get("id");
            if (!PRINCIPAL_MAP.containsKey(type) || !(principalOpt = PRINCIPAL_MAP.get(type)).isDefined() || !principalOpt.get().isEqual(id, context)) continue;
            return true;
        }
        return false;
    }

    public void setForAddOn(Collection<java.util.Map<String, String>> membership) {
        this.set(membership, "addon", "0");
    }

    public void setForProject(Project project, Collection<java.util.Map<String, String>> membership) {
        this.set(membership, "project", project.getId().toString());
    }

    private void set(Collection<java.util.Map<String, String>> membership, String scope, String objectId) {
        Collection<java.util.Map<String, String>> m = membership != null && !membership.isEmpty() ? membership : EMPTY_TRACE_VISIBILITY;
        this.accessControls.setValues(scope, objectId, "trace-visibility", m);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum OptionalFields {
        NAME{

            @Override
            Tuple2<String, String> embellish(java.util.Map<String, String> member, Option<Factory> factoryOption) {
                return new Tuple2<String, String>(TraceVisibilityAccessControl.INTERCHANGE_NAME_KEY, TraceVisibilityAccessControl.nameFor(factoryOption, member.get("type"), member.get("id")));
            }
        };


        abstract Tuple2<String, String> embellish(java.util.Map<String, String> var1, Option<Factory> var2);
    }
}

