/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.accesscontrols;

import com.atlassian.jira.user.ApplicationUser;
import io.vavr.collection.HashMap;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import vivid.trace.accesscontrols.ACPrincipal;
import vivid.trace.components.Factory;
import vivid.trace.components.Providers;

public class UserACPrincipal
implements ACPrincipal,
Providers.Provider<Factory> {
    public static final String TYPE_user = "user";

    @Override
    public String getKey() {
        return TYPE_user;
    }

    @Override
    public boolean isEqual(String id, ACPrincipal.Context context) {
        ApplicationUser expected = context.user;
        ApplicationUser actual = context.f.userManager.getUserByKey(id);
        return expected != null && expected.equals((Object)actual);
    }

    @Override
    public Option<String> nameFor(String id, Option<Factory> factoryOption) {
        if (factoryOption.isEmpty()) {
            return Option.none();
        }
        ApplicationUser user = factoryOption.get().userManager.getUserByKey(id);
        return user != null ? Option.of(user.getDisplayName()) : Option.none();
    }

    public static Option<Map<String, String>> userData(@Nullable ApplicationUser user) {
        if (user == null) {
            return Option.none();
        }
        HashMap more = user.isActive() ? HashMap.empty() : HashMap.of("active", "false");
        return Option.of(((HashMap)HashMap.of("id", user.getKey(), "name", user.getDisplayName(), "type", TYPE_user).merge((io.vavr.collection.Map)more)).toJavaMap());
    }

    @Override
    public void provideData(Factory factory, Map<String, Object> accumulator) {
        Collection systemUsers = factory.userManager.getAllApplicationUsers();
        ArrayList<Map<String, String>> users = new ArrayList<Map<String, String>>(systemUsers.size());
        for (ApplicationUser user : systemUsers) {
            Option<Map<String, String>> ud = UserACPrincipal.userData(user);
            if (!ud.isDefined()) continue;
            users.add(ud.get());
        }
        accumulator.put(this.getKey(), users);
    }
}

