/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.ao.v2021_1_7;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.vavr.control.Option;
import net.java.ao.Entity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vivid.lib.Strings;
import vivid.lib.atlassian.ActiveObjectz;
import vivid.trace.ao.AccessControlAO;
import vivid.trace.ao.MRUAO;
import vivid.trace.ao.ObjectKeyValueAO;
import vivid.trace.ao.TraceConfigurationAO;

public class V20210107_UpgradeTask_00_AccessControl
implements ActiveObjectsUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(V20210107_UpgradeTask_00_AccessControl.class);
    private static final String ACTIVE_OBJECTS_MODEL_VERSION_2021010700 = "2021010700";
    private static final String TYPE_USER = "user";
    private final UserManager userManager;

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)ACTIVE_OBJECTS_MODEL_VERSION_2021010700);
    }

    public V20210107_UpgradeTask_00_AccessControl(@ComponentImport UserManager userManager) {
        this.userManager = userManager;
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects activeObjects) {
        this.convertUsernameToKeyInAccessControlAO(activeObjects);
        this.convertUsernameToKeyInMRUAO(activeObjects);
        this.convertUsernameToKeyInObjectKeyValueAO(activeObjects);
        this.convertUsernameToKeyInTraceConfigurationAO(activeObjects);
    }

    private Option<String> usernameToKey(String username) {
        ApplicationUser user = this.userManager.getUserByName(username);
        if (user == null) {
            return Option.none();
        }
        String newUserId = user.getKey();
        return Strings.isBlank(newUserId) ? Option.of(newUserId) : Option.none();
    }

    private static void logMigration(Class<?> clazz, Entity entity, String username, Option<String> key) {
        if (key.isDefined()) {
            log.info("ActiveObjects class {} object ID {}: Migrating ApplicationUser username '{}' to key '{}'", new Object[]{clazz, entity.getID(), username, key});
        } else {
            log.warn("ActiveObjects class {} object ID {}: UserManager.getUserByName() returned null for username '{}'; leaving this username-based record as-is.", new Object[]{clazz, entity.getID(), username});
        }
    }

    private void convertUsernameToKeyInAccessControlAO(ActiveObjects activeObjects) {
        activeObjects.migrate(new Class[]{AccessControlAO.class});
        ActiveObjectz.pagedExecution(activeObjects, AccessControlAO.class, entity -> {
            if (!TYPE_USER.equalsIgnoreCase(entity.getPrincipalType())) {
                return;
            }
            String username = entity.getPrincipalId();
            Option<String> key = this.usernameToKey(username);
            V20210107_UpgradeTask_00_AccessControl.logMigration(AccessControlAO.class, entity, username, key);
            if (key.isEmpty()) {
                return;
            }
            entity.setPrincipalId(key.get());
            entity.save();
        }, this.getClass());
    }

    private void convertUsernameToKeyInMRUAO(ActiveObjects activeObjects) {
        activeObjects.migrate(new Class[]{MRUAO.class});
        ActiveObjectz.pagedExecution(activeObjects, MRUAO.class, entity -> {
            String username = entity.getUserKey();
            Option<String> key = this.usernameToKey(username);
            V20210107_UpgradeTask_00_AccessControl.logMigration(MRUAO.class, entity, username, key);
            if (key.isEmpty()) {
                return;
            }
            entity.setUserKey(key.get());
            entity.save();
        }, this.getClass());
    }

    private void convertUsernameToKeyInObjectKeyValueAO(ActiveObjects activeObjects) {
        activeObjects.migrate(new Class[]{ObjectKeyValueAO.class});
        ActiveObjectz.pagedExecution(activeObjects, ObjectKeyValueAO.class, entity -> {
            if (!TYPE_USER.equalsIgnoreCase(entity.getObjectType())) {
                return;
            }
            String username = entity.getObjectId();
            Option<String> key = this.usernameToKey(username);
            V20210107_UpgradeTask_00_AccessControl.logMigration(ObjectKeyValueAO.class, entity, username, key);
            if (key.isEmpty()) {
                return;
            }
            entity.setObjectId(key.get());
            entity.save();
        }, this.getClass());
    }

    private void convertUsernameToKeyInTraceConfigurationAO(ActiveObjects activeObjects) {
        activeObjects.migrate(new Class[]{TraceConfigurationAO.class});
        ActiveObjectz.pagedExecution(activeObjects, TraceConfigurationAO.class, entity -> {
            String username = entity.getCreatedBy();
            Option<String> key = this.usernameToKey(username);
            V20210107_UpgradeTask_00_AccessControl.logMigration(TraceConfigurationAO.class, entity, username, key);
            if (key.isEmpty()) {
                return;
            }
            entity.setCreatedBy(key.get());
            entity.save();
        }, this.getClass());
    }
}

