/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.ao.v2025_1_0;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.vavr.collection.HashMap;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vivid.lib.Strings;
import vivid.lib.atlassian.ActiveObjectz;
import vivid.lib.compatibility.Jackson;
import vivid.trace.ao.AccessControlAO;
import vivid.trace.ao.TraceConfigurationAO;
import vivid.trace.datatypes.ObjectKeyValue;

public class V20250100_UpgradeTask_00_ProjectConfiguration
implements ActiveObjectsUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(V20250100_UpgradeTask_00_ProjectConfiguration.class);
    private final ProjectManager projectManager;
    private static final String VT_2021_1_ENABLED_ARTIFACT_TYPE_IDS_AO_KEY = "enabled-artifact-type-ids";
    private static final String VT_2021_1_ENABLED_ISSUE_LINK_TYPE_IDS_AO_KEY = "enabled-issue-link-type-ids";
    private static final String VT_2021_1_ISSUE_FIELD_LAYOUT_JSON_AO_KEY = "issue-field-layout-json";
    private static final String VT_2021_1_ISSUE_FIELD_LAYOUT_JSON_KEY = "issueFieldsJson";
    private static final String VT_2025_1_CONTEXTUAL_TRACE_CONFIGURATION_QUICK_LIST = "contextual-trace-configuration-quick-list";
    private static final String VT_2025_1_DISTANCE_KEY = "distance";
    private static final String VT_2025_1_ENABLED_ARTIFACT_TYPES_KEY = "artifactTypes";
    private static final String VT_2025_1_ENABLED_ISSUE_LINK_TYPES_KEY = "issueLinkTypes";
    private static final String VT_2025_1_ITEM_CARD_LAYOUT_EDN_KEY = "itemCardLayout";
    private static final String VT_2025_1_OKV_PRINCIPAL_TYPE_USER = "user";
    private static final String VT_2025_1_RELATIONS_SEED_ISSUES_ARG_KEY = "relationsSeedIssuesArg";
    private static final String VT_2025_1_SYSTEMACPRINCIPAL_TYPE_system = "system";
    private static final String VT_2025_1_SYSTEMACPRINCIPAL_ID_signed_in_users = "signed-in-users";
    private static final String VT_2025_1_TRACECONFIGURATIONACCESS_OWNER = "owner";
    private static final String VT_2025_1_TRACECONFIGURATIONACCESS_VIEWER = "viewer";
    private static final String VT_2025_1_TRACE_CONFIGURATION_AO_OBJECT_TYPE = "trace-configuration";
    private static final String ACTIVE_OBJECTS_MODEL_VERSION_2025010000 = "2025010000";
    private static final Map<String, String> namedFieldMapping;

    public V20250100_UpgradeTask_00_ProjectConfiguration(@ComponentImport ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)ACTIVE_OBJECTS_MODEL_VERSION_2025010000);
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects activeObjects) {
        this.convertTraceConfigurations(activeObjects);
        V20250100_UpgradeTask_00_ProjectConfiguration.convertProjectConfigurations(activeObjects, this.projectManager);
    }

    private void convertTraceConfigurations(ActiveObjects activeObjects) {
        ActiveObjectz.pagedExecution(activeObjects, TraceConfigurationAO.class, entity -> {
            String newConfigurationJson;
            Map<String, String> oldConfiguration;
            String log_prefix = "Trace configuration ID " + entity.getID() + ": ";
            String log_suffix = "; skipping. This trace configuration will lose its item card layout.";
            String configurationJson = entity.getConfiguration();
            try {
                oldConfiguration = Jackson.readValue(configurationJson, new Jackson.TypeReference<Map<String, String>>(){});
            }
            catch (IOException e) {
                log.warn(log_prefix + "Could not parse configuration JSON string; skipping. This trace configuration will lose its item card layout.");
                return;
            }
            String issueFieldLayout = oldConfiguration.get(VT_2021_1_ISSUE_FIELD_LAYOUT_JSON_KEY);
            Either<Exception, String> itemCardLayout = V20250100_UpgradeTask_00_ProjectConfiguration.convertIssueFieldLayoutToItemCardLayout(issueFieldLayout);
            if (itemCardLayout.isLeft()) {
                log.warn(log_prefix + "Failed to convert issue field layout JSON; skipping. This trace configuration will lose its item card layout.");
                return;
            }
            java.util.HashMap<String, String> newConfiguration = new java.util.HashMap<String, String>(oldConfiguration);
            newConfiguration.put(VT_2025_1_ITEM_CARD_LAYOUT_EDN_KEY, itemCardLayout.get());
            try {
                newConfigurationJson = Jackson.writeValueAsString(newConfiguration);
            }
            catch (IOException e) {
                log.warn(log_prefix + "Failed to write map as JSON string; skipping. This trace configuration will lose its item card layout.");
                return;
            }
            entity.setConfiguration(newConfigurationJson);
            entity.save();
        }, this.getClass());
    }

    private static void convertProjectConfigurations(ActiveObjects activeObjects, ProjectManager projectManager) {
        List projects = projectManager.getProjectObjects();
        for (Project project : projects) {
            V20250100_UpgradeTask_00_ProjectConfiguration.convertProjectConfiguration(activeObjects, project);
        }
    }

    private static void convertProjectConfiguration(ActiveObjects activeObjects, Project project) {
        String configurationJson;
        Option<String> issueLinkTypes;
        String log_prefix = "Project key '" + project.getKey() + "' (project ID " + project.getId() + "): ";
        String log_skipSuffix = "; skipping. This project will fall back to the system default quick list.";
        log.info(log_prefix + "Converting project configuration to trace configuration and default quick list entry.");
        Option<String> issueFieldLayoutJson = ObjectKeyValue.getValue(activeObjects, V20250100_UpgradeTask_00_ProjectConfiguration.makeCompositeKeyForOKVProject(project, VT_2021_1_ISSUE_FIELD_LAYOUT_JSON_AO_KEY));
        if (issueFieldLayoutJson.isEmpty()) {
            log.warn(log_prefix + "ActiveObjects key 'issue-field-layout-json' not defined for this project; skipping. This project will fall back to the system default quick list.");
            return;
        }
        Either<Exception, String> itemCardLayoutEdn = V20250100_UpgradeTask_00_ProjectConfiguration.convertIssueFieldLayoutToItemCardLayout(issueFieldLayoutJson.get());
        if (itemCardLayoutEdn.isEmpty()) {
            log.warn(log_prefix + "Failed to parse the JSON value for ActiveObjects key 'issue-field-layout-json'; skipping. This project will fall back to the system default quick list.");
            return;
        }
        java.util.HashMap<String, Object> configuration = new java.util.HashMap<String, Object>();
        configuration.put(VT_2025_1_DISTANCE_KEY, "2");
        configuration.put(VT_2025_1_ITEM_CARD_LAYOUT_EDN_KEY, itemCardLayoutEdn.get());
        configuration.put(VT_2025_1_RELATIONS_SEED_ISSUES_ARG_KEY, "project = " + project.getId());
        Option<String> artifactTypes = ObjectKeyValue.getValue(activeObjects, V20250100_UpgradeTask_00_ProjectConfiguration.makeCompositeKeyForOKVProject(project, VT_2021_1_ENABLED_ARTIFACT_TYPE_IDS_AO_KEY));
        if (artifactTypes.isDefined()) {
            configuration.put(VT_2025_1_ENABLED_ARTIFACT_TYPES_KEY, "[" + artifactTypes.get() + "]");
        }
        if ((issueLinkTypes = ObjectKeyValue.getValue(activeObjects, V20250100_UpgradeTask_00_ProjectConfiguration.makeCompositeKeyForOKVProject(project, VT_2021_1_ENABLED_ISSUE_LINK_TYPE_IDS_AO_KEY))).isDefined()) {
            configuration.put(VT_2025_1_ENABLED_ISSUE_LINK_TYPES_KEY, "[" + issueLinkTypes.get() + "]");
        }
        try {
            configurationJson = Jackson.writeValueAsString(configuration);
        }
        catch (IOException e) {
            log.warn(log_prefix + "Failed to write Java map as JSON string; skipping. This project will fall back to the system default quick list.");
            return;
        }
        String traceConfigurationName = "Project " + project.getId() + " (Provisional)";
        TraceConfigurationAO traceConfigurationAO = (TraceConfigurationAO)activeObjects.executeInTransaction(() -> (TraceConfigurationAO)activeObjects.create(TraceConfigurationAO.class, HashMap.of("C", configurationJson, "T", Instant.now().toEpochMilli(), "N", traceConfigurationName).toJavaMap()));
        ObjectKeyValue.updateOrCreate(activeObjects, V20250100_UpgradeTask_00_ProjectConfiguration.makeCompositeKeyForOKVProject(project, VT_2025_1_CONTEXTUAL_TRACE_CONFIGURATION_QUICK_LIST), V20250100_UpgradeTask_00_ProjectConfiguration.quickListEdnString(traceConfigurationAO));
        ApplicationUser projectLead = project.getProjectLead();
        if (projectLead == null) {
            log.warn(log_prefix + "Failed to get the project lead for the project; with no owner this trace configuration will be set to read-only.");
        } else {
            activeObjects.create(AccessControlAO.class, HashMap.of("OBJ", VT_2025_1_TRACE_CONFIGURATION_AO_OBJECT_TYPE, "OI", String.valueOf(traceConfigurationAO.getID()), "ASPECT", VT_2025_1_TRACECONFIGURATIONACCESS_OWNER, "PTYPE", VT_2025_1_OKV_PRINCIPAL_TYPE_USER, "PID", projectLead.getKey()).toJavaMap());
        }
        activeObjects.create(AccessControlAO.class, HashMap.of("OBJ", VT_2025_1_TRACE_CONFIGURATION_AO_OBJECT_TYPE, "OI", String.valueOf(traceConfigurationAO.getID()), "ASPECT", VT_2025_1_TRACECONFIGURATIONACCESS_VIEWER, "PTYPE", VT_2025_1_SYSTEMACPRINCIPAL_TYPE_system, "PID", VT_2025_1_SYSTEMACPRINCIPAL_ID_signed_in_users).toJavaMap());
    }

    private static String quickListEdnString(TraceConfigurationAO traceConfigurationAO) {
        return "({:contextual-seed-issues-query-mode :override :id " + traceConfigurationAO.getID() + " :default true})";
    }

    private static ObjectKeyValue.CompositeKey makeCompositeKeyForOKVProject(final Project project, final String key) {
        return new ObjectKeyValue.CompositeKey(){

            @Override
            public String getObjectType() {
                return "project";
            }

            @Override
            public String getObjectId() {
                return String.valueOf(project.getId());
            }

            @Override
            public String getKey() {
                return key;
            }
        };
    }

    private static int determineWidthOfNamedField(String namedFieldName) {
        return "issuetype".equalsIgnoreCase(namedFieldName) || "priority".equalsIgnoreCase(namedFieldName) ? 1 : 5;
    }

    private static String mapFieldId(String fieldId) {
        if (namedFieldMapping.containsKey(fieldId)) {
            return namedFieldMapping.get(fieldId);
        }
        return ":jira.issue-field.cftype/" + fieldId;
    }

    private static Either<Exception, String> convertIssueFieldLayoutToItemCardLayout(String issueFieldLayoutJson) {
        if (Strings.isBlank(issueFieldLayoutJson)) {
            return Either.left(new IllegalArgumentException("issueFieldLayoutJson is blank"));
        }
        try {
            StringBuilder edn = new StringBuilder("[");
            int x = 0;
            int y = 0;
            List<List<Map<String, String>>> rows = Jackson.readValue(issueFieldLayoutJson, new Jackson.TypeReference<List<List<Map<String, String>>>>(){});
            for (List<Map<String, String>> row : rows) {
                for (Map<String, String> field : row) {
                    String id = field.get("id");
                    if (id == null) continue;
                    int width = V20250100_UpgradeTask_00_ProjectConfiguration.determineWidthOfNamedField(id);
                    edn.append("{:id \"");
                    edn.append(V20250100_UpgradeTask_00_ProjectConfiguration.mapFieldId(id));
                    edn.append("\" :x ");
                    edn.append(x);
                    edn.append(" :y ");
                    edn.append(y);
                    edn.append(" :w ");
                    edn.append(width);
                    edn.append(" :h 1}");
                    x += width;
                }
                ++y;
                x = 0;
            }
            edn.append("]");
            return Either.right(edn.toString());
        }
        catch (IOException e) {
            return Either.left(e);
        }
    }

    static {
        java.util.HashMap<String, String> m = new java.util.HashMap<String, String>();
        m.put("affectsversions", ":jira.issue-field.system/affects-versions");
        m.put("assignee", ":jira.issue-field.system/assignee");
        m.put("components", ":jira.issue-field.system/components");
        m.put("created", ":jira.issue-field.system/created");
        m.put("description", ":jira.issue-field.system/description");
        m.put("duedate", ":jira.issue-field.system/due-date");
        m.put("environment", ":jira.issue-field.system/environment");
        m.put("fixversions", ":jira.issue-field.system/fix-versions");
        m.put("issuetype", ":jira.issue-field.system/issue-type");
        m.put("key", ":jira.issue-field.system/key");
        m.put("labels", ":jira.issue-field.system/labels");
        m.put("priority", ":jira.issue-field.system/priority");
        m.put("project", ":jira.issue-field.system/project");
        m.put("reporter", ":jira.issue-field.system/reporter");
        m.put("resolution", ":jira.issue-field.system/resolution");
        m.put("resolution.date", ":jira.issue-field.system/resolution-date");
        m.put("securitylevel", ":jira.issue-field.system/security-level");
        m.put("status", ":jira.issue-field.system/status");
        m.put("summary", ":jira.issue-field.system/summary");
        m.put("updated", ":jira.issue-field.system/updated");
        m.put("vote", ":jira.issue-field.system/votes");
        m.put("watch", ":jira.issue-field.system/watches");
        namedFieldMapping = Collections.unmodifiableMap(m);
    }
}

