/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.components;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public abstract class AbstractPluginLifecycle
implements LifecycleAware {
    private final EventPublisher eventPublisher;
    private final Set<PluginLifecycleStage> pluginLifecycleStages = Collections.synchronizedSet(new HashSet(PluginLifecycleStage.values().length));

    protected AbstractPluginLifecycle(EventPublisher eventPublisher) {
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
    }

    @EventListener
    public final void onPluginEnabledEvent(PluginEnabledEvent pluginEnabledEvent) {
        if ("vivid.trace".equals(pluginEnabledEvent.getPlugin().getKey())) {
            this.markPluginLifecycleStage(PluginLifecycleStage.PLUGIN_ENABLED);
        }
    }

    @EventListener
    public final void onPluginDisabledEvent(PluginDisabledEvent pluginDisabledEvent) {
        if ("vivid.trace".equals(pluginDisabledEvent.getPlugin().getKey())) {
            this.unmarkPluginLifecycleStage(PluginLifecycleStage.PLUGIN_ENABLED);
        }
    }

    @PostConstruct
    public void onSpringContextStarted() {
        this.eventPublisher.register((Object)this);
        this.markPluginLifecycleStage(PluginLifecycleStage.SPRING_STARTED);
    }

    @PreDestroy
    public void onSpringContextStopped() {
        this.unmarkPluginLifecycleStage(PluginLifecycleStage.SPRING_STARTED);
        this.eventPublisher.unregister((Object)this);
    }

    public void onStart() {
        this.markPluginLifecycleStage(PluginLifecycleStage.LIFECYCLE_AWARE_STARTED);
    }

    public void onStop() {
        this.unmarkPluginLifecycleStage(PluginLifecycleStage.LIFECYCLE_AWARE_STARTED);
    }

    private void markPluginLifecycleStage(PluginLifecycleStage newPhase) {
        int before = this.pluginLifecycleStages.size();
        this.pluginLifecycleStages.add(newPhase);
        int after = this.pluginLifecycleStages.size();
        if (before < after && after == PluginLifecycleStage.values().length) {
            this.start();
        }
    }

    private void unmarkPluginLifecycleStage(PluginLifecycleStage existingPhase) {
        int before = this.pluginLifecycleStages.size();
        this.pluginLifecycleStages.remove((Object)existingPhase);
        int after = this.pluginLifecycleStages.size();
        if (before == PluginLifecycleStage.values().length && before > after) {
            this.stop();
        }
    }

    protected void start() {
    }

    protected void stop() {
    }

    private static enum PluginLifecycleStage {
        SPRING_STARTED,
        PLUGIN_ENABLED,
        LIFECYCLE_AWARE_STARTED;

    }
}

