/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.components;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bc.issue.worklog.TimeTrackingConfiguration;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.jql.util.JqlIssueSupport;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atlassian.webresource.api.assembler.RequiredResources;
import io.vavr.control.Option;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import vivid.lib.I18n;
import vivid.lib.messages.HtmlMessageReportingAdapter;
import vivid.trace.components.AddOnInformation;
import vivid.trace.jira.compatibility.JiraAPI;

@Named
public class Factory {
    public final AddOnInformation addOnInformation;
    public final ApplicationProperties applicationProperties;
    public final BuildUtilsInfo buildUtilsInfo;
    public final CustomFieldManager customFieldManager;
    public final DateTimeFormatterFactory dateTimeFormatterFactory;
    public final GlobalPermissionManager globalPermissionManager;
    public final GroupManager groupManager;
    public final I18nHelper i18nHelper;
    public final I18nResolver i18nResolver;
    public final Option<I18n.ResolverAdapter> i18nResolverAdapterOption;
    public final IssueLinkManager issueLinkManager;
    public final IssueLinkTypeManager issueLinkTypeManager;
    public final IssueSecurityLevelManager issueSecurityLevelManager;
    public final IssueTypeManager issueTypeManager;
    public final JiraAuthenticationContext jiraAuthenticationContext;
    public final JiraAPI jiraAPI;
    public final JqlIssueSupport jqlIssueSupport;
    public final LocaleManager localeManager;
    public final LoginUriProvider loginUriProvider;
    public final PageBuilderService pageBuilderService;
    public final PermissionManager permissionManager;
    public final PluginAccessor pluginAccessor;
    public final ProjectManager projectManager;
    public final ProjectRoleManager projectRoleManager;
    public final SearchService searchService;
    public final TimeTrackingConfiguration timeTrackingConfiguration;
    public final TimeZoneService timeZoneService;
    public final UserManager userManager;
    public final VelocityTemplatingEngine velocityTemplatingEngine;
    public final WebSudoManager webSudoManager;
    public final WorkflowManager workflowManager;
    public final XsrfTokenGenerator xsrfTokenGenerator;

    @Inject
    public Factory(AddOnInformation addOnInformation, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport BuildUtilsInfo buildUtilsInfo, @ComponentImport CustomFieldManager customFieldManager, @ComponentImport DateTimeFormatterFactory dateTimeFormatterFactory, @ComponentImport GlobalPermissionManager globalPermissionManager, @ComponentImport GroupManager groupManager, @ComponentImport I18nHelper i18nHelper, @ComponentImport I18nResolver i18nResolver, @ComponentImport IssueLinkManager issueLinkManager, @ComponentImport IssueLinkTypeManager issueLinkTypeManager, @ComponentImport IssueSecurityLevelManager issueSecurityLevelManager, @ComponentImport IssueTypeManager issueTypeManager, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, JiraAPI jiraAPI, @ComponentImport JqlIssueSupport jqlIssueSupport, @ComponentImport LocaleManager localeManager, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport PageBuilderService pageBuilderService, @ComponentImport PermissionManager permissionManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport ProjectManager projectManager, @ComponentImport ProjectRoleManager projectRoleManager, @ComponentImport SearchService searchService, @ComponentImport TimeTrackingConfiguration timeTrackingConfiguration, @ComponentImport TimeZoneService timeZoneService, @ComponentImport UserManager userManager, @ComponentImport VelocityTemplatingEngine velocityTemplatingEngine, @ComponentImport WebSudoManager webSudoManager, @ComponentImport WorkflowManager workflowManager, @ComponentImport XsrfTokenGenerator xsrfTokenGenerator) {
        this.addOnInformation = Objects.requireNonNull(addOnInformation);
        this.applicationProperties = Objects.requireNonNull(applicationProperties);
        this.buildUtilsInfo = buildUtilsInfo;
        this.customFieldManager = Objects.requireNonNull(customFieldManager);
        this.dateTimeFormatterFactory = Objects.requireNonNull(dateTimeFormatterFactory);
        this.globalPermissionManager = Objects.requireNonNull(globalPermissionManager);
        this.groupManager = Objects.requireNonNull(groupManager);
        this.i18nHelper = Objects.requireNonNull(i18nHelper);
        this.i18nResolver = Objects.requireNonNull(i18nResolver);
        this.i18nResolverAdapterOption = Option.of((arg_0, arg_1) -> ((I18nResolver)i18nResolver).getText(arg_0, arg_1));
        this.issueLinkManager = Objects.requireNonNull(issueLinkManager);
        this.issueLinkTypeManager = Objects.requireNonNull(issueLinkTypeManager);
        this.issueSecurityLevelManager = Objects.requireNonNull(issueSecurityLevelManager);
        this.issueTypeManager = Objects.requireNonNull(issueTypeManager);
        this.jiraAuthenticationContext = Objects.requireNonNull(jiraAuthenticationContext);
        this.jiraAPI = Objects.requireNonNull(jiraAPI);
        this.jqlIssueSupport = Objects.requireNonNull(jqlIssueSupport);
        this.localeManager = Objects.requireNonNull(localeManager);
        this.loginUriProvider = Objects.requireNonNull(loginUriProvider);
        this.pageBuilderService = Objects.requireNonNull(pageBuilderService);
        this.permissionManager = Objects.requireNonNull(permissionManager);
        this.pluginAccessor = Objects.requireNonNull(pluginAccessor);
        this.projectManager = Objects.requireNonNull(projectManager);
        this.projectRoleManager = Objects.requireNonNull(projectRoleManager);
        this.searchService = Objects.requireNonNull(searchService);
        this.timeTrackingConfiguration = Objects.requireNonNull(timeTrackingConfiguration);
        this.timeZoneService = Objects.requireNonNull(timeZoneService);
        this.userManager = Objects.requireNonNull(userManager);
        this.velocityTemplatingEngine = Objects.requireNonNull(velocityTemplatingEngine);
        this.webSudoManager = webSudoManager;
        this.workflowManager = Objects.requireNonNull(workflowManager);
        this.xsrfTokenGenerator = xsrfTokenGenerator;
    }

    public String getContextPath() {
        return this.applicationProperties.getBaseUrl(UrlMode.CANONICAL);
    }

    public RequiredResources getRequiredResources() {
        return this.pageBuilderService.assembler().resources();
    }

    public HtmlMessageReportingAdapter newHtmlMessageReportingAdapter() {
        return new HtmlMessageReportingAdapter(this.applicationProperties, this.i18nResolverAdapterOption);
    }

    public void requireOwnWebResource(String webResourceKey) {
        this.getRequiredResources().requireWebResource("vivid.trace:" + webResourceKey);
    }

    public String getStaticPluginResourceUrl(String moduleCompleteKey, String resourceName) {
        return this.jiraAPI.getStaticPluginResourceUrl(moduleCompleteKey, resourceName);
    }

    public Integer jiraMajorVersion() {
        int[] v = this.buildUtilsInfo.getVersionNumbers();
        if (v.length >= 1) {
            return v[0];
        }
        return 11;
    }
}

