/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.conditions;

import com.atlassian.jira.project.Project;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import io.vavr.control.Option;
import java.util.Map;
import vivid.lib.Strings;
import vivid.lib.messages.VTE19InternalError;
import vivid.trace.accesscontrols.TraceVisibilityAccessControl;
import vivid.trace.components.Factory;
import vivid.trace.components.ProjectConfigurations;

public class IssueContextTraceDisplayFormatCondition
implements Condition {
    private static final String DISPLAY_PARAM_KEY = "display";
    private final Factory f;
    private final ProjectConfigurations projectConfigurations;
    private final TraceVisibilityAccessControl traceVisibilityAccessControl;
    private String displaySetting;

    public IssueContextTraceDisplayFormatCondition(Factory factory, ProjectConfigurations projectConfigurations, TraceVisibilityAccessControl traceVisibilityAccessControl) {
        this.f = factory;
        this.projectConfigurations = projectConfigurations;
        this.traceVisibilityAccessControl = traceVisibilityAccessControl;
    }

    public void init(Map<String, String> params) throws PluginParseException {
        String value = params.get(DISPLAY_PARAM_KEY);
        if (Strings.isBlank(value)) {
            throw new PluginParseException(VTE19InternalError.message(Option.none(), "The issue context trace display format condition parameter key \"display\" cannot be blank").getMessage());
        }
        this.displaySetting = value;
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        return IssueContextTraceDisplayFormatCondition.shouldShowIssueContextTrace((Project)context.get("project"), this.displaySetting, this.f, this.projectConfigurations, this.traceVisibilityAccessControl);
    }

    public static boolean shouldShowIssueContextTrace(Project project, String candidateDisplaySetting, Factory f, ProjectConfigurations projectConfigurations, TraceVisibilityAccessControl traceVisibilityAccessControl) {
        return IssueContextTraceDisplayFormatCondition.isConfiguredDisplayMethod(project, candidateDisplaySetting, projectConfigurations) && traceVisibilityAccessControl.isVisibleToUser(project, f.jiraAuthenticationContext.getLoggedInUser(), f);
    }

    private static boolean isConfiguredDisplayMethod(Project project, String candidateDisplaySetting, ProjectConfigurations projectConfigurations) {
        String asConfigured = projectConfigurations.getComputedIssueContextTraceDisplayFormat(project);
        return candidateDisplaySetting.equalsIgnoreCase(asConfigured);
    }
}

