/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.customfield;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.impl.CalculatedCFType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Collection;
import java.util.List;
import vivid.trace.customfield.Direction;

public class DirectionsCFType
extends CalculatedCFType<Double, Double> {
    public static final String DIRECTIONS_CUSTOM_FIELD_NAME = "VTDirections";
    private final IssueLinkManager issueLinkManager;

    public DirectionsCFType(@ComponentImport IssueLinkManager issueLinkManager) {
        this.issueLinkManager = issueLinkManager;
    }

    public static CustomField getCustomField(CustomFieldManager customFieldManager) {
        return customFieldManager.getCustomFieldObjectByName(DIRECTIONS_CUSTOM_FIELD_NAME);
    }

    public String getStringFromSingularObject(Double singularObject) {
        return singularObject != null ? singularObject.toString() : Double.toString(0.0);
    }

    public Double getSingularObjectFromString(String string) throws FieldValidationException {
        return string != null ? Double.valueOf(string) : Double.valueOf(0.0);
    }

    public Double getValueFromIssue(CustomField field, Issue issue) {
        int v = 0;
        if (issue != null) {
            List outward;
            List inward;
            Collection subTasks;
            if (issue.getParentId() != null) {
                v |= Direction.PARENTS.getEncoding();
            }
            if ((subTasks = issue.getSubTaskObjects()) != null && !subTasks.isEmpty()) {
                v |= Direction.SUBTASKS.getEncoding();
            }
            if (this.sizeOfNonSubTaskLinks(inward = this.issueLinkManager.getInwardLinks(issue.getId())) >= 1) {
                v |= Direction.INWARD_ISSUE_LINKS.getEncoding();
            }
            if (this.sizeOfNonSubTaskLinks(outward = this.issueLinkManager.getOutwardLinks(issue.getId())) >= 1) {
                v |= Direction.OUTWARD_ISSUE_LINKS.getEncoding();
            }
        }
        return v;
    }

    public boolean isRenderable() {
        return false;
    }

    private int sizeOfNonSubTaskLinks(List<IssueLink> issueLinks) {
        if (issueLinks == null) {
            return 0;
        }
        int size = issueLinks.size();
        for (IssueLink link : issueLinks) {
            if (!link.getIssueLinkType().isSubTaskLinkType()) continue;
            --size;
        }
        return size;
    }
}

