/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.ifc;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.impl.CascadingSelectCFType;
import com.atlassian.jira.issue.customfields.impl.DateCFType;
import com.atlassian.jira.issue.customfields.impl.DateTimeCFType;
import com.atlassian.jira.issue.customfields.impl.GenericTextCFType;
import com.atlassian.jira.issue.customfields.impl.LabelsCFType;
import com.atlassian.jira.issue.customfields.impl.MultiGroupCFType;
import com.atlassian.jira.issue.customfields.impl.MultiSelectCFType;
import com.atlassian.jira.issue.customfields.impl.MultiUserCFType;
import com.atlassian.jira.issue.customfields.impl.NumberCFType;
import com.atlassian.jira.issue.customfields.impl.ProjectCFType;
import com.atlassian.jira.issue.customfields.impl.RenderableTextCFType;
import com.atlassian.jira.issue.customfields.impl.SelectCFType;
import com.atlassian.jira.issue.customfields.impl.TextAreaCFType;
import com.atlassian.jira.issue.customfields.impl.URLCFType;
import com.atlassian.jira.issue.customfields.impl.UserCFType;
import com.atlassian.jira.issue.customfields.impl.VersionCFType;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.util.velocity.NumberTool;
import io.vavr.Tuple2;
import io.vavr.collection.List;
import io.vavr.collection.Stream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import us.bpsm.edn.Keyword;
import us.bpsm.edn.parser.Parseable;
import us.bpsm.edn.parser.Parser;
import us.bpsm.edn.parser.Parsers;
import vivid.trace.components.Factory;
import vivid.trace.ifc.Collector;
import vivid.trace.ifc.cftype.AccountCustomFieldCFTypeCollector;
import vivid.trace.ifc.cftype.CFTypeCollector;
import vivid.trace.ifc.cftype.CascadingSelectCFTypeCollector;
import vivid.trace.ifc.cftype.DateCFTypeCollector;
import vivid.trace.ifc.cftype.DateTimeCFTypeCollector;
import vivid.trace.ifc.cftype.EpicLabelCFTypeCollector;
import vivid.trace.ifc.cftype.GenericTextCFTypeCollector;
import vivid.trace.ifc.cftype.LabelsCFTypeCollector;
import vivid.trace.ifc.cftype.MultiGroupCFTypeCollector;
import vivid.trace.ifc.cftype.MultiSelectCFTypeCollector;
import vivid.trace.ifc.cftype.MultiUserCFTypeCollector;
import vivid.trace.ifc.cftype.NumberCFTypeCollector;
import vivid.trace.ifc.cftype.ProjectCFTypeCollector;
import vivid.trace.ifc.cftype.RenderableTextCFTypeCollector;
import vivid.trace.ifc.cftype.SelectCFTypeCollector;
import vivid.trace.ifc.cftype.SprintCFTypeCollector;
import vivid.trace.ifc.cftype.TeamCustomFieldCFTypeCollector;
import vivid.trace.ifc.cftype.TextAreaCFTypeCollector;
import vivid.trace.ifc.cftype.URLCFTypeCollector;
import vivid.trace.ifc.cftype.UserCFTypeCollector;
import vivid.trace.ifc.cftype.VersionCFTypeCollector;
import vivid.trace.ifc.system.AffectsVersionsSystemFieldCollector;
import vivid.trace.ifc.system.ArchivedBySystemFieldCollector;
import vivid.trace.ifc.system.ArchivedDateSystemFieldCollector;
import vivid.trace.ifc.system.AssigneeSystemFieldCollector;
import vivid.trace.ifc.system.AttachmentsSystemFieldCollector;
import vivid.trace.ifc.system.ComponentsSystemFieldCollector;
import vivid.trace.ifc.system.CreatedSystemFieldCollector;
import vivid.trace.ifc.system.CreatorSystemFieldCollector;
import vivid.trace.ifc.system.DescriptionSystemFieldCollector;
import vivid.trace.ifc.system.DueDateSystemFieldCollector;
import vivid.trace.ifc.system.EnvironmentSystemFieldCollector;
import vivid.trace.ifc.system.FixVersionsSystemFieldCollector;
import vivid.trace.ifc.system.IssueTypeSystemFieldCollector;
import vivid.trace.ifc.system.KeySystemFieldCollector;
import vivid.trace.ifc.system.LabelsSystemFieldCollector;
import vivid.trace.ifc.system.ParentSystemFieldCollector;
import vivid.trace.ifc.system.PrioritySystemFieldCollector;
import vivid.trace.ifc.system.ProjectSystemFieldCollector;
import vivid.trace.ifc.system.ReporterSystemFieldCollector;
import vivid.trace.ifc.system.ResolutionDateSystemFieldCollector;
import vivid.trace.ifc.system.ResolutionSystemFieldCollector;
import vivid.trace.ifc.system.SecurityLevelSystemFieldCollector;
import vivid.trace.ifc.system.StatusSystemFieldCollector;
import vivid.trace.ifc.system.SubTaskSystemFieldCollector;
import vivid.trace.ifc.system.SummarySystemFieldCollector;
import vivid.trace.ifc.system.SystemFieldCollector;
import vivid.trace.ifc.system.TimeEstimateOriginalSystemFieldCollector;
import vivid.trace.ifc.system.TimeEstimateRemainingSystemFieldCollector;
import vivid.trace.ifc.system.TimeEstimateSpentSystemFieldCollector;
import vivid.trace.ifc.system.UpdatedSystemFieldCollector;
import vivid.trace.ifc.system.VotesSystemFieldCollector;
import vivid.trace.ifc.system.WatchersSystemFieldCollector;
import vivid.trace.ifc.system.WorkflowSystemFieldCollector;

public class IssueFieldCollector {
    private static final List<SystemFieldCollector> ALL_ISSUE_SYSTEM_FIELD_COLLECTORS = List.of(new AffectsVersionsSystemFieldCollector(), new ArchivedBySystemFieldCollector(), new ArchivedDateSystemFieldCollector(), new AssigneeSystemFieldCollector(), new AttachmentsSystemFieldCollector(), new ComponentsSystemFieldCollector(), new CreatedSystemFieldCollector(), new CreatorSystemFieldCollector(), new DescriptionSystemFieldCollector(), new DueDateSystemFieldCollector(), new EnvironmentSystemFieldCollector(), new FixVersionsSystemFieldCollector(), new IssueTypeSystemFieldCollector(), new KeySystemFieldCollector(), new LabelsSystemFieldCollector(), new ParentSystemFieldCollector(), new PrioritySystemFieldCollector(), new ProjectSystemFieldCollector(), new ReporterSystemFieldCollector(), new ResolutionSystemFieldCollector(), new ResolutionDateSystemFieldCollector(), new SecurityLevelSystemFieldCollector(), new StatusSystemFieldCollector(), new SubTaskSystemFieldCollector(), new SummarySystemFieldCollector(), new TimeEstimateOriginalSystemFieldCollector(), new TimeEstimateRemainingSystemFieldCollector(), new TimeEstimateSpentSystemFieldCollector(), new UpdatedSystemFieldCollector(), new VotesSystemFieldCollector(), new WatchersSystemFieldCollector(), new WorkflowSystemFieldCollector());
    private static final Map<String, Class<? extends CFTypeCollector>> CF_CLAZZ_TO_COLLECTOR_MAP = io.vavr.collection.HashMap.of("com.atlassian.greenhopper.customfield.epiclabel.EpicLabelCFType", EpicLabelCFTypeCollector.class, "com.atlassian.greenhopper.customfield.sprint.SprintCFType", SprintCFTypeCollector.class, "com.tempoplugin.accounts.customfield.account.AccountCustomField", AccountCustomFieldCFTypeCollector.class, "com.tempoplugin.team.customfield.TeamCustomField", TeamCustomFieldCFTypeCollector.class).toJavaMap();
    public static final Map<String, SystemFieldCollector> ISSUE_SYSTEM_FIELDS_MAP = Stream.ofAll(ALL_ISSUE_SYSTEM_FIELD_COLLECTORS).toJavaMap(collector -> new Tuple2<String, SystemFieldCollector>(collector.id(), (SystemFieldCollector)collector));
    private static final java.util.List<SystemFieldCollector> MANDATORY_COLLECTORS = List.of(ISSUE_SYSTEM_FIELDS_MAP.get(":jira.issue-field.system/key"), ISSUE_SYSTEM_FIELDS_MAP.get(":jira.issue-field.system/summary"), ISSUE_SYSTEM_FIELDS_MAP.get(":jira.issue-field.system/resolution")).toJavaList();
    private static final java.util.List<String> MANDATORY_COLLECTORS_IDS = Stream.ofAll(MANDATORY_COLLECTORS).map(SystemFieldCollector::id).toJavaList();
    public static final Function<ProjectComponent, String> ComponentNameFn = input -> input != null ? input.getName() : null;
    public static final Function<Group, String> GroupNameFn = input -> input != null ? input.getName() : null;
    public static final Function<Label, String> LabelNameFn = input -> input != null ? input.getLabel() : null;
    public static final Function<Option, String> OptionNameFn = input -> input != null ? input.getValue() : null;
    public static final Function<ApplicationUser, String> UserDisplayNameFn = input -> input != null ? input.getDisplayName() : null;
    public static final Function<Version, String> VersionNameFn = input -> input != null ? input.getName() : null;
    public final Factory factory;
    private final NumberTool numberTool;
    private final Collection<Collector> collectors;
    private final Map<String, Map<String, String>> projectMap;
    private final Map<String, Map<String, String>> userMap;
    private boolean isIncludeIssuePriorityMap;
    private boolean isIncludeIssueResolutionMap;
    private boolean isIncludeIssueStatusMap;
    private boolean isIncludeIssueTypeMap;
    private static final Keyword EDN_ID_KEYWORD = Keyword.newKeyword("", "id");
    private static String JIRA_ISSUE_FIELD_CFTYPE_PREFIX = ":jira.issue-field.cftype/";

    public IssueFieldCollector(String itemCardLayout, Factory factory) {
        this.factory = factory;
        this.numberTool = new NumberTool(factory.jiraAuthenticationContext.getLocale());
        this.collectors = this.assembleCollectors(itemCardLayout);
        this.projectMap = new HashMap<String, Map<String, String>>();
        this.userMap = new HashMap<String, Map<String, String>>();
        this.isIncludeIssuePriorityMap = false;
        this.isIncludeIssueResolutionMap = false;
        this.isIncludeIssueStatusMap = false;
        this.isIncludeIssueTypeMap = false;
    }

    public NumberTool getNumberTool() {
        return this.numberTool;
    }

    private Collection<Collector> assembleCollectors(String itemCardLayoutEdnString) {
        ArrayList<Collector> cs = new ArrayList<Collector>(MANDATORY_COLLECTORS);
        try (Parseable parseable = Parsers.newParseable(itemCardLayoutEdnString);){
            Parser parser = Parsers.newParser(Parsers.defaultConfiguration());
            Object list = parser.nextValue(parseable);
            if (list instanceof java.util.List) {
                for (Object field : (java.util.List)list) {
                    Object id;
                    if (!(field instanceof Map) || !((id = ((Map)field).get(EDN_ID_KEYWORD)) instanceof String)) continue;
                    this.addNonMandatoryCollectorById(cs, (String)id);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return cs;
    }

    private void addNonMandatoryCollectorById(Collection<Collector> collectors, String id) {
        if (MANDATORY_COLLECTORS_IDS.contains(id)) {
            return;
        }
        SystemFieldCollector collector = ISSUE_SYSTEM_FIELDS_MAP.get(id);
        if (collector != null) {
            collectors.add(collector);
            return;
        }
        try {
            Long customFieldId;
            CustomField customField;
            if (id.startsWith(JIRA_ISSUE_FIELD_CFTYPE_PREFIX) && (customField = this.factory.customFieldManager.getCustomFieldObject(customFieldId = Long.decode(id.substring(JIRA_ISSUE_FIELD_CFTYPE_PREFIX.length())))) != null) {
                CustomFieldType customFieldType = customField.getCustomFieldType();
                io.vavr.control.Option<? extends Collector> customFieldCollectorOption = this.collectorForCustomFieldTypeByClazz(customField, id);
                if (customFieldCollectorOption.isDefined()) {
                    collectors.add(customFieldCollectorOption.get());
                } else if (customFieldType instanceof CascadingSelectCFType) {
                    collectors.add(new CascadingSelectCFTypeCollector(customField, id));
                } else if (customFieldType instanceof DateCFType) {
                    collectors.add(new DateCFTypeCollector(customField, id));
                } else if (customFieldType instanceof DateTimeCFType) {
                    collectors.add(new DateTimeCFTypeCollector(customField, id));
                } else if (customFieldType instanceof LabelsCFType) {
                    collectors.add(new LabelsCFTypeCollector(customField, id));
                } else if (customFieldType instanceof MultiGroupCFType) {
                    collectors.add(new MultiGroupCFTypeCollector(customField, id));
                } else if (customFieldType instanceof MultiSelectCFType) {
                    collectors.add(new MultiSelectCFTypeCollector(customField, id));
                } else if (customFieldType instanceof MultiUserCFType) {
                    collectors.add(new MultiUserCFTypeCollector(customField, id));
                } else if (customFieldType instanceof NumberCFType) {
                    collectors.add(new NumberCFTypeCollector(customField, id));
                } else if (customFieldType instanceof ProjectCFType) {
                    collectors.add(new ProjectCFTypeCollector(customField, id));
                } else if (customFieldType instanceof TextAreaCFType) {
                    collectors.add(new TextAreaCFTypeCollector(customField, id));
                } else if (customFieldType instanceof RenderableTextCFType) {
                    collectors.add(new RenderableTextCFTypeCollector(customField, id));
                } else if (customFieldType instanceof SelectCFType) {
                    collectors.add(new SelectCFTypeCollector(customField, id));
                } else if (customFieldType instanceof URLCFType) {
                    collectors.add(new URLCFTypeCollector(customField, id));
                } else if (customFieldType instanceof UserCFType) {
                    collectors.add(new UserCFTypeCollector(customField, id));
                } else if (customFieldType instanceof VersionCFType) {
                    collectors.add(new VersionCFTypeCollector(customField, id));
                } else if (customFieldType instanceof GenericTextCFType) {
                    collectors.add(new GenericTextCFTypeCollector(customField, id));
                }
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | NumberFormatException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public Map<String, Object> collectAttributesForIssue(Issue issue) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (Collector collector : this.collectors) {
            collector.collect(issue, attributes, this);
        }
        return attributes;
    }

    private io.vavr.control.Option<? extends Collector> collectorForCustomFieldTypeByClazz(CustomField customField, String customFieldIdStr) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        CustomFieldType customFieldType = customField.getCustomFieldType();
        String clazzName = customFieldType.getClass().getCanonicalName();
        Class<? extends CFTypeCollector> clazz = CF_CLAZZ_TO_COLLECTOR_MAP.get(clazzName);
        return clazz != null ? io.vavr.control.Option.of((Collector)clazz.getConstructor(CustomField.class, String.class).newInstance(customField, customFieldIdStr)) : io.vavr.control.Option.none();
    }

    public boolean includeIssuePriorityMap() {
        return this.isIncludeIssuePriorityMap;
    }

    public void setIncludeIssuePriorityMap() {
        this.isIncludeIssuePriorityMap = true;
    }

    public boolean includeIssueResolutionMap() {
        return this.isIncludeIssueResolutionMap;
    }

    public void setIncludeIssueResolutionMap() {
        this.isIncludeIssueResolutionMap = true;
    }

    public boolean includeIssueStatusMap() {
        return this.isIncludeIssueStatusMap;
    }

    public void setIncludeIssueStatusMap() {
        this.isIncludeIssueStatusMap = true;
    }

    public boolean includeIssueTypeMap() {
        return this.isIncludeIssueTypeMap;
    }

    public void setIncludeIssueTypeMap() {
        this.isIncludeIssueTypeMap = true;
    }

    public boolean includeProjectMap() {
        return this.projectMap != null && !this.projectMap.isEmpty();
    }

    public Map<String, Map<String, String>> projectMap() {
        return this.projectMap;
    }

    public boolean includeUserMap() {
        return this.userMap != null && !this.userMap.isEmpty();
    }

    public Map<String, Map<String, String>> userMap() {
        return this.userMap;
    }

    public static void noteProject(IssueFieldCollector context, Project project, io.vavr.control.Option<String> id) {
        if (id.isDefined() && !context.projectMap.containsKey(id.get())) {
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("key", project.getKey());
            entry.put("name", project.getName());
            context.projectMap.put(id.get(), entry);
        }
    }

    private static void noteUser(ApplicationUser user, IssueFieldCollector context) {
        String userKey = user.getKey();
        if (!context.userMap.containsKey(userKey)) {
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("emailAddress", user.getEmailAddress());
            entry.put("displayName", user.getDisplayName());
            context.userMap.put(userKey, entry);
        }
    }

    public static void putDateInAttributes(Map<String, Object> attributes, String attributeKey, Date date) {
        if (date != null) {
            attributes.put(attributeKey, Long.toString(date.getTime()));
        }
    }

    public static void putJoinedStringsInAttributes(Map<String, Object> attributes, String attributeKey, Iterable<String> iterable) {
        if (iterable != null && iterable.iterator().hasNext()) {
            attributes.put(attributeKey, StreamSupport.stream(iterable.spliterator(), false).filter(Objects::nonNull).collect(Collectors.joining(", ")));
        }
    }

    public static io.vavr.control.Option<String> putLongInAttributes(Map<String, Object> attributes, String attributeKey, Long l) {
        if (l != null) {
            String s = Long.toString(l);
            attributes.put(attributeKey, s);
            return io.vavr.control.Option.of(s);
        }
        return io.vavr.control.Option.none();
    }

    public static void putStringInAttributes(Map<String, Object> attributes, String attributeKey, String s) {
        if (s != null) {
            attributes.put(attributeKey, s);
        }
    }

    public static void putUserInAttributes(Map<String, Object> attributes, String attributeKey, ApplicationUser user, IssueFieldCollector context) {
        if (user != null) {
            IssueFieldCollector.putStringInAttributes(attributes, attributeKey, user.getKey());
            IssueFieldCollector.noteUser(user, context);
        }
    }

    public static Map<String, String> typedValue(String type, String value) {
        return io.vavr.collection.HashMap.of("type", type, "value", value).toJavaMap();
    }

    public String formatShortDuration(Long timeSpent) {
        double workDaysPerWeek = this.factory.timeTrackingConfiguration.getDaysPerWeek().doubleValue();
        double workHoursPerDay = this.factory.timeTrackingConfiguration.getHoursPerDay().doubleValue();
        JiraDurationUtils.PrettyDurationFormatter durationFormatter = new JiraDurationUtils.PrettyDurationFormatter(BigDecimal.valueOf(workHoursPerDay).setScale(2, RoundingMode.HALF_UP), BigDecimal.valueOf(workDaysPerWeek).setScale(2, RoundingMode.HALF_UP), this.factory.i18nHelper);
        return durationFormatter.shortFormat(timeSpent, this.factory.jiraAuthenticationContext.getLocale());
    }
}

