/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.ifc;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import vivid.lib.Strings;
import vivid.trace.components.Factory;
import vivid.trace.components.Providers;
import vivid.trace.customfield.DirectionsCFType;
import vivid.trace.ifc.IssueFieldCollector;
import vivid.trace.ifc.system.SystemFieldCollector;

public class ItemFields
implements Providers.Provider<Factory> {
    public static final String ITEM_FIELDS_KEY = "item-fields";
    private static final Locale VIVID_CUSTOMER_SUPPORT_LOCALE = Locale.US;
    private static final Set<String> IGNORED_CUSTOM_FIELDS = io.vavr.collection.HashSet.of(DirectionsCFType.class.getCanonicalName(), "com.atlassian.greenhopper.customfield.epiccolor.EpicColorCFType", "com.atlassian.greenhopper.customfield.epiclink.EpicLinkCFType").toJavaSet();

    @Override
    public String getKey() {
        return ITEM_FIELDS_KEY;
    }

    @Override
    public void provideData(Factory factory, Map<String, Object> accumulator) {
        Locale userLocale = factory.jiraAuthenticationContext.getLocale();
        String defaultLocaleString = factory.applicationProperties.getPropertyValue("jira.i18n.default.locale");
        Option<Locale> defaultLocale = Strings.isBlank(defaultLocaleString) ? Option.none() : Option.of(factory.localeManager.getLocale(defaultLocaleString));
        List itemFields = Stream.concat(this.getCFTypeFields(factory, factory.jiraAuthenticationContext.getLoggedInUser()), this.getSystemFields(factory, userLocale, defaultLocale)).collect(Collectors.toList());
        accumulator.put("system", Collections.singletonMap(this.getKey(), itemFields));
    }

    private Stream<Map<String, String>> getCFTypeFields(Factory factory, ApplicationUser user) {
        List<CustomField> customFields = ItemFields.visibleCustomFields(factory, user);
        return customFields.stream().filter(cf -> !IGNORED_CUSTOM_FIELDS.contains(cf.getCustomFieldType().getClass().getCanonicalName())).map(cf -> {
            String id = ":jira.issue-field.cftype/" + cf.getIdAsLong();
            HashMap<String, Object> value = new HashMap<String, Object>();
            value.put("description", cf.getDescription());
            value.put("id", id);
            value.put("name", cf.getName());
            value.put("name-search", cf.getUntranslatedName());
            return value;
        });
    }

    private Stream<HashMap<String, String>> getSystemFields(Factory factory, Locale userLocale, Option<Locale> defaultLocale) {
        return IssueFieldCollector.ISSUE_SYSTEM_FIELDS_MAP.values().stream().map(issueSystemFieldCollector -> {
            HashMap<String, String> value = new HashMap<String, String>();
            String id = issueSystemFieldCollector.id();
            value.put("id", id);
            value.put("name", ItemFields.localizedName(factory, issueSystemFieldCollector, userLocale));
            StringBuilder sb = new StringBuilder();
            if (defaultLocale.isDefined()) {
                sb.append(ItemFields.localizedName(factory, issueSystemFieldCollector, (Locale)defaultLocale.get()));
                sb.append(", ");
            }
            sb.append(ItemFields.localizedName(factory, issueSystemFieldCollector, VIVID_CUSTOMER_SUPPORT_LOCALE));
            value.put("name-search", sb.toString());
            return value;
        });
    }

    private static Set<Long> browsableProjects(Factory factory, ApplicationUser user) {
        Collection browsableProjects = factory.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, user);
        HashSet<Long> browsableProjectIds = new HashSet<Long>(browsableProjects.size());
        for (Project project : browsableProjects) {
            browsableProjectIds.add(project.getId());
        }
        return browsableProjectIds;
    }

    private static boolean isCustomFieldVisibleInProjects(CustomField customField, Set<Long> projectIds) {
        for (Project associatedProject : customField.getAssociatedProjectObjects()) {
            if (!projectIds.contains(associatedProject.getId())) continue;
            return true;
        }
        return false;
    }

    private static String localizedName(Factory factory, SystemFieldCollector systemFieldCollector, Locale locale) {
        return factory.i18nResolver.getText(locale, systemFieldCollector.i18nKey());
    }

    private static List<CustomField> visibleCustomFields(Factory factory, ApplicationUser user) {
        ArrayList<CustomField> visibleCustomFields = new ArrayList<CustomField>();
        Set<Long> browsableProjectIds = ItemFields.browsableProjects(factory, user);
        for (CustomField customField : factory.customFieldManager.getCustomFieldObjects()) {
            if (!customField.isAllProjects() && !ItemFields.isCustomFieldVisibleInProjects(customField, browsableProjectIds)) continue;
            visibleCustomFields.add(customField);
        }
        return visibleCustomFields;
    }
}

