/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.ifc.cftype;

import com.atlassian.jira.issue.fields.CustomField;
import io.vavr.control.Option;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import vivid.trace.ifc.cftype.CFTypeCollector;

abstract class ReflectiveCFTypeCollector
extends CFTypeCollector {
    private final Map<CompositeKey, Supplier<Option<Field>>> fieldMemos = new HashMap<CompositeKey, Supplier<Option<Field>>>();
    private final Map<CompositeKey, Supplier<Option<Method>>> methodMemos = new HashMap<CompositeKey, Supplier<Option<Method>>>();

    ReflectiveCFTypeCollector(CustomField customField, String customFieldIdStr) {
        super(customField, customFieldIdStr);
    }

    protected Supplier<Option<Field>> memoizedField(Class<?> clazz, String fieldName) {
        return () -> {
            try {
                Field f = clazz.getDeclaredField(fieldName);
                f.setAccessible(true);
                return Option.of(f);
            }
            catch (Exception e) {
                return Option.none();
            }
        };
    }

    protected Supplier<Option<Method>> memoizedMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return () -> {
            try {
                Method m = clazz.getDeclaredMethod(methodName, parameterTypes);
                m.setAccessible(true);
                return Option.of(m);
            }
            catch (Exception e) {
                return Option.none();
            }
        };
    }

    protected Option<Field> getField(Class<?> clazz, String fieldName) {
        CompositeKey key = new CompositeKey(clazz, fieldName);
        if (!this.fieldMemos.containsKey(key)) {
            this.fieldMemos.put(key, this.memoizedField(clazz, fieldName));
        }
        Supplier<Option<Field>> fieldSupplier = this.fieldMemos.get(key);
        return fieldSupplier.get();
    }

    protected Option<Method> getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        CompositeKey key = new CompositeKey(clazz, methodName);
        if (!this.methodMemos.containsKey(key)) {
            this.methodMemos.put(key, this.memoizedMethod(clazz, methodName, parameterTypes));
        }
        Supplier<Option<Method>> methodSupplier = this.methodMemos.get(key);
        return methodSupplier.get();
    }

    private class CompositeKey {
        final Class<?> clazz;
        final String name;

        private CompositeKey(Class<?> clazz, String name) {
            this.clazz = Objects.requireNonNull(clazz);
            this.name = Objects.requireNonNull(name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompositeKey that = (CompositeKey)o;
            if (!this.clazz.equals(that.clazz)) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.clazz.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }
    }
}

