/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.ifc.cftype;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import vivid.trace.ifc.IssueFieldCollector;
import vivid.trace.ifc.cftype.ReflectiveCFTypeCollector;

public class SprintCFTypeCollector
extends ReflectiveCFTypeCollector {
    public SprintCFTypeCollector(CustomField customField, String customFieldIdStr) {
        super(customField, customFieldIdStr);
    }

    @Override
    public void collect(Issue issue, Map<String, Object> attributes, IssueFieldCollector context) {
        CustomFieldType cftype = this.customField.getCustomFieldType();
        Object value = cftype.getValueFromIssue(this.customField, issue);
        if (!(value instanceof Collection)) {
            return;
        }
        Collection values = (Collection)value;
        ArrayList<String> sprintNames = new ArrayList<String>(values.size());
        for (Object sprint : values) {
            try {
                Method m_getName = this.getMethod(sprint.getClass(), "getName", new Class[0]).get();
                Object o_name = m_getName.invoke(sprint, new Object[0]);
                sprintNames.add(o_name.toString());
            }
            catch (Exception exception) {}
        }
        IssueFieldCollector.putJoinedStringsInAttributes(attributes, this.customFieldIdStr, sprintNames);
    }
}

