/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.ifc.cftype;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import vivid.trace.ifc.IssueFieldCollector;
import vivid.trace.ifc.cftype.ReflectiveCFTypeCollector;

public class TeamCustomFieldCFTypeCollector
extends ReflectiveCFTypeCollector {
    public TeamCustomFieldCFTypeCollector(CustomField customField, String customFieldIdStr) {
        super(customField, customFieldIdStr);
    }

    @Override
    public void collect(Issue issue, Map<String, Object> attributes, IssueFieldCollector context) {
        CustomFieldType cftype = this.customField.getCustomFieldType();
        Object value = cftype.getValueFromIssue(this.customField, issue);
        try {
            if (value != null) {
                int teamId = Integer.parseInt((String)value);
                Field f_teamManager = this.getField(cftype.getClass(), "teamManager").get();
                Object o_teamManager = f_teamManager.get(cftype);
                Method m_getTeamName = this.getMethod(o_teamManager.getClass(), "getTeamName", Integer.TYPE).get();
                Object o_teamName = m_getTeamName.invoke(o_teamManager, teamId);
                IssueFieldCollector.putStringInAttributes(attributes, this.customFieldIdStr, o_teamName.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

