/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.ifc.system;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import io.vavr.control.Option;
import java.util.Map;
import vivid.trace.ifc.IssueFieldCollector;
import vivid.trace.ifc.system.SystemFieldCollector;

public class ProjectSystemFieldCollector
implements SystemFieldCollector {
    private static final String ATTRIBUTE_KEY = ":jira.issue-field.system/project";

    @Override
    public String id() {
        return ATTRIBUTE_KEY;
    }

    @Override
    public String i18nKey() {
        return "issue.field.project";
    }

    @Override
    public void collect(Issue issue, Map<String, Object> attributes, IssueFieldCollector context) {
        Project project = issue.getProjectObject();
        if (project != null) {
            Option<String> id = IssueFieldCollector.putLongInAttributes(attributes, ATTRIBUTE_KEY, project.getId());
            IssueFieldCollector.noteProject(context, project, id);
        }
    }
}

