/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.jira.lib;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.util.JqlIssueSupport;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.joda.time.DateTime;
import vivid.lib.I18n;
import vivid.lib.Primitives;
import vivid.lib.messages.Message;
import vivid.lib.messages.VTE20UnknownObject;
import vivid.trace.components.Factory;

public class Jira {
    public static final String LINKS_FUNCTION_NAME = "links";
    public static final String PARENTS_FUNCTION_NAME = "parents";
    public static final String RELATIONS_FUNCTION_NAME = "relations";
    public static final String RELATES_WITH_FUNCTION_NAME = "relatesWith";
    public static final String SUBTASKS_FUNCTION_NAME = "subtasks";
    public static final String INWARD_ISSUE_LINKS_KEYWORD = "inward";
    public static final String OUTWARD_ISSUE_LINKS_KEYWORD = "outward";
    public static final String PARENTS_KEYWORD = "parents";
    public static final String SUBTASKS_KEYWORD = "subtasks";
    public static final String PARENT_SUBTASK_RELATION_OUTWARD_NAME = "Sub-task";
    private static final String JIRA_SOFTWARE_EPIC_STORY_ISSUE_LINK_TYPE_STYLE = "jira_gh_epic_story";

    private Jira() {
    }

    public static Collection<IssueType> allArtifactTypes(IssueTypeManager issueTypeManager) {
        return issueTypeManager.getIssueTypes();
    }

    public static Collection<IssueLinkType> allIssueLinkTypes(IssueLinkTypeManager issueLinkTypeManager) {
        ArrayList<IssueLinkType> issueLinkTypes = new ArrayList<IssueLinkType>();
        issueLinkTypes.addAll(issueLinkTypeManager.getIssueLinkTypes());
        issueLinkTypes.addAll(issueLinkTypeManager.getIssueLinkTypesByStyle(JIRA_SOFTWARE_EPIC_STORY_ISSUE_LINK_TYPE_STYLE));
        return issueLinkTypes;
    }

    public static TimeZoneInfo timeZoneInfoForUser(ApplicationUser user, TimeZoneService timeZoneService) {
        TimeZoneInfo userTimeZoneInfo;
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(user);
        if (user != null && (userTimeZoneInfo = timeZoneService.getUserTimeZoneInfo((JiraServiceContext)jiraServiceContext)) != null) {
            return userTimeZoneInfo;
        }
        return timeZoneService.getDefaultTimeZoneInfo((JiraServiceContext)jiraServiceContext);
    }

    public static String formatDateForLoggedInUser(DateTime date, DateTimeFormatterFactory dateTimeFormatterFactory) {
        return dateTimeFormatterFactory.formatter().forLoggedInUser().withStyle(DateTimeStyle.DATE).format(date.toDate());
    }

    public static Either<Reason, Issue> getIssueSecure(Issue issue, ApplicationUser user, boolean securityOverride, PermissionManager permissionManager) {
        if (issue == null) {
            return Either.left(Reason.Nonexistent);
        }
        if (!securityOverride && !permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, issue, user)) {
            return Either.left(Reason.InsufficientPermissions);
        }
        return Either.right(issue);
    }

    public static Either<vivid.lib.messages.MessageSet, Project> getProject(Factory factory, String rawValue, Option<ApplicationUser> user) {
        Project project = null;
        try {
            Long projectId = Long.valueOf(rawValue);
            project = factory.projectManager.getProjectObj(projectId);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (project == null) {
            project = factory.projectManager.getProjectObjByKey(rawValue);
        }
        if (project == null) {
            project = factory.projectManager.getProjectObjByName(rawValue);
        }
        if (project == null) {
            return Either.left(Jira.messageSetOfVTE20ProjectKey(factory.i18nResolverAdapterOption, rawValue));
        }
        if (user.isDefined() && !factory.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, user.get())) {
            return Either.left(Jira.messageSetOfVTE20ProjectKey(factory.i18nResolverAdapterOption, rawValue));
        }
        return Either.right(project);
    }

    public static Option<ApplicationUser> getUser(Factory factory, String literal) {
        ApplicationUser user = factory.userManager.getUserByKey(literal);
        if (user == null) {
            user = factory.userManager.getUserByName(literal);
        }
        return Option.of(user);
    }

    public static vivid.lib.messages.MessageSet messageSetOfVTE20ProjectKey(Option<I18n.ResolverAdapter> i18nResolverAdapterOption, String rawValue) {
        return vivid.lib.messages.MessageSet.of(VTE20UnknownObject.message(i18nResolverAdapterOption, "vivid.phrase.project-key", rawValue));
    }

    public static boolean hasAnyJiraGlobalAdminPermission(GlobalPermissionManager globalPermissionManager, ApplicationUser user) {
        return globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user) || globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }

    public static boolean hasJiraAdministratorsPermission(GlobalPermissionManager globalPermissionManager, ApplicationUser user) {
        return globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }

    public static boolean hasJiraSystemAdministratorsPermission(GlobalPermissionManager globalPermissionManager, ApplicationUser user) {
        return globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user);
    }

    public static boolean hasVisibleProjects(PermissionManager permissionManager, ApplicationUser user) {
        return permissionManager.hasProjects(ProjectPermissions.BROWSE_PROJECTS, user);
    }

    public static boolean isAnyIssueLinkTypeTraversable(Collection<Long> effectiveIssueLinkTypesOverride, Collection<IssueLink> issueLinks) {
        for (IssueLink issueLink : issueLinks) {
            if (!Jira.isIssueLinkTypeTraversable(effectiveIssueLinkTypesOverride, issueLink)) continue;
            return true;
        }
        return false;
    }

    public static boolean isArtifactTypeVisitable(Collection<String> effectiveArtifactTypesOverride, String artifactTypeId) {
        return effectiveArtifactTypesOverride.contains(artifactTypeId);
    }

    public static boolean isIssueLinkTypeTraversable(Collection<Long> effectiveIssueLinkTypesOverride, IssueLink issueLink) {
        Long issueLinkTypeId = issueLink.getLinkTypeId();
        return effectiveIssueLinkTypesOverride.contains(issueLinkTypeId);
    }

    public static Issue issueForArg(String issueArg, ApplicationUser user, boolean overrideSecurity, JqlIssueSupport jqlIssueSupport) {
        Issue issueByKey;
        Issue issue = issueByKey = overrideSecurity ? jqlIssueSupport.getIssue(issueArg) : jqlIssueSupport.getIssue(issueArg, user);
        if (issueByKey != null) {
            return issueByKey;
        }
        Long issueId = Primitives.asLong(issueArg);
        if (issueId != null) {
            Issue issueById;
            Issue issue2 = issueById = overrideSecurity ? jqlIssueSupport.getIssue(issueId.longValue()) : jqlIssueSupport.getIssue(issueId.longValue(), user);
            if (issueById != null) {
                return issueById;
            }
        }
        return null;
    }

    public static MessageSetImpl emptyJiraMessageSet() {
        return new MessageSetImpl();
    }

    public static MessageSet toJiraMessageSet(vivid.lib.messages.MessageSet messageSet) {
        MessageSetImpl jmsi = new MessageSetImpl();
        block3: for (Message message : messageSet) {
            switch (message.getType()) {
                case ERROR: {
                    jmsi.addErrorMessage(message.getMessage());
                    continue block3;
                }
            }
            jmsi.addWarningMessage(message.getMessage());
        }
        return jmsi;
    }

    public static List<Issue> searchIssueResults(SearchService searchService, ApplicationUser searcher, Query query) throws SearchException {
        SearchResults searchResults = searchService.search(searcher, query, PagerFilter.getUnlimitedFilter());
        return searchResults.getResults();
    }

    public static String upmUrl(ApplicationProperties applicationProperties, String pluginKey) {
        return applicationProperties.getBaseUrl(UrlMode.CANONICAL) + "/plugins/servlet/upm#manage/" + pluginKey;
    }

    public static enum Reason {
        InsufficientPermissions,
        Nonexistent;

    }
}

