/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.jira.servlets;

import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.vavr.control.Option;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class BulkOperationServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String JQL_QUERY_PARAMETER_KEY = "jqlQuery";
    private final JqlQueryParser jqlQueryParser;

    public BulkOperationServlet(@ComponentImport JqlQueryParser jqlQueryParser) {
        this.jqlQueryParser = jqlQueryParser;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String jqlQuery;
        HttpSession session = request.getSession();
        if (session != null && (jqlQuery = request.getParameter(JQL_QUERY_PARAMETER_KEY)) != null) {
            this.setJqlQueryAsSearchRequestInSession(jqlQuery, session);
        }
        response.sendRedirect(request.getContextPath() + "/secure/views/bulkedit/BulkEdit1!default.jspa?reset=true");
    }

    private void setJqlQueryAsSearchRequestInSession(String jqlQuery, HttpSession session) {
        Option<SearchRequest> searchRequestOption = this.createSearchRequest(jqlQuery);
        if (searchRequestOption.isDefined()) {
            session.setAttribute("jira.issue.navigator.search.request", (Object)searchRequestOption.get());
        }
    }

    private Option<SearchRequest> createSearchRequest(String jqlQuery) {
        try {
            return Option.of(new SearchRequest(this.jqlQueryParser.parseQuery(jqlQuery)));
        }
        catch (JqlParseException e) {
            return Option.none();
        }
    }
}

