/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.jql;

import com.atlassian.sal.api.ApplicationProperties;
import io.vavr.control.Option;
import java.io.Serializable;
import java.util.EnumSet;
import vivid.lib.I18n;
import vivid.lib.atlassian.messages.MessageReportingAdapter;
import vivid.lib.messages.MessageFormat;
import vivid.lib.messages.MessageSet;
import vivid.lib.messages.MessageType;
import vivid.lib.messages.VTE16DirectionsCustomFieldInvalid;
import vivid.lib.messages.VTE17LicenseInvalid;
import vivid.lib.messages.VTW1JqlFunctionIssueLinkingDeactivated;
import vivid.lib.messages.VTW2JqlFunctionSubTasksDeactivated;
import vivid.trace.components.Factory;
import vivid.trace.customfield.Direction;
import vivid.trace.jql.relations.RelationsParameters;
import vivid.trace.license.AddOnLicensing;
import vivid.trace.license.License;

public class JqlMessageReportingAdapter
implements MessageReportingAdapter {
    private final AddOnLicensing addOnLicensing;
    private final Factory f;
    private final String functionName;
    private final Option<RelationsParameters> relationsParametersOption;

    public JqlMessageReportingAdapter(AddOnLicensing addOnLicensing, Factory factory, String functionName, Option<RelationsParameters> relationsParametersOption) {
        this.addOnLicensing = addOnLicensing;
        this.f = factory;
        this.functionName = functionName;
        this.relationsParametersOption = relationsParametersOption;
    }

    @Override
    public void reportAddOnUnlicensed(MessageSet messageSet, boolean hasAnyJiraGlobalAdminPermission) {
        String errorDetail;
        Option<License> licenseOption = this.addOnLicensing.getActiveLicense(this.f.i18nResolverAdapterOption);
        if (licenseOption.isEmpty()) {
            errorDetail = I18n.getText(this.f.i18nResolverAdapterOption, "vivid.phrase.license-not-found", new Serializable[0]);
        } else {
            License license = licenseOption.get();
            MessageSet statusMessages = license.getStatusMessages(this.f.i18nResolverAdapterOption, this.f.dateTimeFormatterFactory, this.f.addOnInformation);
            errorDetail = statusMessages.joinMessagesOfTypes("\n", MessageType.ERROR);
        }
        messageSet.add(VTE17LicenseInvalid.messageWithLicenseError(this.f.i18nResolverAdapterOption, errorDetail));
    }

    @Override
    public void reportDirectionsCustomFieldInvalid(MessageSet messageSet, boolean hasAnyJiraGlobalAdminPermission) {
        messageSet.add(VTE16DirectionsCustomFieldInvalid.message(this.f.i18nResolverAdapterOption, hasAnyJiraGlobalAdminPermission, MessageFormat.HTML, this.f.applicationProperties));
    }

    @Override
    public void reportIssueLinkingDeactivated(MessageSet messageSet, ApplicationProperties applicationProperties) {
        if (this.isInEffectiveDirections(Direction.INWARD_ISSUE_LINKS, Direction.OUTWARD_ISSUE_LINKS)) {
            messageSet.add(VTW1JqlFunctionIssueLinkingDeactivated.message(this.f.i18nResolverAdapterOption, this.functionName));
        }
    }

    @Override
    public void reportSubTasksDisabled(MessageSet messageSet, ApplicationProperties applicationProperties) {
        if (this.isInEffectiveDirections(Direction.PARENTS, Direction.SUBTASKS)) {
            messageSet.add(VTW2JqlFunctionSubTasksDeactivated.message(this.f.i18nResolverAdapterOption, this.functionName));
        }
    }

    private boolean isInEffectiveDirections(Direction ... directions) {
        if (this.relationsParametersOption.isEmpty()) {
            return false;
        }
        EnumSet<Direction> effectiveDirections = this.relationsParametersOption.get().getEffectiveDirections();
        for (Direction d : directions) {
            if (!effectiveDirections.contains((Object)d)) continue;
            return true;
        }
        return false;
    }
}

