/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.jql.relations;

import com.atlassian.jira.project.Project;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import vivid.lib.Primitives;
import vivid.trace.components.ProjectConfigurations;
import vivid.trace.jql.relations.RelationsParameters;

public class MemoizedIssueLinkTypes {
    private final RelationsParameters params;
    private final ProjectConfigurations projectConfigurations;
    private final Map<Long, Supplier<Collection<Long>>> memo = new HashMap<Long, Supplier<Collection<Long>>>();

    public MemoizedIssueLinkTypes(RelationsParameters params, ProjectConfigurations projectConfigurations) {
        this.params = params;
        this.projectConfigurations = projectConfigurations;
    }

    public Collection<Long> get(Project project) {
        if (!this.params.isProjectConfigDeprecatedFlag()) {
            return this.params.getEffectiveIssueLinkTypes();
        }
        Long projectId = project.getId();
        if (!this.memo.containsKey(projectId)) {
            this.memo.put(projectId, () -> {
                Set<String> enabledIssueLinkTypeIdStrings = this.projectConfigurations.getEnabledIssueLinkTypeIds(project);
                return Primitives.asLongs(enabledIssueLinkTypeIdStrings);
            });
        }
        return this.memo.get(projectId).get();
    }
}

