/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.jql.relations;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.user.ApplicationUser;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vivid.lib.I18n;
import vivid.lib.messages.VTW12DiscrepencyBetweenCustomFieldAndJira;
import vivid.trace.components.Factory;
import vivid.trace.components.ProjectConfigurations;
import vivid.trace.customfield.Direction;
import vivid.trace.customfield.DirectionsCFType;
import vivid.trace.jira.lib.Jira;
import vivid.trace.jql.relations.MemoizedArtifactTypes;
import vivid.trace.jql.relations.MemoizedIssueLinkTypes;
import vivid.trace.jql.relations.RelationsParameters;
import vivid.trace.jql.relations.RelationsResults;

@Named
public class RelationsAlgorithm {
    private static final Logger log = LoggerFactory.getLogger(RelationsAlgorithm.class);
    private static final Option<Integer> INFINITE_DISTANCE = Option.none();
    private final Factory f;
    private final ProjectConfigurations projectConfiguration;

    @Inject
    public RelationsAlgorithm(Factory factory, ProjectConfigurations projectConfiguration) {
        this.f = Objects.requireNonNull(factory);
        this.projectConfiguration = Objects.requireNonNull(projectConfiguration);
    }

    private static void logVTW_12(Option<I18n.ResolverAdapter> i18nResolverAdapterOption, Issue issue, String relation) {
        log.debug(VTW12DiscrepencyBetweenCustomFieldAndJira.message(i18nResolverAdapterOption, "VTDirections", issue.getKey(), relation).getMessage());
    }

    private static Long millisFromNow(int offset) {
        return System.currentTimeMillis() + (long)offset;
    }

    private <V> void depthFirstTraversal(Queue<QEntry<V>> visitQueue, TraversalAdapter<V> adapter) {
        while (!visitQueue.isEmpty()) {
            QEntry<V> current = visitQueue.remove();
            if (adapter.isMarked(current.vertex)) continue;
            boolean cont = adapter.mark(current.vertex);
            if (!cont) break;
            if (current.distance.isDefined() && current.distance.get() <= 0) {
                adapter.adj(current, Option.none());
                continue;
            }
            adapter.adj(current, Option.of(visitQueue));
        }
    }

    public RelationsResults execute(RelationsParameters params, ApplicationUser user, Option<I18n.ResolverAdapter> i18nResolverAdapterOption, boolean securityOverride, Option<? extends TraversalAdapterObserver> traversalAdapterObserverOption, Option<Integer> issueCountSoftMaximum, Option<Integer> graphTraversalTimeLimit) {
        Option<Long> processingTimeLimit;
        LinkedHashSet<Long> visited = new LinkedHashSet<Long>();
        RelationsResults.Builder results = new RelationsResults.Builder();
        MemoizedArtifactTypes memoizedArtifactTypes = new MemoizedArtifactTypes(params, this.projectConfiguration);
        MemoizedIssueLinkTypes memoizedIssueLinkTypes = new MemoizedIssueLinkTypes(params, this.projectConfiguration);
        Option<Long> option = processingTimeLimit = graphTraversalTimeLimit.isDefined() ? Option.of(RelationsAlgorithm.millisFromNow(graphTraversalTimeLimit.get())) : Option.none();
        if (params.getDistance().isDefined() || !params.isIssueLinkTypesFullComplement() || params.isProjectConfigDeprecatedFlag()) {
            for (Issue seedIssue : params.getSeedIssues()) {
                if (issueCountSoftMaximum.isDefined() && visited.size() >= issueCountSoftMaximum.get()) {
                    results.noteIssueCountSoftMaximumTruncation(issueCountSoftMaximum);
                    break;
                }
                LinkedList visitQueue = new LinkedList();
                visitQueue.add(new QEntry<Issue>(seedIssue, params.getDistance()));
                HashSet<Long> scopedVisited = new HashSet<Long>();
                Collection<String> effectiveArtifactTypeOverride = memoizedArtifactTypes.get(seedIssue.getProjectObject());
                Collection<Long> effectiveIssueLinkTypeOverride = memoizedIssueLinkTypes.get(seedIssue.getProjectObject());
                this.depthFirstTraversal(visitQueue, new MyAdapter(params, user, i18nResolverAdapterOption, securityOverride, scopedVisited, traversalAdapterObserverOption, issueCountSoftMaximum, processingTimeLimit, results, effectiveArtifactTypeOverride, effectiveIssueLinkTypeOverride));
                visited.addAll(scopedVisited);
            }
        } else {
            LinkedList visitQueue = new LinkedList();
            for (Issue seedIssue : params.getSeedIssues()) {
                visitQueue.add(new QEntry<Issue>(seedIssue, INFINITE_DISTANCE));
                Collection<String> effectiveArtifactTypeOverride = memoizedArtifactTypes.get(seedIssue.getProjectObject());
                Collection<Long> effectiveIssueLinkTypeOverride = memoizedIssueLinkTypes.get(seedIssue.getProjectObject());
                this.depthFirstTraversal(visitQueue, new MyAdapter(params, user, i18nResolverAdapterOption, securityOverride, visited, traversalAdapterObserverOption, issueCountSoftMaximum, processingTimeLimit, results, effectiveArtifactTypeOverride, effectiveIssueLinkTypeOverride));
            }
        }
        params.getInclusiveStrategy().execute(params, visited);
        return results.issues(visited).build();
    }

    private static class QEntry<V> {
        final V vertex;
        final Option<Integer> distance;

        private QEntry(V vertex, Option<Integer> distance) {
            this.vertex = vertex;
            this.distance = distance;
        }

        private QEntry<V> traverse(V to) {
            return new QEntry<V>(to, this.distance.isDefined() ? Option.of(this.distance.get() - 1) : INFINITE_DISTANCE);
        }

        public boolean equals(Object o) {
            return this.vertex.equals(o);
        }

        public int hashCode() {
            return this.vertex.hashCode();
        }
    }

    private static interface TraversalAdapter<V> {
        public void adj(QEntry<V> var1, Option<Queue<QEntry<V>>> var2);

        public boolean isMarked(V var1);

        public boolean mark(V var1);
    }

    class MyAdapter
    implements TraversalAdapter<Issue> {
        private final RelationsParameters params;
        private final ApplicationUser user;
        private final Option<I18n.ResolverAdapter> i18nResolverAdapterOption;
        private final boolean securityOverride;
        private final Collection<Long> visited;
        private final Option<? extends TraversalAdapterObserver> traversalAdapterObserverOption;
        private final Option<Integer> issueCountSoftMaximum;
        private final Option<Long> processingTimeLimit;
        private final RelationsResults.Builder results;
        private final Collection<String> effectiveArtifactTypesOverride;
        private final Collection<Long> effectiveIssueLinkTypesOverride;
        private final CustomField directionsField;

        MyAdapter(RelationsParameters params, ApplicationUser user, Option<I18n.ResolverAdapter> i18nResolverAdapterOption, boolean securityOverride, Collection<Long> visited, Option<? extends TraversalAdapterObserver> traversalAdapterObserverOption, Option<Integer> issueCountSoftMaximum, Option<Long> processingTimeLimit, RelationsResults.Builder results, Collection<String> effectiveArtifactTypesOverride, Collection<Long> effectiveIssueLinkTypesOverride) {
            this.params = params;
            this.user = user;
            this.i18nResolverAdapterOption = i18nResolverAdapterOption;
            this.securityOverride = securityOverride;
            this.visited = visited;
            this.traversalAdapterObserverOption = traversalAdapterObserverOption;
            this.issueCountSoftMaximum = issueCountSoftMaximum;
            this.processingTimeLimit = processingTimeLimit;
            this.results = results;
            this.effectiveArtifactTypesOverride = effectiveArtifactTypesOverride;
            this.effectiveIssueLinkTypesOverride = effectiveIssueLinkTypesOverride;
            this.directionsField = DirectionsCFType.getCustomField(RelationsAlgorithm.this.f.customFieldManager);
        }

        @Override
        public void adj(QEntry<Issue> current, Option<Queue<QEntry<Issue>>> visitQueueOption) {
            List issueLinks;
            if (visitQueueOption.isEmpty() && this.traversalAdapterObserverOption.isEmpty()) {
                return;
            }
            Double directionsValue = (Double)((Issue)current.vertex).getCustomFieldValue(this.directionsField);
            EnumSet<Direction> d = Direction.decode(directionsValue);
            d.retainAll(this.params.getEffectiveDirections());
            if (d.contains((Object)Direction.PARENTS)) {
                Issue parent = ((Issue)current.vertex).getParentObject();
                if (parent != null) {
                    if (Jira.isArtifactTypeVisitable(this.effectiveArtifactTypesOverride, parent.getIssueTypeId())) {
                        if (visitQueueOption.isDefined()) {
                            visitQueueOption.get().add(current.traverse(parent));
                        }
                        this.notifyObserversOfNotedRelation(parent, "Sub-task", (Issue)current.vertex);
                    }
                } else {
                    RelationsAlgorithm.logVTW_12(this.i18nResolverAdapterOption, (Issue)current.vertex, "parent issue(s)");
                }
            }
            if (d.contains((Object)Direction.SUBTASKS)) {
                Collection subTasks = ((Issue)current.vertex).getSubTaskObjects();
                if (subTasks != null) {
                    for (Issue subTask : subTasks) {
                        if (!Jira.isArtifactTypeVisitable(this.effectiveArtifactTypesOverride, subTask.getIssueTypeId())) continue;
                        if (visitQueueOption.isDefined()) {
                            visitQueueOption.get().add(current.traverse(subTask));
                        }
                        this.notifyObserversOfNotedRelation((Issue)current.vertex, "Sub-task", subTask);
                    }
                } else {
                    RelationsAlgorithm.logVTW_12(this.i18nResolverAdapterOption, (Issue)current.vertex, "sub-task issue(s)");
                }
            }
            if (d.contains((Object)Direction.INWARD_ISSUE_LINKS)) {
                issueLinks = RelationsAlgorithm.this.f.issueLinkManager.getInwardLinks(((Issue)current.vertex).getId());
                if (issueLinks != null) {
                    for (IssueLink link : issueLinks) {
                        if (!Jira.isIssueLinkTypeTraversable(this.effectiveIssueLinkTypesOverride, link) || !Jira.isArtifactTypeVisitable(this.effectiveArtifactTypesOverride, link.getSourceObject().getIssueTypeId())) continue;
                        if (visitQueueOption.isDefined()) {
                            visitQueueOption.get().add(current.traverse(link.getSourceObject()));
                        }
                        this.notifyObserversOfNotedRelation(link.getSourceObject(), link.getIssueLinkType().getOutward(), link.getDestinationObject());
                    }
                } else {
                    RelationsAlgorithm.logVTW_12(this.i18nResolverAdapterOption, (Issue)current.vertex, "inward issue link(s)");
                }
            }
            if (d.contains((Object)Direction.OUTWARD_ISSUE_LINKS)) {
                issueLinks = RelationsAlgorithm.this.f.issueLinkManager.getOutwardLinks(((Issue)current.vertex).getId());
                if (issueLinks != null) {
                    for (IssueLink link : issueLinks) {
                        if (!Jira.isIssueLinkTypeTraversable(this.effectiveIssueLinkTypesOverride, link) || !Jira.isArtifactTypeVisitable(this.effectiveArtifactTypesOverride, link.getDestinationObject().getIssueTypeId())) continue;
                        if (visitQueueOption.isDefined()) {
                            visitQueueOption.get().add(current.traverse(link.getDestinationObject()));
                        }
                        this.notifyObserversOfNotedRelation(link.getSourceObject(), link.getIssueLinkType().getOutward(), link.getDestinationObject());
                    }
                } else {
                    RelationsAlgorithm.logVTW_12(this.i18nResolverAdapterOption, (Issue)current.vertex, "outward issue link(s)");
                }
            }
        }

        @Override
        public boolean isMarked(Issue vertex) {
            if (this.visited.contains(vertex.getId())) {
                return true;
            }
            Either<Jira.Reason, Issue> x = Jira.getIssueSecure(vertex, this.user, this.securityOverride, RelationsAlgorithm.this.f.permissionManager);
            if (x.isLeft() && x.getLeft() == Jira.Reason.InsufficientPermissions) {
                this.results.noteInsufficientPermissions();
            }
            return x.isLeft();
        }

        @Override
        public boolean mark(Issue vertex) {
            if (this.issueCountSoftMaximum.isDefined() && this.visited.size() >= this.issueCountSoftMaximum.get()) {
                this.results.noteIssueCountSoftMaximumTruncation(this.issueCountSoftMaximum);
                return false;
            }
            if (this.processingTimeLimit.isDefined() && System.currentTimeMillis() >= this.processingTimeLimit.get()) {
                this.results.noteGraphTraversalTimeLimitElapsed();
                return false;
            }
            this.visited.add(vertex.getId());
            this.notifyObserversOfMarkedVertex(vertex);
            return true;
        }

        private void notifyObserversOfMarkedVertex(Issue vertex) {
            if (this.traversalAdapterObserverOption.isDefined()) {
                this.traversalAdapterObserverOption.get().markedVertex(vertex);
            }
        }

        private void notifyObserversOfNotedRelation(Issue outwardIssue, String relationOutwardName, Issue inwardIssue) {
            if (this.traversalAdapterObserverOption.isDefined()) {
                this.traversalAdapterObserverOption.get().notedRelation(outwardIssue, relationOutwardName, inwardIssue);
            }
        }
    }

    public static interface TraversalAdapterObserver {
        public void markedVertex(Issue var1);

        public void notedRelation(Issue var1, String var2, Issue var3);
    }
}

