/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.jql.relations;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.user.ApplicationUser;
import io.vavr.Tuple2;
import io.vavr.collection.HashMultimap;
import io.vavr.collection.Multimap;
import io.vavr.collection.Stream;
import io.vavr.collection.Traversable;
import io.vavr.control.Option;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import vivid.lib.I18n;
import vivid.lib.Primitives;
import vivid.lib.messages.MessageSet;
import vivid.lib.messages.VTE10JqlFunctionAtLeastOneEffectiveDirection;
import vivid.lib.messages.VTE11JqlFunctionIntegerOutOfRange;
import vivid.lib.messages.VTE12JqlFunctionCouldNotGetSearchResults;
import vivid.lib.messages.VTE19InternalError;
import vivid.lib.messages.VTE1JqlFunctionParameterValuesNotFound;
import vivid.lib.messages.VTE32ArtifactTypeAmbiguous;
import vivid.lib.messages.VTE6JqlFunctionJqlQueryError;
import vivid.lib.messages.VTE7JqlFunctionParameterAtMostOnce;
import vivid.lib.messages.VTE8JqlFunctionIssueLinkTypeAmbiguous;
import vivid.lib.messages.VTW11JqlFunctionJqlQueryWarning;
import vivid.lib.messages.VTW16NoEffectiveIssueLinkTypes;
import vivid.lib.messages.VTW19JqlFunctionParameterDeprecated;
import vivid.lib.messages.VTW5JqlFunctionIssueLinkTypesWithoutDirection;
import vivid.trace.components.Factory;
import vivid.trace.customfield.Direction;
import vivid.trace.jira.lib.Jira;
import vivid.trace.jql.relations.DefaultInclusiveStrategy;
import vivid.trace.jql.relations.InclusiveStrategy;

public class RelationsParameters {
    public static final String ARTIFACT_TYPE_PARAMETER_NAME = "artifactType";
    public static final String DIRECTION_PARAMETER_NAME = "direction";
    public static final String DISTANCE_PARAMETER_NAME = "distance";
    public static final String INCLUSIVE_PARAMETER_NAME = "inclusive";
    public static final String ISSUE_LINK_TYPE_PARAMETER_NAME = "issueLinkType";
    public static final String JQL_PARAMETER_NAME = "jql";
    public static final String PROJECT_CONFIG_PARAMETER_NAME = "projectConfig";
    private final boolean projectConfigDeprecatedFlag;
    private final Option<Integer> distance;
    private final Collection<String> effectiveArtifactTypes;
    private final Collection<Long> effectiveIssueLinkTypes;
    private final EnumSet<Direction> effectiveDirections;
    private final boolean inclusive;
    private final boolean isArtifactTypesFullComplement;
    private final boolean isDirectionsFullComplement;
    private final boolean isIssueLinkTypesFullComplement;
    private final boolean isSeedIssuesSpecified;
    private final Iterable<Issue> seedIssues;
    private final InclusiveStrategy inclusiveStrategy;

    public RelationsParameters(Builder builder, Option<MessageSet> messageSetOption, Factory f, ApplicationUser searcher, String functionName) {
        this.distance = builder.validateDistance(messageSetOption, functionName, f);
        this.effectiveArtifactTypes = builder.validateArtifactTypes(messageSetOption, functionName, f);
        this.effectiveDirections = builder.validateDirections(messageSetOption, functionName, f);
        this.effectiveIssueLinkTypes = builder.validateIssueLinkTypes(this.effectiveDirections, f, messageSetOption, functionName);
        this.inclusive = builder.validateInclusive(messageSetOption, functionName, f);
        this.isArtifactTypesFullComplement = RelationsParameters.calculateIsArtifactTypesFullComplement(builder, this.effectiveArtifactTypes, f);
        this.isDirectionsFullComplement = RelationsParameters.calculateIsDirectionsFullComplement(this.effectiveDirections);
        this.isIssueLinkTypesFullComplement = RelationsParameters.calculateIsIssueLinkTypesFullComplement(builder, this.effectiveIssueLinkTypes, f);
        this.isSeedIssuesSpecified = !builder.issueLiterals.isEmpty() || !builder.jqlQueries.isEmpty();
        this.projectConfigDeprecatedFlag = builder.validateProjectConfig(messageSetOption, functionName, f);
        this.seedIssues = builder.validateSeedIssues(searcher, messageSetOption, f, functionName);
        this.inclusiveStrategy = builder.inclusiveStrategy;
    }

    private static Map<String, String> artifactTypesIdMap(IssueTypeManager issueTypeManager) {
        Collection<IssueType> issueTypes = Jira.allArtifactTypes(issueTypeManager);
        HashMap<String, String> idMap = new HashMap<String, String>();
        for (IssueType i : issueTypes) {
            idMap.put(i.getName(), i.getId());
        }
        return idMap;
    }

    private static Multimap<String, String> artifactTypesIdentifierMap(IssueTypeManager issueTypeManager) {
        return HashMultimap.withSeq().ofEntries(Stream.ofAll(Jira.allArtifactTypes(issueTypeManager)).flatMap(artifactType -> Stream.of(new Tuple2<String, String>(artifactType.getName().toLowerCase(), artifactType.getId()))));
    }

    private static boolean calculateIsArtifactTypesFullComplement(Builder builder, Collection<String> effectiveArtifactTypes, Factory f) {
        if (builder.artifactTypes.isEmpty()) {
            return true;
        }
        Collection all = f.issueTypeManager.getIssueTypes();
        if (all.size() != effectiveArtifactTypes.size()) {
            return false;
        }
        for (IssueType at : all) {
            if (effectiveArtifactTypes.contains(at.getId())) continue;
            return false;
        }
        return true;
    }

    private static boolean calculateIsDirectionsFullComplement(EnumSet<Direction> effectiveDirections) {
        return effectiveDirections.containsAll(EnumSet.allOf(Direction.class));
    }

    private static boolean calculateIsIssueLinkTypesFullComplement(Builder builder, Collection<Long> effectiveIssueLinkTypes, Factory f) {
        if (builder.issueLinkTypes.isEmpty()) {
            return true;
        }
        Collection all = f.issueLinkTypeManager.getIssueLinkTypes();
        if (all.size() != effectiveIssueLinkTypes.size()) {
            return false;
        }
        for (IssueLinkType ilt : all) {
            if (effectiveIssueLinkTypes.contains(ilt.getId())) continue;
            return false;
        }
        return true;
    }

    public Option<Integer> getDistance() {
        return this.distance;
    }

    public Collection<String> getEffectiveArtifactTypes() {
        return this.effectiveArtifactTypes;
    }

    public EnumSet<Direction> getEffectiveDirections() {
        return this.effectiveDirections;
    }

    public Collection<Long> getEffectiveIssueLinkTypes() {
        return this.effectiveIssueLinkTypes;
    }

    public InclusiveStrategy getInclusiveStrategy() {
        return this.inclusiveStrategy;
    }

    public Iterable<Issue> getSeedIssues() {
        return this.seedIssues;
    }

    public boolean isArtifactTypesFullComplement() {
        return this.isArtifactTypesFullComplement;
    }

    public boolean isDirectionsFullComplement() {
        return this.isDirectionsFullComplement;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public boolean isIssueLinkTypesFullComplement() {
        return this.isIssueLinkTypesFullComplement;
    }

    public boolean isProjectConfigDeprecatedFlag() {
        return this.projectConfigDeprecatedFlag;
    }

    public boolean isSeedIssuesSpecified() {
        return this.isSeedIssuesSpecified;
    }

    public String toString() {
        return "RelationsParameters{effectiveArtifactTypes=" + String.valueOf(this.effectiveArtifactTypes) + ", effectiveDirections=" + String.valueOf(this.effectiveDirections) + ", effectiveIssueLinkTypes=" + String.valueOf(this.effectiveIssueLinkTypes) + ", distance=" + String.valueOf(this.distance) + ", inclusive=" + this.inclusive + ", isSeedIssuesSpecified=" + this.isSeedIssuesSpecified() + ", projectConfig=" + this.projectConfigDeprecatedFlag + ", seedIssues=" + String.valueOf(this.seedIssues) + "}";
    }

    public static class Builder {
        private boolean projectConfigDeprecatedFlag = false;
        private final List<Mode> artifactTypeModes = new ArrayList<Mode>();
        private final List<String> artifactTypes = new ArrayList<String>();
        private final List<Mode> directionModes = new ArrayList<Mode>();
        private final List<Direction> directions = new ArrayList<Direction>();
        private final List<String> distances = new ArrayList<String>();
        private final List<Boolean> inclusives = new ArrayList<Boolean>();
        final List<String> issueLiterals = new ArrayList<String>();
        private final List<Mode> issueLinkTypeModes = new ArrayList<Mode>();
        private final List<String> issueLinkTypes = new ArrayList<String>();
        final List<String> jqlQueries = new ArrayList<String>();
        InclusiveStrategy inclusiveStrategy = new DefaultInclusiveStrategy();

        public Builder artifactType(Mode mode) {
            this.artifactTypeModes.add(mode);
            return this;
        }

        public Builder artifactType(String t) {
            this.artifactTypes.add(t);
            return this;
        }

        public Builder direction(Mode mode) {
            this.directionModes.add(mode);
            return this;
        }

        public Builder direction(Direction d) {
            this.directions.add(d);
            return this;
        }

        public Builder distance(String dist) {
            this.distances.add(dist);
            return this;
        }

        public Builder inclusive(boolean val) {
            this.inclusives.add(val);
            return this;
        }

        public Builder issue(String issue) {
            this.issueLiterals.add(issue);
            return this;
        }

        public Builder issueLinkType(Mode mode) {
            this.issueLinkTypeModes.add(mode);
            return this;
        }

        public Builder issueLinkType(String t) {
            this.issueLinkTypes.add(t);
            return this;
        }

        public Builder jql(String query) {
            this.jqlQueries.add(query);
            return this;
        }

        public Builder projectConfig() {
            this.projectConfigDeprecatedFlag = true;
            return this;
        }

        public RelationsParameters build(Option<MessageSet> messageSetOption, ApplicationUser searcher, Factory f, String functionName) {
            return new RelationsParameters(this, messageSetOption, f, searcher, functionName);
        }

        public String toString() {
            ArrayList<CallSite> m = new ArrayList<CallSite>();
            if (!this.artifactTypeModes.isEmpty()) {
                m.add((CallSite)((Object)("artifactTypeModes=" + String.valueOf(this.artifactTypeModes))));
            }
            if (!this.artifactTypes.isEmpty()) {
                m.add((CallSite)((Object)("artifactTypes=" + String.valueOf(this.artifactTypes))));
            }
            if (!this.directionModes.isEmpty()) {
                m.add((CallSite)((Object)("directionModes=" + String.valueOf(this.directionModes))));
            }
            if (!this.directions.isEmpty()) {
                m.add((CallSite)((Object)("directions=" + String.valueOf(this.directions))));
            }
            if (!this.distances.isEmpty()) {
                m.add((CallSite)((Object)("distances=" + String.valueOf(this.distances))));
            }
            if (!this.inclusives.isEmpty()) {
                m.add((CallSite)((Object)("inclusives=" + String.valueOf(this.inclusives))));
            }
            if (!this.issueLiterals.isEmpty()) {
                m.add((CallSite)((Object)("issueLiterals=" + String.valueOf(this.issueLiterals))));
            }
            if (!this.issueLinkTypeModes.isEmpty()) {
                m.add((CallSite)((Object)("issueLinkTypeModes=" + String.valueOf(this.issueLinkTypeModes))));
            }
            if (!this.issueLinkTypes.isEmpty()) {
                m.add((CallSite)((Object)("issueLinkTypes=" + String.valueOf(this.issueLinkTypes))));
            }
            if (!this.jqlQueries.isEmpty()) {
                m.add((CallSite)((Object)("jqlQueries=" + String.valueOf(this.jqlQueries))));
            }
            m.add((CallSite)((Object)("projectConfigDeprecatedFlag=" + this.projectConfigDeprecatedFlag)));
            return "Builder{" + String.join((CharSequence)", ", m) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Builder builder = (Builder)o;
            if (this.projectConfigDeprecatedFlag != builder.projectConfigDeprecatedFlag) {
                return false;
            }
            if (!this.artifactTypeModes.equals(builder.artifactTypeModes)) {
                return false;
            }
            if (!this.artifactTypes.equals(builder.artifactTypes)) {
                return false;
            }
            if (!this.directionModes.equals(builder.directionModes)) {
                return false;
            }
            if (!this.directions.equals(builder.directions)) {
                return false;
            }
            if (!this.distances.equals(builder.distances)) {
                return false;
            }
            if (!this.inclusives.equals(builder.inclusives)) {
                return false;
            }
            if (!this.issueLinkTypeModes.equals(builder.issueLinkTypeModes)) {
                return false;
            }
            if (!this.issueLinkTypes.equals(builder.issueLinkTypes)) {
                return false;
            }
            if (!this.issueLiterals.equals(builder.issueLiterals)) {
                return false;
            }
            return this.jqlQueries.equals(builder.jqlQueries);
        }

        public int hashCode() {
            int result = this.directionModes.hashCode();
            result = 31 * result + this.artifactTypeModes.hashCode();
            result = 31 * result + this.artifactTypes.hashCode();
            result = 31 * result + this.directions.hashCode();
            result = 31 * result + this.distances.hashCode();
            result = 31 * result + this.inclusives.hashCode();
            result = 31 * result + this.issueLiterals.hashCode();
            result = 31 * result + this.issueLinkTypeModes.hashCode();
            result = 31 * result + this.issueLinkTypes.hashCode();
            result = 31 * result + this.jqlQueries.hashCode();
            result = 31 * result + (this.projectConfigDeprecatedFlag ? 1 : 0);
            return result;
        }

        public boolean hasAnyDirection() {
            return !this.directionModes.isEmpty() || !this.directions.isEmpty();
        }

        public boolean hasAnyInclusive() {
            return !this.inclusives.isEmpty();
        }

        public boolean hasAnyIssueLiterals() {
            return !this.issueLiterals.isEmpty();
        }

        public boolean hasAnyJqlQueries() {
            return !this.jqlQueries.isEmpty();
        }

        public boolean hasAnySeedIssues() {
            return !this.issueLiterals.isEmpty() || !this.jqlQueries.isEmpty();
        }

        private static Map<String, Long> issueLinkTypesIdMap(IssueLinkTypeManager issueLinkTypeManager) {
            Collection<IssueLinkType> issueLinkTypes = Jira.allIssueLinkTypes(issueLinkTypeManager);
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (IssueLinkType i : issueLinkTypes) {
                idMap.put(i.getName(), i.getId());
            }
            return idMap;
        }

        private static Multimap<String, Long> issueLinkTypesIdentifierMap(IssueLinkTypeManager issueLinkTypeManager) {
            return HashMultimap.withSeq().ofEntries(Stream.ofAll(Jira.allIssueLinkTypes(issueLinkTypeManager)).flatMap(issueLinkType -> Stream.of(new Tuple2<String, Long>(issueLinkType.getName().toLowerCase(), issueLinkType.getId()), new Tuple2<String, Long>(issueLinkType.getInward().toLowerCase(), issueLinkType.getId()), new Tuple2<String, Long>(issueLinkType.getOutward().toLowerCase(), issueLinkType.getId()))));
        }

        public void setInclusiveStrategy(InclusiveStrategy inclusiveStrategy) {
            this.inclusiveStrategy = inclusiveStrategy;
        }

        private Collection<String> validateArtifactTypes(Option<MessageSet> messageSetOption, String functionName, Factory f) {
            Map<String, String> issueTypeNameToIds = RelationsParameters.artifactTypesIdMap(f.issueTypeManager);
            Mode mode = Mode.SUBTRACTIVE;
            Collection<String> effectiveArtifactTypes = issueTypeNameToIds.values();
            if (this.artifactTypeModes.size() == 1) {
                mode = this.artifactTypeModes.get(0);
                switch (mode.ordinal()) {
                    case 0: {
                        effectiveArtifactTypes = new ArrayList<String>();
                        break;
                    }
                    case 1: {
                        effectiveArtifactTypes = issueTypeNameToIds.values();
                    }
                }
            } else if (this.artifactTypeModes.size() > 1) {
                MessageSet.addMessageTo(messageSetOption, VTE7JqlFunctionParameterAtMostOnce.message(f.i18nResolverAdapterOption, functionName, RelationsParameters.ARTIFACT_TYPE_PARAMETER_NAME));
                return effectiveArtifactTypes;
            }
            ArrayList<String> artifactTypeIds = new ArrayList<String>();
            boolean hasAmbiguityErrors = false;
            ArrayList<String> unknowns = new ArrayList<String>();
            Multimap<String, String> artifactTypeMap = RelationsParameters.artifactTypesIdentifierMap(f.issueTypeManager);
            for (String i : this.artifactTypes) {
                IssueType issueType = f.issueTypeManager.getIssueType(i);
                if (issueType != null) {
                    artifactTypeIds.add(issueType.getId());
                    continue;
                }
                String at = i.toLowerCase();
                if (artifactTypeMap.containsKey(at)) {
                    Option<Traversable<String>> valuesOpt = artifactTypeMap.get(at);
                    if (valuesOpt.isEmpty() || valuesOpt.get().size() == 0) {
                        MessageSet.addMessageTo(messageSetOption, VTE19InternalError.message(f.i18nResolverAdapterOption, "Unexpected condition: Artifact type \"" + at + "\" key doesn't map to any values."));
                        return Collections.emptyList();
                    }
                    if (valuesOpt.get().size() == 1) {
                        artifactTypeIds.add((String)valuesOpt.get().iterator().next());
                        continue;
                    }
                    hasAmbiguityErrors = true;
                    TreeSet<String> ambiguities = new TreeSet<String>();
                    for (String v : valuesOpt.get()) {
                        ambiguities.add("\"" + f.issueTypeManager.getIssueType(v).getName() + "\" (ID " + v + ")");
                    }
                    MessageSet.addMessageTo(messageSetOption, VTE32ArtifactTypeAmbiguous.message(f.i18nResolverAdapterOption, i, ambiguities));
                    continue;
                }
                unknowns.add(i);
            }
            if (hasAmbiguityErrors) {
                return effectiveArtifactTypes;
            }
            if (!unknowns.isEmpty()) {
                MessageSet.addMessageTo(messageSetOption, VTE1JqlFunctionParameterValuesNotFound.message(f.i18nResolverAdapterOption, functionName, I18n.getText(f.i18nResolverAdapterOption, "vivid.trace.phrase.artifact-types", new Serializable[0]), unknowns));
                return effectiveArtifactTypes;
            }
            HashSet distinct = new HashSet(artifactTypeIds);
            block10: for (String i : distinct) {
                switch (mode.ordinal()) {
                    case 1: {
                        effectiveArtifactTypes.remove(i);
                        continue block10;
                    }
                    case 0: {
                        effectiveArtifactTypes.add(i);
                        continue block10;
                    }
                }
                MessageSet.addMessageTo(messageSetOption, VTE19InternalError.message(f.i18nResolverAdapterOption, "Unknown mode found while calculating effective artifact types: '" + String.valueOf((Object)mode) + "'"));
            }
            return effectiveArtifactTypes;
        }

        public EnumSet<Direction> validateDirections(Option<MessageSet> messageSetOption, String functionName, Factory f) {
            EnumSet<Direction> effectiveDirections = EnumSet.allOf(Direction.class);
            if (this.directionModes.size() == 1) {
                Mode mode = this.directionModes.get(0);
                effectiveDirections = mode == Mode.ADDITIVE ? Primitives.copyOfEnumSet(Direction.class, this.directions) : EnumSet.complementOf(Primitives.copyOfEnumSet(Direction.class, this.directions));
            } else if (this.directionModes.size() > 1) {
                MessageSet.addMessageTo(messageSetOption, VTE7JqlFunctionParameterAtMostOnce.message(f.i18nResolverAdapterOption, functionName, RelationsParameters.DIRECTION_PARAMETER_NAME));
                return effectiveDirections;
            }
            if (effectiveDirections.isEmpty()) {
                MessageSet.addMessageTo(messageSetOption, VTE10JqlFunctionAtLeastOneEffectiveDirection.message(f.i18nResolverAdapterOption, functionName, RelationsParameters.DIRECTION_PARAMETER_NAME));
            }
            return effectiveDirections;
        }

        private Option<Integer> validateDistance(Option<MessageSet> messageSetOption, String functionName, Factory f) {
            if (this.distances.size() == 1) {
                try {
                    Integer i = Integer.parseInt(this.distances.get(0));
                    if (i < 0) {
                        throw new IllegalArgumentException();
                    }
                    return Option.of(i);
                }
                catch (IllegalArgumentException e) {
                    MessageSet.addMessageTo(messageSetOption, VTE11JqlFunctionIntegerOutOfRange.message(f.i18nResolverAdapterOption, functionName, RelationsParameters.DISTANCE_PARAMETER_NAME, 0, Integer.MAX_VALUE));
                }
            } else if (this.distances.size() > 1) {
                MessageSet.addMessageTo(messageSetOption, VTE7JqlFunctionParameterAtMostOnce.message(f.i18nResolverAdapterOption, functionName, RelationsParameters.DISTANCE_PARAMETER_NAME));
            }
            return Option.none();
        }

        private boolean validateInclusive(Option<MessageSet> messageSetOption, String functionName, Factory f) {
            boolean v = true;
            if (this.inclusives.size() == 1) {
                v = this.inclusives.get(0);
            } else if (this.inclusives.size() > 1) {
                MessageSet.addMessageTo(messageSetOption, VTE7JqlFunctionParameterAtMostOnce.message(f.i18nResolverAdapterOption, functionName, RelationsParameters.INCLUSIVE_PARAMETER_NAME));
            }
            return v;
        }

        private Collection<Long> validateIssueLinkTypes(EnumSet<Direction> effectiveDirections, Factory f, Option<MessageSet> messageSetOption, String functionName) {
            boolean isIssueLinkTypesSpecified;
            Map<String, Long> issueLinkTypeNameToIds = Builder.issueLinkTypesIdMap(f.issueLinkTypeManager);
            Mode mode = Mode.SUBTRACTIVE;
            Collection<Long> effectiveIssueLinkTypes = issueLinkTypeNameToIds.values();
            if (this.issueLinkTypeModes.size() == 1) {
                mode = this.issueLinkTypeModes.get(0);
                switch (mode.ordinal()) {
                    case 0: {
                        effectiveIssueLinkTypes = new ArrayList<Long>();
                        break;
                    }
                    case 1: {
                        effectiveIssueLinkTypes = issueLinkTypeNameToIds.values();
                    }
                }
            } else if (this.issueLinkTypeModes.size() > 1) {
                MessageSet.addMessageTo(messageSetOption, VTE7JqlFunctionParameterAtMostOnce.message(f.i18nResolverAdapterOption, functionName, RelationsParameters.ISSUE_LINK_TYPE_PARAMETER_NAME));
                return effectiveIssueLinkTypes;
            }
            ArrayList<Long> issueLinkTypeIds = new ArrayList<Long>();
            boolean hasAmbiguityErrors = false;
            ArrayList<String> unknowns = new ArrayList<String>();
            Multimap<String, Long> issueLinkTypeMap = Builder.issueLinkTypesIdentifierMap(f.issueLinkTypeManager);
            for (String string : this.issueLinkTypes) {
                IssueLinkType issueLinkType;
                Long issueLinkTypeId = Primitives.asLong(string);
                if (issueLinkTypeId != null && (issueLinkType = f.issueLinkTypeManager.getIssueLinkType(issueLinkTypeId)) != null) {
                    issueLinkTypeIds.add(issueLinkType.getId());
                    continue;
                }
                String ilt = string.toLowerCase();
                if (issueLinkTypeMap.containsKey(ilt)) {
                    TreeSet<Long> issueLinkTypeInterpretations = new TreeSet<Long>();
                    for (Long v : issueLinkTypeMap.get(ilt).get()) {
                        issueLinkTypeInterpretations.add(v);
                    }
                    if (issueLinkTypeInterpretations.isEmpty()) {
                        MessageSet.addMessageTo(messageSetOption, VTE19InternalError.message(f.i18nResolverAdapterOption, "Unexpected condition: Issue link type \"" + ilt + "\" key doesn't map to any values."));
                        return Collections.emptyList();
                    }
                    if (issueLinkTypeInterpretations.size() == 1) {
                        issueLinkTypeIds.add((Long)issueLinkTypeInterpretations.iterator().next());
                        continue;
                    }
                    hasAmbiguityErrors = true;
                    Set<String> ambiguities = issueLinkTypeInterpretations.stream().map(id -> "\"" + f.issueLinkTypeManager.getIssueLinkType(id).getName() + "\" (ID " + id + ")").collect(Collectors.toSet());
                    MessageSet.addMessageTo(messageSetOption, VTE8JqlFunctionIssueLinkTypeAmbiguous.message(f.i18nResolverAdapterOption, functionName, string, ambiguities));
                    continue;
                }
                unknowns.add(string);
            }
            if (hasAmbiguityErrors) {
                return effectiveIssueLinkTypes;
            }
            if (!unknowns.isEmpty()) {
                MessageSet.addMessageTo(messageSetOption, VTE1JqlFunctionParameterValuesNotFound.message(f.i18nResolverAdapterOption, functionName, I18n.getText(f.i18nResolverAdapterOption, "vivid.trace.phrase.issue-link-types", new Serializable[0]), unknowns));
                return effectiveIssueLinkTypes;
            }
            HashSet distinct = new HashSet(issueLinkTypeIds);
            block10: for (Long i : distinct) {
                switch (mode.ordinal()) {
                    case 1: {
                        effectiveIssueLinkTypes.remove(i);
                        continue block10;
                    }
                    case 0: {
                        effectiveIssueLinkTypes.add(i);
                        continue block10;
                    }
                }
                MessageSet.addMessageTo(messageSetOption, VTE19InternalError.message(f.i18nResolverAdapterOption, "Unknown mode found while calculating effective issue link types: '" + String.valueOf((Object)mode) + "'"));
            }
            boolean bl = effectiveDirections.contains((Object)Direction.INWARD_ISSUE_LINKS) || effectiveDirections.contains((Object)Direction.OUTWARD_ISSUE_LINKS);
            boolean bl2 = isIssueLinkTypesSpecified = !this.issueLinkTypeModes.isEmpty() || !this.issueLinkTypes.isEmpty();
            if (isIssueLinkTypesSpecified && !bl && !effectiveIssueLinkTypes.isEmpty()) {
                MessageSet.addMessageTo(messageSetOption, VTW5JqlFunctionIssueLinkTypesWithoutDirection.message(f.i18nResolverAdapterOption, functionName, effectiveDirections));
            }
            if (bl && effectiveIssueLinkTypes.isEmpty()) {
                MessageSet.addMessageTo(messageSetOption, VTW16NoEffectiveIssueLinkTypes.message(f.i18nResolverAdapterOption, functionName, effectiveDirections));
            }
            return effectiveIssueLinkTypes;
        }

        static Iterable<Issue> validateIssueLiterals(Collection<String> issuesKeysOrIDs, ApplicationUser searcher, Option<MessageSet> messageSetOption, Factory f, String functionName) {
            ArrayList<Issue> v = new ArrayList<Issue>();
            ArrayList<String> inError = new ArrayList<String>();
            for (String i : issuesKeysOrIDs) {
                Issue issue = Jira.issueForArg(i, searcher, false, f.jqlIssueSupport);
                if (issue != null) {
                    v.add(issue);
                    continue;
                }
                inError.add(i);
            }
            if (!inError.isEmpty()) {
                MessageSet.addMessageTo(messageSetOption, VTE1JqlFunctionParameterValuesNotFound.message(f.i18nResolverAdapterOption, functionName, I18n.getText(f.i18nResolverAdapterOption, "vivid.trace.phrase.issues", new Serializable[0]), inError));
            }
            return v;
        }

        private static Iterable<Issue> validateJqlQueries(Collection<String> jqlQueries, ApplicationUser searcher, Option<MessageSet> messageSetOption, String functionName, Factory f) {
            ArrayList<Issue> c = new ArrayList<Issue>();
            for (String jqlQuery : jqlQueries) {
                Collection<Issue> issues = Builder.validateJqlQuery(searcher, messageSetOption, functionName, f, jqlQuery);
                c.addAll(issues);
            }
            return c;
        }

        private static Collection<Issue> validateJqlQuery(ApplicationUser searcher, Option<MessageSet> messageSetOption, String functionName, Factory f, String jqlQuery) {
            SearchService.ParseResult parseResult = f.searchService.parseQuery(searcher, jqlQuery);
            com.atlassian.jira.util.MessageSet parseResultErrors = parseResult.getErrors();
            if (parseResultErrors != null && parseResultErrors.hasAnyErrors() && messageSetOption.isDefined()) {
                Builder.addJiraValidationMessagesToMessageSet(messageSetOption, functionName, f, jqlQuery, parseResultErrors);
                return Collections.emptyList();
            }
            com.atlassian.jira.util.MessageSet validateResult = f.searchService.validateQuery(searcher, parseResult.getQuery());
            if (validateResult != null && validateResult.hasAnyMessages() && messageSetOption.isDefined()) {
                Builder.addJiraValidationMessagesToMessageSet(messageSetOption, functionName, f, jqlQuery, validateResult);
                if (validateResult.hasAnyErrors()) {
                    return Collections.emptyList();
                }
            }
            try {
                List<Issue> issues = Jira.searchIssueResults(f.searchService, searcher, parseResult.getQuery());
                if (issues != null) {
                    return issues;
                }
                MessageSet.addMessageTo(messageSetOption, VTE19InternalError.message(f.i18nResolverAdapterOption, "Unhandled condition: Was expecting search results to return issues, but received null instead."));
                return Collections.emptyList();
            }
            catch (SearchException e) {
                MessageSet.addMessageTo(messageSetOption, VTE12JqlFunctionCouldNotGetSearchResults.message(f.i18nResolverAdapterOption, functionName, I18n.getText(f.i18nResolverAdapterOption, "vivid.trace.phrase.jql-query", new Serializable[]{jqlQuery}), e.getLocalizedMessage()));
                return Collections.emptyList();
            }
        }

        private static void addJiraValidationMessagesToMessageSet(Option<MessageSet> messageSetOption, String functionName, Factory f, String jqlQuery, com.atlassian.jira.util.MessageSet jiraMessageSet) {
            for (String error : jiraMessageSet.getErrorMessages()) {
                MessageSet.addMessageTo(messageSetOption, VTE6JqlFunctionJqlQueryError.message(f.i18nResolverAdapterOption, functionName, jqlQuery, error));
            }
            for (String warning : jiraMessageSet.getWarningMessages()) {
                MessageSet.addMessageTo(messageSetOption, VTW11JqlFunctionJqlQueryWarning.message(f.i18nResolverAdapterOption, functionName, jqlQuery, warning));
            }
        }

        private boolean validateProjectConfig(Option<MessageSet> messageSetOption, String functionName, Factory f) {
            if (this.projectConfigDeprecatedFlag) {
                MessageSet.addMessageTo(messageSetOption, VTW19JqlFunctionParameterDeprecated.message(f.i18nResolverAdapterOption, functionName, RelationsParameters.PROJECT_CONFIG_PARAMETER_NAME, "Project configurations were not applied to this search. Please use a trace configuration as the basis of your search."));
            }
            return this.projectConfigDeprecatedFlag;
        }

        private Iterable<Issue> validateSeedIssues(ApplicationUser searcher, Option<MessageSet> messageSetOption, Factory f, String functionName) {
            return Stream.concat(Builder.validateIssueLiterals(this.issueLiterals, searcher, messageSetOption, f, functionName), Builder.validateJqlQueries(this.jqlQueries, searcher, messageSetOption, functionName, f));
        }
    }

    public static enum Mode {
        ADDITIVE,
        SUBTRACTIVE;

    }
}

