/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.license;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicensedApplications;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import io.vavr.collection.HashSet;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import vivid.lib.I18n;
import vivid.lib.messages.Message;
import vivid.lib.messages.MessageFormat;
import vivid.lib.messages.MessageSet;
import vivid.lib.messages.MessageType;
import vivid.lib.messages.VTE17LicenseInvalid;
import vivid.license.LicenseType;
import vivid.license.Licensing;
import vivid.trace.components.AddOnConfiguration;
import vivid.trace.components.Factory;
import vivid.trace.components.Providers;
import vivid.trace.jira.lib.Jira;
import vivid.trace.license.AtlassianMarketplaceLicense;
import vivid.trace.license.License;
import vivid.trace.license.VividIssuedLicense;

@Named
public class AddOnLicensing {
    public static final String LICENSE_KEY = "license";
    private final AddOnConfiguration addOnConfiguration;
    private final ApplicationProperties applicationProperties;
    private final Factory f;
    private final JiraLicenseService jiraLicenseService;
    private final PluginLicenseManager pluginLicenseManager;
    private static final HashSet<ApplicationKey> KNOWN_JIRA_APPLICATION_KEYS = HashSet.of(ApplicationKeys.CORE, ApplicationKeys.SERVICE_DESK, ApplicationKeys.SOFTWARE);
    public static final int UNLIMITED_USERS = Integer.MAX_VALUE;
    private static final String VIVID_ISSUED_LICENSE_SUPPLIER_KEY = "supplier";
    private static final String VIVID_ISSUED_LICENSE_ORGANIZATION_KEY = "organization";
    private static final String VIVID_ISSUED_LICENSE_PURCHASE_KEY = "purchase-date";
    private static final String VIVID_ISSUED_LICENSE_SUPPORT_ENTITLEMENT_NUMBER_KEY = "support-entitlement-number";
    private static final String VIVID_ISSUED_LICENSE_LICENSE_TYPE_KEY = "license-type";
    private static final String VIVID_ISSUED_LICENSE_RAW_LICENSE_KEY_KEY = "raw-license-key";
    private static final String VIVID_ISSUED_LICENSE_CHARACTERIZATION_KEY = "characterization";
    private static final String VIVID_ISSUED_LICENSE_STATUS_MESSAGES_KEY = "status-messages";
    private static final Providers.Provider<MyContext> LICENSE_DETAILS_PROVIDER = new Providers.Provider<MyContext>(){

        @Override
        public String getKey() {
            return AddOnLicensing.LICENSE_KEY;
        }

        @Override
        public void provideData(MyContext context, Map<String, Object> accumulator) {
            HashMap<String, Object> details = new HashMap<String, Object>();
            if (context.licenseOptional.isDefined() && context.licenseOptional.get() instanceof VividIssuedLicense) {
                Option<String> rawLicenseKeyOptional;
                Option<LicenseType> licenseType;
                VividIssuedLicense license = (VividIssuedLicense)context.licenseOptional.get();
                details.put(AddOnLicensing.VIVID_ISSUED_LICENSE_SUPPLIER_KEY, license.getIssuer(context.f.i18nResolverAdapterOption));
                details.put(AddOnLicensing.VIVID_ISSUED_LICENSE_ORGANIZATION_KEY, license.getOrganization());
                details.put(AddOnLicensing.VIVID_ISSUED_LICENSE_PURCHASE_KEY, Jira.formatDateForLoggedInUser(license.getIssueDate(), context.f.dateTimeFormatterFactory));
                Option<String> supportEntitlementNumber = license.getSupportEntitlementNumber();
                if (supportEntitlementNumber.isDefined()) {
                    details.put(AddOnLicensing.VIVID_ISSUED_LICENSE_SUPPORT_ENTITLEMENT_NUMBER_KEY, supportEntitlementNumber.get());
                }
                if ((licenseType = license.getLicenseType()).isDefined()) {
                    details.put(AddOnLicensing.VIVID_ISSUED_LICENSE_LICENSE_TYPE_KEY, (Object)licenseType.get());
                }
                if ((rawLicenseKeyOptional = license.getRawLicenseKeyOptional()).isDefined()) {
                    details.put(AddOnLicensing.VIVID_ISSUED_LICENSE_RAW_LICENSE_KEY_KEY, rawLicenseKeyOptional.get());
                }
                details.put(AddOnLicensing.VIVID_ISSUED_LICENSE_CHARACTERIZATION_KEY, AddOnLicensing.licenseCharacterization(context.f, license));
                details.put(AddOnLicensing.VIVID_ISSUED_LICENSE_STATUS_MESSAGES_KEY, license.getStatusMessages(context.f.i18nResolverAdapterOption, context.f.dateTimeFormatterFactory, context.f.addOnInformation).iterator());
            } else if (context.licenseOptional.isDefined()) {
                details.put(AddOnLicensing.VIVID_ISSUED_LICENSE_STATUS_MESSAGES_KEY, context.licenseOptional.get().getStatusMessages(context.f.i18nResolverAdapterOption, context.f.dateTimeFormatterFactory, context.f.addOnInformation).iterator());
            } else {
                details.put(AddOnLicensing.VIVID_ISSUED_LICENSE_STATUS_MESSAGES_KEY, MessageSet.of(Message.of(MessageType.INFO, I18n.getText(context.f.i18nResolverAdapterOption, "vivid.trace.add-on-licensing.details.status.unlicensed", new Serializable[0]))).iterator());
            }
            accumulator.put(AddOnLicensing.LICENSE_KEY, details);
        }
    };
    private static final Providers.Provider<MyContext> LICENSING_VALIDITY_MESSAGES = new Providers.Provider<MyContext>(){

        @Override
        public String getKey() {
            return "messages";
        }

        @Override
        public void provideData(MyContext context, Map<String, Object> accumulator) {
            MessageSet messages = new MessageSet();
            boolean isLicenseValid = context.licenseOptional.isDefined() && context.licenseOptional.get().isValid();
            messages.add(isLicenseValid ? new Message.MessageBuilder(MessageType.INFO, I18n.getText(context.f.i18nResolverAdapterOption, "vivid.trace.add-on-licensing.summary.valid", new Serializable[0])).build() : VTE17LicenseInvalid.message(context.f.i18nResolverAdapterOption, true, MessageFormat.PLAINTEXT, Option.none()));
            accumulator.put(this.getKey(), messages.iterator());
        }
    };
    private static final Providers<MyContext> PROVIDERS = new Providers(Arrays.asList(LICENSING_VALIDITY_MESSAGES, LICENSE_DETAILS_PROVIDER));

    @Inject
    public AddOnLicensing(AddOnConfiguration addOnConfiguration, @ComponentImport ApplicationProperties applicationProperties, Factory factory, @ComponentImport JiraLicenseService jiraLicenseService, @ComponentImport PluginLicenseManager pluginLicenseManager) {
        this.addOnConfiguration = addOnConfiguration;
        this.applicationProperties = applicationProperties;
        this.f = factory;
        this.jiraLicenseService = jiraLicenseService;
        this.pluginLicenseManager = Objects.requireNonNull(pluginLicenseManager);
    }

    public Option<License> getActiveLicense(Option<I18n.ResolverAdapter> i18nResolverAdapterOption) {
        Option<VividIssuedLicense> vividIssuedLicense = this.getVividIssuedLicense(i18nResolverAdapterOption);
        if (vividIssuedLicense.isDefined()) {
            return Option.of((License)vividIssuedLicense.get());
        }
        com.atlassian.upm.api.util.Option atlassianIssuedLicense = this.pluginLicenseManager.getLicense();
        if (atlassianIssuedLicense.isDefined()) {
            return Option.of(new AtlassianMarketplaceLicense(this.applicationProperties, (PluginLicense)atlassianIssuedLicense.get()));
        }
        return Option.none();
    }

    private Option<VividIssuedLicense> getVividIssuedLicense(Option<I18n.ResolverAdapter> i18nResolverAdapterOption) {
        Option<String> license = this.addOnConfiguration.getVividIssuedLicense();
        if (license.isDefined()) {
            String rawLicenseKey = license.get();
            return Option.of(VividIssuedLicense.fromRawLicenseKey(rawLicenseKey, this.jiraActiveUserTier(), i18nResolverAdapterOption, VividIssuedLicense.vividIssuedLicenseFactory).get());
        }
        return Option.none();
    }

    public boolean isAddOnLicenseValid(Option<I18n.ResolverAdapter> i18nResolverAdapterOption) {
        Option<License> licenseOptional = this.getActiveLicense(i18nResolverAdapterOption);
        return licenseOptional.isDefined() && licenseOptional.get().isValid();
    }

    public Option<Integer> jiraActiveUserTier() {
        Option<Integer> maxUserLimit = Option.none();
        for (LicenseDetails licenseDetails : this.jiraLicenseService.getLicenses()) {
            LicensedApplications licensedApplications = licenseDetails.getLicensedApplications();
            for (ApplicationKey applicationKey : licensedApplications.getKeys()) {
                if (!KNOWN_JIRA_APPLICATION_KEYS.contains(applicationKey)) continue;
                int userLimit = licensedApplications.getUserLimit(applicationKey);
                if (userLimit == -1) {
                    return Option.of(Integer.MAX_VALUE);
                }
                maxUserLimit = Option.of(Math.max(maxUserLimit.getOrElse(0), userLimit));
            }
        }
        return maxUserLimit;
    }

    public void removeVividIssuedLicense() {
        this.addOnConfiguration.removeVividIssuedLicense();
    }

    public Either<Message, VividIssuedLicense> setVividIssuedLicense(String rawLicenseKey, Option<I18n.ResolverAdapter> i18nResolverAdapterOptional) {
        Either<Message, VividIssuedLicense> license = VividIssuedLicense.fromRawLicenseKey(rawLicenseKey, this.jiraActiveUserTier(), i18nResolverAdapterOptional, VividIssuedLicense.vividIssuedLicenseFactory);
        if (license.isRight()) {
            this.addOnConfiguration.setVividIssuedLicense(Licensing.reformatRawLicenseKey(rawLicenseKey));
        }
        return license;
    }

    private static String licenseCharacterization(Factory f, VividIssuedLicense license) {
        Either<Message, Integer> jiraUserTier = license.getJiraUserTier(f.i18nResolverAdapterOption);
        if (jiraUserTier.isLeft()) {
            return "UNKNOWN LICENSE";
        }
        int users = jiraUserTier.get();
        String count = users == Integer.MAX_VALUE ? "Unlimited" : Integer.toString(users);
        Option<LicenseType> licenseType = license.getLicenseType();
        String type = I18n.getText(f.i18nResolverAdapterOption, licenseType.getOrElse((LicenseType)LicenseType.COMMERCIAL).i18nKey, new Serializable[0]);
        return I18n.getText(f.i18nResolverAdapterOption, "vivid.trace.add-on-licensing.details.type", new Serializable[]{count, type});
    }

    public Map<String, Object> licensingStatus(List<String> keys) {
        MyContext context = new MyContext(this.f, this.getActiveLicense(this.f.i18nResolverAdapterOption));
        return PROVIDERS.fulfill(keys, context);
    }

    private static class MyContext {
        private final Factory f;
        private final Option<License> licenseOptional;

        private MyContext(Factory factory, Option<License> licenseOptional) {
            this.f = factory;
            this.licenseOptional = licenseOptional;
        }
    }
}

