/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.license;

import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.upm.api.license.entity.PluginLicense;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import vivid.lib.I18n;
import vivid.lib.Strings;
import vivid.lib.messages.Message;
import vivid.lib.messages.MessageSet;
import vivid.lib.messages.MessageType;
import vivid.license.LicenseType;
import vivid.trace.components.AddOnInformation;
import vivid.trace.jira.lib.Jira;
import vivid.trace.license.License;

public class AtlassianMarketplaceLicense
implements License {
    private final ApplicationProperties applicationProperties;
    private final PluginLicense license;
    private static final Map<com.atlassian.upm.api.license.entity.LicenseType, LicenseType> BY_ATLASSIAN_LICENSE_TYPE = HashMap.of(com.atlassian.upm.api.license.entity.LicenseType.ACADEMIC, LicenseType.ACADEMIC, com.atlassian.upm.api.license.entity.LicenseType.COMMERCIAL, LicenseType.COMMERCIAL, com.atlassian.upm.api.license.entity.LicenseType.DEMONSTRATION, LicenseType.DEMONSTRATION, com.atlassian.upm.api.license.entity.LicenseType.NON_PROFIT, LicenseType.NON_PROFIT, com.atlassian.upm.api.license.entity.LicenseType.OPEN_SOURCE, LicenseType.OPEN_SOURCE, com.atlassian.upm.api.license.entity.LicenseType.TESTING, LicenseType.TRIAL);

    AtlassianMarketplaceLicense(ApplicationProperties applicationProperties, PluginLicense license) {
        this.applicationProperties = applicationProperties;
        this.license = license;
    }

    @Override
    public Option<LicenseType> getLicenseType() {
        return BY_ATLASSIAN_LICENSE_TYPE.get(this.license.getLicenseType()).orElse(Option.of(LicenseType.COMMERCIAL));
    }

    @Override
    public Option<DateTime> getMaintenanceExpiryDate() {
        Optional zdt = this.license.getMaintenanceExpiryZonedDate();
        return zdt.map(zonedDateTime -> Option.of(new DateTime(zonedDateTime.toInstant().toEpochMilli(), DateTimeZone.forID(zonedDateTime.getOffset().getId())))).orElseGet(Option::none);
    }

    @Override
    public String getOrganization() {
        return this.license.getOrganization().getName();
    }

    @Override
    public DateTime getIssueDate() {
        ZonedDateTime zdt = this.license.getPurchaseZonedDate();
        return new DateTime(zdt.toInstant().toEpochMilli(), DateTimeZone.forID(zdt.getOffset().getId()));
    }

    @Override
    public MessageSet getStatusMessages(Option<I18n.ResolverAdapter> i18nResolverAdapterOptional, DateTimeFormatterFactory dateTimeFormatterFactory, AddOnInformation addOnInformation) {
        return MessageSet.of((this.isValid() ? new Message.MessageBuilder(MessageType.INFO, I18n.getText(i18nResolverAdapterOptional, "vivid.phrase.valid", new Serializable[0])) : new Message.MessageBuilder(MessageType.ERROR, I18n.getText(i18nResolverAdapterOptional, "vivid.phrase.invalid", new Serializable[0]))).addDetail("supplementary-message", I18n.getText(i18nResolverAdapterOptional, "vivid.trace.add-on-licensing.summary.valid-atlassian-marketplace-issued.html", new Serializable[]{I18n.getText(i18nResolverAdapterOptional, "vivid.phrase.upm", new Serializable[0]), Strings.htmlA(Jira.upmUrl(this.applicationProperties, "vivid.trace")), "</a>"})).build());
    }

    @Override
    public String getIssuer(Option<I18n.ResolverAdapter> i18nResolverAdapterOptional) {
        return I18n.getText(i18nResolverAdapterOptional, "vivid.trace.phrase.atlassian-marketplace", new Serializable[0]);
    }

    @Override
    public Option<String> getRawLicenseKeyOptional() {
        return Option.none();
    }

    @Override
    public Option<String> getSupportEntitlementNumber() {
        return this.toOptional(this.license.getSupportEntitlementNumber());
    }

    @Override
    public boolean isValid() {
        return this.license.isValid();
    }

    private <T> Option<T> toOptional(com.atlassian.upm.api.util.Option<T> fromOption) {
        return fromOption.isDefined() ? Option.of(fromOption.get()) : Option.none();
    }
}

