/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.onboarding;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vivid.lib.Strings;
import vivid.trace.ao.TraceConfigurationAO;
import vivid.trace.components.AbstractPluginLifecycle;
import vivid.trace.components.Favorites;
import vivid.trace.data.ContextualTraceConfigurationQuickList;
import vivid.trace.datatypes.ObjectKeyValue;
import vivid.trace.datatypes.TraceConfigurations;

@ExportAsService(value={LifecycleAware.class})
@Named
public class BundledTraceConfigurations
extends AbstractPluginLifecycle {
    private static final Logger log = LoggerFactory.getLogger(BundledTraceConfigurations.class);
    private static final String BUNDLED_TRACE_CONFIGURATION_IDS_KEY = "bundled-trace-configuration-ids";
    private final ActiveObjects activeObjects;
    private final ContextualTraceConfigurationQuickList contextualTraceConfigurationQuickList;
    private final Favorites favorites;
    private final TraceConfigurations traceConfigurations;
    private static final TC[] BUNDLED_TRACE_CONFIGURATION = new TC[]{new TC("My open issues", "{\"distance\":\"3\",\"itemCardLayout\":\"[ {:id \\\":jira.issue-field.system/issue-type\\\" :x 0 :y 0 :w 1 :h 1} {:id \\\":jira.issue-field.system/key\\\" :x 1 :y 0 :w 4 :h 1} {:id \\\":jira.issue-field.system/fix-versions\\\" :x 7 :y 2 :w 8 :h 1} {:id \\\":jira.issue-field.system/due-date\\\" :x 7 :y 3 :w 4 :h 1} {:id \\\":jira.issue-field.system/priority\\\" :x 0 :y 1 :w 1 :h 1} {:id \\\":jira.issue-field.system/summary\\\" :x 1 :y 1 :w 14 :h 1} {:id \\\":jira.issue-field.system/assignee\\\" :x 0 :y 2 :w 7 :h 1} {:id \\\":jira.issue-field.system/status\\\" :x 5 :y 0 :w 6 :h 1} {:id \\\":jira.issue-field.system/resolution\\\" :x 11 :y 0 :w 4 :h 1} {:id \\\":jira.issue-field.system/reporter\\\" :x 0 :y 3 :w 7 :h 1} {:id \\\":jira.issue-field.system/watches\\\" :x 11 :y 3 :w 2 :h 1} {:id \\\":jira.issue-field.system/votes\\\" :x 13 :y 3 :w 2 :h 1}]\",\"relationsSeedIssuesArg\":\"assignee = currentUser() AND resolution IS EMPTY\"}"), new TC("My reported issues", "{\"distance\":\"3\",\"itemCardLayout\":\"[ {:id \\\":jira.issue-field.system/issue-type\\\" :x 0 :y 0 :w 1 :h 1} {:id \\\":jira.issue-field.system/key\\\" :x 1 :y 0 :w 4 :h 1} {:id \\\":jira.issue-field.system/fix-versions\\\" :x 7 :y 2 :w 8 :h 1} {:id \\\":jira.issue-field.system/due-date\\\" :x 7 :y 3 :w 4 :h 1} {:id \\\":jira.issue-field.system/priority\\\" :x 0 :y 1 :w 1 :h 1} {:id \\\":jira.issue-field.system/summary\\\" :x 1 :y 1 :w 14 :h 1} {:id \\\":jira.issue-field.system/assignee\\\" :x 0 :y 2 :w 7 :h 1} {:id \\\":jira.issue-field.system/status\\\" :x 5 :y 0 :w 6 :h 1} {:id \\\":jira.issue-field.system/resolution\\\" :x 11 :y 0 :w 4 :h 1} {:id \\\":jira.issue-field.system/reporter\\\" :x 0 :y 3 :w 7 :h 1} {:id \\\":jira.issue-field.system/watches\\\" :x 11 :y 3 :w 2 :h 1} {:id \\\":jira.issue-field.system/votes\\\" :x 13 :y 3 :w 2 :h 1}]\",\"relationsSeedIssuesArg\":\"reporter = currentUser() AND resolution IS EMPTY\"}"), new TC("Recently updated", "{\"distance\":\"2\",\"itemCardLayout\":\"[ {:id \\\":jira.issue-field.system/issue-type\\\" :x 0 :y 0 :w 1 :h 1} {:id \\\":jira.issue-field.system/key\\\" :x 1 :y 0 :w 14 :h 1} {:id \\\":jira.issue-field.system/priority\\\" :x 0 :y 1 :w 1 :h 1} {:id \\\":jira.issue-field.system/summary\\\" :x 1 :y 1 :w 14 :h 2}]\",\"relationsSeedIssuesArg\":\"updated >= -1w\"}"), new TC("Recently viewed", "{\"distance\":\"2\",\"itemCardLayout\":\"[ {:id \\\":jira.issue-field.system/issue-type\\\" :x 0 :y 0 :w 1 :h 1} {:id \\\":jira.issue-field.system/key\\\" :x 1 :y 0 :w 14 :h 1} {:id \\\":jira.issue-field.system/priority\\\" :x 0 :y 1 :w 1 :h 1} {:id \\\":jira.issue-field.system/summary\\\" :x 1 :y 1 :w 14 :h 2}]\",\"relationsSeedIssuesArg\":\"issueKey in issueHistory()\"}")};
    private static final TC[] BUNDLED_TRACE_CONFIGURATION_QUICK_LIST = new TC[]{new TC("System default", "{\"distance\":3,\"itemCardLayout\":\"[ {:id \\\":jira.issue-field.system/issue-type\\\" :x 0 :y 0 :w 1 :h 1} {:id \\\":jira.issue-field.system/key\\\" :x 1 :y 0 :w 4 :h 1} {:id \\\":jira.issue-field.system/status\\\" :x 5 :y 0 :w 6 :h 1} {:id \\\":jira.issue-field.system/priority\\\" :x 0 :y 1 :w 1 :h 1} {:id \\\":jira.issue-field.system/summary\\\" :x 1 :y 1 :w 10 :h 2}]\"}")};
    private static final ObjectKeyValue.CompositeKey BUNDLED_TRACE_CONFIGURATION_IDS_COMPOSITE_KEY = new ObjectKeyValue.CompositeKey(){

        @Override
        public String getObjectType() {
            return "addon";
        }

        @Override
        public String getObjectId() {
            return "0";
        }

        @Override
        public String getKey() {
            return BundledTraceConfigurations.BUNDLED_TRACE_CONFIGURATION_IDS_KEY;
        }
    };
    private static final String FLAG = "flag-favorite-bundled-trace-configurations";
    private static final String FLAG_SET_VALUE = "true";

    @Inject
    BundledTraceConfigurations(@ComponentImport ActiveObjects activeObjects, @ComponentImport EventPublisher eventPublisher, ContextualTraceConfigurationQuickList contextualTraceConfigurationQuickList, Favorites favorites, TraceConfigurations traceConfigurations) {
        super(eventPublisher);
        this.activeObjects = activeObjects;
        this.contextualTraceConfigurationQuickList = contextualTraceConfigurationQuickList;
        this.favorites = favorites;
        this.traceConfigurations = traceConfigurations;
    }

    private List<String> createBundledTraceConfigurations(TC[] tcs) {
        ArrayList<String> ids = new ArrayList<String>();
        try {
            for (TC tc : tcs) {
                TraceConfigurationAO entity = this.traceConfigurations.createBundledTraceConfiguration(tc.configuration, tc.name);
                ids.add(Integer.toString(entity.getID()));
            }
        }
        catch (Exception e) {
            log.error("Could not create bundled trace configurations", (Throwable)e);
        }
        return ids;
    }

    public void favoriteBundledTraceConfigurations(ApplicationUser user) {
        try {
            if (this.isFavoritingComplete(user)) {
                return;
            }
            Option<Set<String>> idsOption = this.bundledTraceConfigurationIds();
            if (idsOption.isEmpty()) {
                log.debug("Attempting to favorite the bundled trace configurations for user '{}', but no trace configuration IDs were found.", (Object)user.getKey());
                return;
            }
            for (String id : idsOption.get()) {
                this.favorites.favoriteTraceConfiguration(Integer.parseInt(id), user);
            }
            this.setFavoritingComplete(user);
        }
        catch (Exception e) {
            log.debug("Encountered an exception while favoriting the bundled trace configurations for user '" + user.getKey() + "'", (Throwable)e);
        }
    }

    @Override
    protected void start() {
        List<String> ids;
        if (this.bundledTraceConfigurationIds().isEmpty()) {
            ids = this.createBundledTraceConfigurations(BUNDLED_TRACE_CONFIGURATION);
            this.setBundledTraceConfigurationIds(ids);
        }
        if (this.contextualTraceConfigurationQuickList.getAddonRawValue().isEmpty()) {
            ids = this.createBundledTraceConfigurations(BUNDLED_TRACE_CONFIGURATION_QUICK_LIST);
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (String id : ids) {
                sb.append("{:id ");
                sb.append(id);
                sb.append(" :contextual-seed-issues-query-mode :override");
                sb.append(ids.get(0).equals(id) ? " :default true}" : "}");
            }
            sb.append("]");
            this.contextualTraceConfigurationQuickList.setAddonValue(sb.toString());
        }
    }

    private Option<Set<String>> bundledTraceConfigurationIds() {
        Option<String> value = ObjectKeyValue.getValue(this.activeObjects, BUNDLED_TRACE_CONFIGURATION_IDS_COMPOSITE_KEY);
        return value.isDefined() ? Option.of(Strings.readFromCsvString(value.get())) : Option.none();
    }

    private void setBundledTraceConfigurationIds(List<String> bundledTraceConfigurationIds) {
        String ids = Strings.writeToCsvString(bundledTraceConfigurationIds);
        ObjectKeyValue.updateOrCreate(this.activeObjects, BUNDLED_TRACE_CONFIGURATION_IDS_COMPOSITE_KEY, ids);
    }

    private static ObjectKeyValue.CompositeKey favoriteBundledTraceConfigurationsCompositeKey(final ApplicationUser user) {
        return new ObjectKeyValue.CompositeKey(){

            @Override
            public String getObjectType() {
                return "user";
            }

            @Override
            public String getObjectId() {
                return user.getKey();
            }

            @Override
            public String getKey() {
                return BundledTraceConfigurations.FLAG;
            }
        };
    }

    private boolean isFavoritingComplete(ApplicationUser user) {
        Option<String> value = ObjectKeyValue.getValue(this.activeObjects, BundledTraceConfigurations.favoriteBundledTraceConfigurationsCompositeKey(user));
        return value.isDefined();
    }

    private void setFavoritingComplete(ApplicationUser user) {
        ObjectKeyValue.updateOrCreate(this.activeObjects, BundledTraceConfigurations.favoriteBundledTraceConfigurationsCompositeKey(user), FLAG_SET_VALUE);
    }

    private static class TC {
        final String name;
        final String configuration;

        private TC(String name, String configuration) {
            this.name = name;
            this.configuration = configuration;
        }
    }
}

