/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.Lazy;
import io.vavr.collection.GwtIncompatible;
import java.math.BigDecimal;
import java.math.RoundingMode;

final class BigDecimalHelper {
    @GwtIncompatible(value="Math::nextDown is not implemented")
    private static final Lazy<BigDecimal> INFINITY_DISTANCE = Lazy.of(() -> {
        BigDecimal supremum;
        BigDecimal two = BigDecimal.valueOf(2L);
        BigDecimal lowerBound = supremum = BigDecimal.valueOf(Math.nextDown(Double.POSITIVE_INFINITY));
        BigDecimal upperBound = two.pow(1024);
        while (true) {
            BigDecimal magicValue;
            if (Double.isInfinite((magicValue = lowerBound.add(upperBound).divide(two, RoundingMode.HALF_UP)).doubleValue())) {
                if (BigDecimalHelper.areEqual(magicValue, upperBound)) {
                    return magicValue.subtract(supremum);
                }
                upperBound = magicValue;
                continue;
            }
            lowerBound = magicValue;
        }
    });

    BigDecimalHelper() {
    }

    static boolean areEqual(BigDecimal from, BigDecimal toExclusive) {
        return from.compareTo(toExclusive) == 0;
    }

    @GwtIncompatible(value="Math::nextUp is not implemented")
    static BigDecimal asDecimal(double number) {
        if (number == Double.NEGATIVE_INFINITY) {
            BigDecimal result = BigDecimal.valueOf(Math.nextUp(Double.NEGATIVE_INFINITY));
            return result.subtract(INFINITY_DISTANCE.get());
        }
        if (number == Double.POSITIVE_INFINITY) {
            BigDecimal result = BigDecimal.valueOf(Math.nextDown(Double.POSITIVE_INFINITY));
            return result.add(INFINITY_DISTANCE.get());
        }
        return BigDecimal.valueOf(number);
    }
}

