/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.collection.Iterator;
import java.util.NoSuchElementException;

final class ConcatIterator<T>
implements Iterator<T> {
    private Iterators<T> curr;
    private Iterators<T> last;
    private boolean nextCalculated = false;

    ConcatIterator(java.util.Iterator<? extends java.util.Iterator<? extends T>> iterators) {
        this.last = iterators.hasNext() ? new Iterators<T>(iterators.next()) : null;
        this.curr = this.last;
        while (iterators.hasNext()) {
            this.last = ((Iterators)this.last).tail = (Iterators)new Iterators<T>(iterators.next());
        }
    }

    @Override
    public boolean hasNext() {
        if (this.nextCalculated) {
            return this.curr != null;
        }
        this.nextCalculated = true;
        do {
            if (((Iterators)this.curr).head.hasNext()) {
                return true;
            }
            this.curr = ((Iterators)this.curr).tail;
        } while (this.curr != null);
        this.last = null;
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.nextCalculated = false;
        return (T)((Iterators)this.curr).head.next();
    }

    @Override
    public Iterator<T> concat(java.util.Iterator<? extends T> that) {
        if (this.curr == null) {
            this.nextCalculated = false;
            this.last = new Iterators<T>(that);
            this.curr = this.last;
        } else {
            this.last = ((Iterators)this.last).tail = (Iterators)new Iterators<T>(that);
        }
        return this;
    }

    @Override
    public String toString() {
        return "ConcatIterator";
    }

    private static final class Iterators<T> {
        private final java.util.Iterator<T> head;
        private Iterators<T> tail;

        Iterators(java.util.Iterator<? extends T> head) {
            this.head = head;
        }
    }
}

