/*
 * Decompiled with CFR 0.152.
 */
package vivid.lib;

import io.vavr.control.Either;
import io.vavr.control.Option;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import vivid.lib.I18n;
import vivid.lib.ResponseAdapter;
import vivid.lib.Strings;
import vivid.lib.messages.Message;
import vivid.lib.messages.VTE27MalformedRequest;

public class Primitives {
    public static final String TRUE_VALUE = "true";
    public static final String FALSE_VALUE = "false";

    private Primitives() {
    }

    public static Option<Integer> asInteger(String s) {
        try {
            return Option.of(Integer.valueOf(s));
        }
        catch (NumberFormatException e) {
            return Option.none();
        }
    }

    public static Either<Message, Integer> asIntegerOrMessage(String parameterName, Object parameterValue, Option<I18n.ResolverAdapter> i18nResolverAdapterOptional) {
        Option maybeId;
        Option<Object> option = maybeId = parameterValue instanceof String ? Primitives.asInteger((String)parameterValue) : Option.none();
        if (!maybeId.isDefined()) {
            return Either.left(VTE27MalformedRequest.message(i18nResolverAdapterOptional, "Could not interpret " + parameterName + " parameter value ``" + parameterValue + "'' as an integer."));
        }
        return Either.right((Integer)maybeId.get());
    }

    public static <T, R> Either<R, T> asTOrResponse(ResponseAdapter<R> responseAdapter, Either<Message, T> asTOrMessage) {
        if (asTOrMessage.isLeft()) {
            return Either.left(responseAdapter.responseWithMessage(Response.Status.BAD_REQUEST, asTOrMessage.getLeft()));
        }
        return Either.right(asTOrMessage.get());
    }

    public static Either<Message, String> asNonEmptyStringOrMessage(String parameterKey, Object parameterValue, Option<I18n.ResolverAdapter> i18nResolverAdapterOptional) {
        if (!(parameterValue instanceof String) || Strings.isBlank((String)parameterValue)) {
            return Either.left(VTE27MalformedRequest.message(i18nResolverAdapterOptional, "Could not interpret " + parameterKey + " parameter value ``" + parameterValue + "'' as a non-empty string."));
        }
        return Either.right((String)parameterValue);
    }

    public static Long asLong(String s) {
        try {
            return Long.valueOf(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Set<Long> asLongs(Set<String> numbers) {
        HashSet<Long> longs = new HashSet<Long>(numbers.size());
        for (String str : numbers) {
            try {
                longs.add(Long.valueOf(str));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return longs;
    }

    public static <T> T coalesce(T a, T b) {
        return a != null ? a : b;
    }

    public static <T> T coerciveGet(Map<String, ?> map, String key) {
        return (T)map.get(key);
    }

    public static <T extends Enum<T>> EnumSet<T> copyOfEnumSet(Class<T> clazz, Collection<T> coll) {
        return coll == null || coll.isEmpty() ? EnumSet.noneOf(clazz) : EnumSet.copyOf(coll);
    }
}

