/*
 * Decompiled with CFR 0.152.
 */
package vivid.lib;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;

public class Strings {
    public static final String UTF_8_ENCODING = "UTF-8";
    private static final String CSV_SEPARATOR = ",";
    private static final String EMPTY_MARKER = "__EMPTY__";
    public static final String HTML_BLANK_TARGET = "_blank";
    public static final String HTML_SLASH_A = "</a>";

    private Strings() {
    }

    public static boolean stringEq(String a, String b) {
        return Objects.equals(a, b);
    }

    public static boolean isBlank(String s) {
        return s == null || s.trim().length() <= 0;
    }

    public static boolean isQuoted(String s, char quote) {
        return s != null && s.length() > 2 && s.charAt(0) == quote && s.charAt(s.length() - 1) == quote;
    }

    public static String unquoted(String s) {
        return Strings.isQuoted(s, '\'') || Strings.isQuoted(s, '\"') ? s.substring(1, s.length() - 1).trim() : s;
    }

    public static Set<String> readFromCsvString(String csvString) {
        HashSet<String> entries = new HashSet<String>();
        if (EMPTY_MARKER.equals(csvString)) {
            return entries;
        }
        StringTokenizer tokenizer = new StringTokenizer(csvString, CSV_SEPARATOR);
        while (tokenizer.hasMoreTokens()) {
            String entry = tokenizer.nextToken();
            entries.add(entry);
        }
        return entries;
    }

    public static String writeToCsvString(Collection<String> entries) {
        String s = String.join((CharSequence)CSV_SEPARATOR, entries);
        return s.length() >= 1 ? s : EMPTY_MARKER;
    }

    public static String htmlA(String href) {
        return "<a href=\"" + href + "\">";
    }

    public static String htmlA(String href, String target) {
        return "<a href=\"" + href + "\" target=\"" + target + "\">";
    }
}

