/*
 * Decompiled with CFR 0.152.
 */
package vivid.lib.atlassian;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.seraph.config.SecurityConfigFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.vavr.control.Option;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vivid.lib.Primitives;
import vivid.lib.Strings;
import vivid.lib.compatibility.Jackson;
import vivid.lib.messages.Message;
import vivid.lib.messages.MessageSet;

public class Servlets {
    private static final Logger log = LoggerFactory.getLogger(Servlets.class);

    private Servlets() {
    }

    public static void applyWebSudo(HttpServletRequest request, HttpServletResponse response, WebSudoManager webSudoManager) {
        try {
            webSudoManager.willExecuteWebSudoRequest(request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!webSudoManager.canExecuteRequest(request)) {
            webSudoManager.enforceWebSudoProtection(request, response);
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    public static Option<String> firstPathInfoElement(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            return Option.none();
        }
        Path paths = Paths.get(request.getPathInfo(), new String[0]);
        Iterator<Path> i = paths.iterator();
        return i.hasNext() ? Option.of(i.next().toString()) : Option.none();
    }

    private static String getForwardedServletPath(HttpServletRequest request) {
        String uri;
        Object uriObj = request.getAttribute("jakarta.servlet.forward.servlet_path");
        if (uriObj instanceof String && !Strings.isBlank(uri = (String)uriObj)) {
            return uri;
        }
        return null;
    }

    private static URI getUri(HttpServletRequest request) {
        StringBuilder builder = new StringBuilder();
        builder.append((CharSequence)Primitives.coalesce(Servlets.getForwardedServletPath(request), request.getRequestURL()));
        if (request.getQueryString() != null) {
            builder.append('?');
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private static void preventRedirectsLoop(HttpServletRequest request, String target) {
        String originalURLKey = SecurityConfigFactory.getInstance().getOriginalURLKey();
        request.getSession().setAttribute(originalURLKey, (Object)target);
    }

    @SuppressFBWarnings(value={"UNVALIDATED_REDIRECT"})
    public static void redirectToLogin(LoginUriProvider loginUriProvider, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String target = loginUriProvider.getLoginUri(Servlets.getUri(request)).toASCIIString();
        Servlets.preventRedirectsLoop(request, target);
        response.sendRedirect(target);
    }

    public static void renderMessagesToServletResponse(HttpServletResponse response, MessageSet messageSet) throws IOException {
        response.setContentType("application/json;charset=utf-8");
        Jackson.writeValue(response.getWriter(), messageSet);
    }

    @SuppressFBWarnings(value={"LO_TOSTRING_PARAMETER"})
    public static Void responseWithMessage(HttpServletResponse response, Response.Status status, Message message) {
        response.setStatus(status.getStatusCode());
        try {
            Servlets.renderMessagesToServletResponse(response, MessageSet.of(message));
        }
        catch (IOException e) {
            log.error("Encountered an exception while attempting to write message as servlet response: Message = {}. Exception = {}.", (Object)message, (Object)(e.getMessage() + "\n" + Arrays.toString(e.getStackTrace())));
        }
        return null;
    }
}

