/*
 * Decompiled with CFR 0.152.
 */
package vivid.lib.messages;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.vavr.control.Option;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import vivid.lib.messages.MessageType;
import vivid.lib.rest.MessageSerializer;

@JsonSerialize(using=MessageSerializer.class)
public class Message {
    private final Option<String> codeOption;
    private final Map<String, String> details;
    private final MessageType type;

    private Message(MessageBuilder builder) {
        this.type = builder.type;
        this.codeOption = builder.codeOption;
        this.details = Collections.unmodifiableMap(builder.details);
    }

    public static Message of(MessageType type, String message) {
        return new MessageBuilder(type, message).build();
    }

    public Option<String> getCodeOption() {
        return this.codeOption;
    }

    public Map<String, String> getDetails() {
        return this.details;
    }

    public String getMessage() {
        return this.details.get("message");
    }

    public MessageType getType() {
        return this.type;
    }

    public String toString() {
        return "vivid.lib.messages.Message{codeOption=" + this.codeOption + ", details=" + this.details + ", type=" + (Object)((Object)this.type) + '}';
    }

    public static class MessageBuilder {
        private final MessageType type;
        private Option<String> codeOption = Option.none();
        private final Map<String, String> details = new HashMap<String, String>();

        @SuppressFBWarnings(value={"STT_TOSTRING_STORED_IN_FIELD"})
        public MessageBuilder(MessageType type, String message) {
            this.type = type;
            this.details.put("type", type.toString());
            this.details.put("message", message);
        }

        public MessageBuilder addDetail(String detailKey, String detailValue) {
            this.details.put(detailKey, detailValue);
            return this;
        }

        public MessageBuilder addOptionalDetail(String detailKey, Option<String> detailOptionalValue) {
            if (detailOptionalValue.isDefined()) {
                this.details.put(detailKey, detailOptionalValue.get());
            }
            return this;
        }

        public MessageBuilder code(String code) {
            this.codeOption = Option.of(code);
            this.addDetail("code", code);
            return this;
        }

        public Message build() {
            return new Message(this);
        }
    }
}

