/*
 * Decompiled with CFR 0.152.
 */
package vivid.lib.messages;

import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import io.vavr.control.Option;
import java.io.Serializable;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import vivid.lib.I18n;
import vivid.lib.messages.CodedMessage;
import vivid.lib.messages.Message;
import vivid.trace.jira.lib.Jira;
import vivid.trace.license.VividIssuedLicense;

public class VTW14MaintenanceExpiration
extends CodedMessage {
    private static final VTW14MaintenanceExpiration M = new VTW14MaintenanceExpiration();

    private VTW14MaintenanceExpiration() {
    }

    public static Message message(Option<I18n.ResolverAdapter> i18nResolverAdapterOption, DateTime maintenanceExpiryDate, Variant variant, DateTimeFormatterFactory dateTimeFormatterFactory, VividIssuedLicense license) {
        String formattedMaintenanceExpiryDate = Jira.formatDateForLoggedInUser(maintenanceExpiryDate, dateTimeFormatterFactory);
        return new Message.MessageBuilder(M.getMessageType(), I18n.getText(i18nResolverAdapterOption, variant.i18nKey, new Serializable[]{formattedMaintenanceExpiryDate, String.valueOf(VTW14MaintenanceExpiration.daysFromNow(license, maintenanceExpiryDate))})).code(M.getMessageCode()).addDetail("supplementary-message", I18n.getText(i18nResolverAdapterOption, "vivid.trace.add-on-licensing.details.status.renew-maintenance", new Serializable[]{formattedMaintenanceExpiryDate})).build();
    }

    private static long daysFromNow(VividIssuedLicense license, DateTime pointInTime) {
        DateTime now = license.now();
        Interval interval = now.isBefore(pointInTime.toInstant()) ? new Interval((ReadableInstant)now, (ReadableInstant)pointInTime) : new Interval((ReadableInstant)pointInTime, (ReadableInstant)now);
        return interval.toDuration().getStandardDays();
    }

    public static enum Variant {
        NEARLY_EXPIRED("vivid.trace.warning.vtw-14-active-maintenance-nearly-expired"),
        RECENTLY_EXPIRED("vivid.trace.warning.vtw-14-maintenance-recently-expired"),
        EXPIRED("vivid.trace.warning.vtw-14-maintenance-expired");

        private final String i18nKey;

        private Variant(String i18nKey) {
            this.i18nKey = i18nKey;
        }
    }
}

