/*
 * Decompiled with CFR 0.152.
 */
package vivid.lib.rest;

import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import vivid.lib.messages.Message;
import vivid.lib.messages.VTE19InternalError;

public class Rest {
    public static final String HTTP_200_OK_DESCRIPTION_REPLYING_WITH_DATA = "Request succeeded: Replying with data";
    public static final String HTTP_200_OK_DESCRIPTION_CHANGES = "Request succeeded: Changes were effected idempotently";
    public static final String HTTP_204_NO_CONTENT_DESCRIPTION = "Request succeeded: Changes were effected idempotently";
    public static final String HTTP_400_BAD_REQUEST_DESCRIPTION = "Request could not be interpreted, contained invalid or unusable data, or product license is invalid, or some other condition";
    public static final String HTTP_401_UNAUTHORIZED_DESCRIPTION = "Authentication is required to proceed";
    public static final String HTTP_403_FORBIDDEN_DESCRIPTION = "Refusing access to requested resource, perhaps due to insufficient privilege (Caller is assumed to know that the resource might exist)";
    public static final String HTTP_404_NOT_FOUND_DESCRIPTION = "Requested resource was not found";
    public static final String HTTP_500_INTERNAL_ERROR = "Request failed due to an internal error";
    public static final String MESSAGES_KEY = "messages";
    private static final CacheControl NEVER_CACHE = new CacheControl();

    private Rest() {
    }

    public static Response responseWithEntity(Response.Status status, String mediaType, Object entity) {
        return Response.status((Response.Status)status).type(mediaType).entity(entity).cacheControl(NEVER_CACHE).build();
    }

    public static Response responseWithHTMLEntity(Response.Status status, Object entity) {
        return Response.status((Response.Status)status).type("text/html").entity(entity).cacheControl(NEVER_CACHE).build();
    }

    public static Response responseWithJSONEntity(Response.Status status, Object entity) {
        return Response.status((Response.Status)status).type("application/json").entity(entity).cacheControl(NEVER_CACHE).build();
    }

    public static Response responseWithTransitJSONEntity(Response.Status status, Object entity) {
        return Response.status((Response.Status)status).type("application/transit+json").entity(entity).cacheControl(NEVER_CACHE).build();
    }

    public static Response responseWithMessage(Response.Status status, Message message) {
        return Rest.responseWithMessage(status, Collections.singleton(message));
    }

    public static Response responseWithMessage(Response.Status status, Iterable<Message> messages) {
        return Rest.responseWithJSONEntity(status, Collections.singletonMap(MESSAGES_KEY, messages.iterator()));
    }

    public static Response responseWithNoContent() {
        return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(NEVER_CACHE).build();
    }

    public static Response toVTE19(Exception e) {
        return Rest.responseWithMessage(Response.Status.INTERNAL_SERVER_ERROR, VTE19InternalError.hardcodedMessage(e));
    }

    static {
        NEVER_CACHE.setNoStore(true);
        NEVER_CACHE.setNoCache(true);
    }
}

