/*
 * Decompiled with CFR 0.152.
 */
package vivid.shaded.org.msgpack.template;

import java.io.IOException;
import java.math.BigInteger;
import vivid.shaded.org.msgpack.MessageTypeException;
import vivid.shaded.org.msgpack.packer.Packer;
import vivid.shaded.org.msgpack.template.AbstractTemplate;
import vivid.shaded.org.msgpack.unpacker.Unpacker;

public class BigIntegerTemplate
extends AbstractTemplate<BigInteger> {
    static final BigIntegerTemplate instance = new BigIntegerTemplate();

    private BigIntegerTemplate() {
    }

    @Override
    public void write(Packer pk, BigInteger target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        pk.write(target);
    }

    @Override
    public BigInteger read(Unpacker u, BigInteger to, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        return u.readBigInteger();
    }

    public static BigIntegerTemplate getInstance() {
        return instance;
    }
}

