/*
 * Decompiled with CFR 0.152.
 */
package vivid.shaded.org.msgpack.template;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import vivid.shaded.org.msgpack.MessageTypeException;
import vivid.shaded.org.msgpack.packer.Packer;
import vivid.shaded.org.msgpack.template.AbstractTemplate;
import vivid.shaded.org.msgpack.template.Template;
import vivid.shaded.org.msgpack.unpacker.Unpacker;

public class CollectionTemplate<E>
extends AbstractTemplate<Collection<E>> {
    private Template<E> elementTemplate;

    public CollectionTemplate(Template<E> elementTemplate) {
        this.elementTemplate = elementTemplate;
    }

    @Override
    public void write(Packer pk, Collection<E> target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        Collection<E> col = target;
        pk.writeArrayBegin(col.size());
        for (E e : col) {
            this.elementTemplate.write(pk, e);
        }
        pk.writeArrayEnd();
    }

    @Override
    public Collection<E> read(Unpacker u, Collection<E> to, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        int n = u.readArrayBegin();
        if (to == null) {
            to = new LinkedList();
        } else {
            to.clear();
        }
        for (int i = 0; i < n; ++i) {
            Object e = this.elementTemplate.read(u, null);
            to.add(e);
        }
        u.readArrayEnd();
        return to;
    }
}

