/*
 * Decompiled with CFR 0.152.
 */
package vivid.shaded.org.msgpack.template;

import java.io.IOException;
import vivid.shaded.org.msgpack.MessagePackable;
import vivid.shaded.org.msgpack.MessageTypeException;
import vivid.shaded.org.msgpack.packer.Packer;
import vivid.shaded.org.msgpack.template.AbstractTemplate;
import vivid.shaded.org.msgpack.unpacker.Unpacker;

public class MessagePackableTemplate
extends AbstractTemplate<MessagePackable> {
    private Class<?> targetClass;

    MessagePackableTemplate(Class<?> targetClass) {
        this.targetClass = targetClass;
    }

    @Override
    public void write(Packer pk, MessagePackable target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        target.writeTo(pk);
    }

    @Override
    public MessagePackable read(Unpacker u, MessagePackable to, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        if (to == null) {
            try {
                to = (MessagePackable)this.targetClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new MessageTypeException(e);
            }
            catch (IllegalAccessException e) {
                throw new MessageTypeException(e);
            }
        }
        to.readFrom(u);
        return to;
    }
}

