/*
 * Decompiled with CFR 0.152.
 */
package vivid.shaded.org.msgpack.template.builder;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import vivid.shaded.org.msgpack.annotation.Ignore;
import vivid.shaded.org.msgpack.annotation.Index;
import vivid.shaded.org.msgpack.annotation.NotNullable;
import vivid.shaded.org.msgpack.annotation.Optional;
import vivid.shaded.org.msgpack.packer.Packer;
import vivid.shaded.org.msgpack.template.FieldOption;
import vivid.shaded.org.msgpack.template.Template;
import vivid.shaded.org.msgpack.template.TemplateRegistry;
import vivid.shaded.org.msgpack.template.builder.BeansFieldEntry;
import vivid.shaded.org.msgpack.template.builder.FieldEntry;
import vivid.shaded.org.msgpack.template.builder.ReflectionTemplateBuilder;
import vivid.shaded.org.msgpack.template.builder.TemplateBuildException;
import vivid.shaded.org.msgpack.template.builder.beans.BeanInfo;
import vivid.shaded.org.msgpack.template.builder.beans.IntrospectionException;
import vivid.shaded.org.msgpack.template.builder.beans.Introspector;
import vivid.shaded.org.msgpack.template.builder.beans.PropertyDescriptor;
import vivid.shaded.org.msgpack.unpacker.Unpacker;

public class ReflectionBeansTemplateBuilder
extends ReflectionTemplateBuilder {
    private static Logger LOG = Logger.getLogger(ReflectionBeansTemplateBuilder.class.getName());

    public ReflectionBeansTemplateBuilder(TemplateRegistry registry) {
        super(registry, null);
    }

    @Override
    public boolean matchType(Type targetType, boolean hasAnnotation) {
        Class targetClass = (Class)targetType;
        boolean matched = ReflectionBeansTemplateBuilder.matchAtBeansClassTemplateBuilder(targetClass, hasAnnotation);
        if (matched && LOG.isLoggable(Level.FINE)) {
            LOG.fine("matched type: " + targetClass.getName());
        }
        return matched;
    }

    @Override
    protected ReflectionTemplateBuilder.ReflectionFieldTemplate[] toTemplates(FieldEntry[] entries) {
        ReflectionTemplateBuilder.ReflectionFieldTemplate[] tmpls = new ReflectionTemplateBuilder.ReflectionFieldTemplate[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            FieldEntry e = entries[i];
            Class<?> type = e.getType();
            if (type.isPrimitive()) {
                tmpls[i] = new ReflectionBeansFieldTemplate(e);
                continue;
            }
            Template tmpl = this.registry.lookup(e.getGenericType());
            tmpls[i] = new ReflectionTemplateBuilder.FieldTemplateImpl(e, tmpl);
        }
        return tmpls;
    }

    @Override
    public FieldEntry[] toFieldEntries(Class<?> targetClass, FieldOption implicitOption) {
        int i;
        BeanInfo desc;
        try {
            desc = Introspector.getBeanInfo(targetClass);
        }
        catch (IntrospectionException e1) {
            throw new TemplateBuildException("Class must be java beans class:" + targetClass.getName());
        }
        PropertyDescriptor[] props = desc.getPropertyDescriptors();
        ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>();
        for (int i2 = 0; i2 < props.length; ++i2) {
            PropertyDescriptor pd = props[i2];
            if (this.isIgnoreProperty(pd)) continue;
            list.add(pd);
        }
        props = new PropertyDescriptor[list.size()];
        list.toArray(props);
        FieldEntry[] entries = new BeansFieldEntry[props.length];
        for (int i3 = 0; i3 < props.length; ++i3) {
            PropertyDescriptor p = props[i3];
            int index = this.getPropertyIndex(p);
            if (index < 0) continue;
            if (entries[index] != null) {
                throw new TemplateBuildException("duplicated index: " + index);
            }
            if (index >= entries.length) {
                throw new TemplateBuildException("invalid index: " + index);
            }
            entries[index] = new BeansFieldEntry(p);
            props[i3] = null;
        }
        int insertIndex = 0;
        for (i = 0; i < props.length; ++i) {
            PropertyDescriptor p = props[i];
            if (p == null) continue;
            while (entries[insertIndex] != null) {
                ++insertIndex;
            }
            entries[insertIndex] = new BeansFieldEntry(p);
        }
        for (i = 0; i < entries.length; ++i) {
            FieldEntry e = entries[i];
            FieldOption op = this.getPropertyOption((BeansFieldEntry)e, implicitOption);
            e.setOption(op);
        }
        return entries;
    }

    private FieldOption getPropertyOption(BeansFieldEntry e, FieldOption implicitOption) {
        FieldOption forGetter = this.getMethodOption(e.getPropertyDescriptor().getReadMethod());
        if (forGetter != FieldOption.DEFAULT) {
            return forGetter;
        }
        FieldOption forSetter = this.getMethodOption(e.getPropertyDescriptor().getWriteMethod());
        if (forSetter != FieldOption.DEFAULT) {
            return forSetter;
        }
        return implicitOption;
    }

    private FieldOption getMethodOption(Method method) {
        if (ReflectionBeansTemplateBuilder.isAnnotated(method, Ignore.class)) {
            return FieldOption.IGNORE;
        }
        if (ReflectionBeansTemplateBuilder.isAnnotated(method, Optional.class)) {
            return FieldOption.OPTIONAL;
        }
        if (ReflectionBeansTemplateBuilder.isAnnotated(method, NotNullable.class)) {
            return FieldOption.NOTNULLABLE;
        }
        return FieldOption.DEFAULT;
    }

    private int getPropertyIndex(PropertyDescriptor desc) {
        int getterIndex = this.getMethodIndex(desc.getReadMethod());
        if (getterIndex >= 0) {
            return getterIndex;
        }
        int setterIndex = this.getMethodIndex(desc.getWriteMethod());
        return setterIndex;
    }

    private int getMethodIndex(Method method) {
        Index a = method.getAnnotation(Index.class);
        if (a == null) {
            return -1;
        }
        return a.value();
    }

    private boolean isIgnoreProperty(PropertyDescriptor desc) {
        if (desc == null) {
            return true;
        }
        Method getter = desc.getReadMethod();
        Method setter = desc.getWriteMethod();
        return getter == null || setter == null || !Modifier.isPublic(getter.getModifiers()) || !Modifier.isPublic(setter.getModifiers()) || ReflectionBeansTemplateBuilder.isAnnotated(getter, Ignore.class) || ReflectionBeansTemplateBuilder.isAnnotated(setter, Ignore.class);
    }

    static class ReflectionBeansFieldTemplate
    extends ReflectionTemplateBuilder.ReflectionFieldTemplate {
        ReflectionBeansFieldTemplate(FieldEntry entry) {
            super(entry);
        }

        @Override
        public void write(Packer packer, Object v, boolean required) throws IOException {
            packer.write(v);
        }

        @Override
        public Object read(Unpacker unpacker, Object to, boolean required) throws IOException {
            Class<?> o = unpacker.read(this.entry.getType());
            this.entry.set(to, o);
            return o;
        }
    }
}

