/*
 * Decompiled with CFR 0.152.
 */
package vivid.shaded.org.msgpack.unpacker;

import java.nio.ByteBuffer;
import vivid.shaded.org.msgpack.MessagePack;
import vivid.shaded.org.msgpack.io.LinkedBufferInput;
import vivid.shaded.org.msgpack.unpacker.BufferUnpacker;
import vivid.shaded.org.msgpack.unpacker.MessagePackUnpacker;

public class MessagePackBufferUnpacker
extends MessagePackUnpacker
implements BufferUnpacker {
    private static final int DEFAULT_BUFFER_SIZE = 512;

    public MessagePackBufferUnpacker(MessagePack msgpack) {
        this(msgpack, 512);
    }

    public MessagePackBufferUnpacker(MessagePack msgpack, int bufferSize) {
        super(msgpack, new LinkedBufferInput(bufferSize));
    }

    @Override
    public MessagePackBufferUnpacker wrap(byte[] b) {
        return this.wrap(b, 0, b.length);
    }

    @Override
    public MessagePackBufferUnpacker wrap(byte[] b, int off, int len) {
        ((LinkedBufferInput)this.in).clear();
        ((LinkedBufferInput)this.in).feed(b, off, len, true);
        return this;
    }

    @Override
    public MessagePackBufferUnpacker wrap(ByteBuffer buf) {
        ((LinkedBufferInput)this.in).clear();
        ((LinkedBufferInput)this.in).feed(buf, true);
        return this;
    }

    @Override
    public MessagePackBufferUnpacker feed(byte[] b) {
        ((LinkedBufferInput)this.in).feed(b);
        return this;
    }

    @Override
    public MessagePackBufferUnpacker feed(byte[] b, boolean reference) {
        ((LinkedBufferInput)this.in).feed(b, reference);
        return this;
    }

    @Override
    public MessagePackBufferUnpacker feed(byte[] b, int off, int len) {
        ((LinkedBufferInput)this.in).feed(b, off, len);
        return this;
    }

    @Override
    public MessagePackBufferUnpacker feed(byte[] b, int off, int len, boolean reference) {
        ((LinkedBufferInput)this.in).feed(b, off, len, reference);
        return this;
    }

    @Override
    public MessagePackBufferUnpacker feed(ByteBuffer b) {
        ((LinkedBufferInput)this.in).feed(b);
        return this;
    }

    @Override
    public MessagePackBufferUnpacker feed(ByteBuffer buf, boolean reference) {
        ((LinkedBufferInput)this.in).feed(buf, reference);
        return this;
    }

    @Override
    public int getBufferSize() {
        return ((LinkedBufferInput)this.in).getSize();
    }

    @Override
    public void copyReferencedBuffer() {
        ((LinkedBufferInput)this.in).copyReferencedBuffer();
    }

    @Override
    public void clear() {
        ((LinkedBufferInput)this.in).clear();
        this.reset();
    }
}

