/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.accesscontrols;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.user.ApplicationUser;
import io.vavr.control.Option;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import vivid.trace.accesscontrols.ProjectRoleACPrincipal;
import vivid.trace.accesscontrols.TraceConfigurationAccessControl;
import vivid.trace.components.Factory;

@Named
public class ACLAlgorithm {
    private final Factory factory;

    @Inject
    public ACLAlgorithm(Factory factory) {
        this.factory = factory;
    }

    public boolean hasAccessP(Collection<Map<String, String>> acl, ApplicationUser user, Predicate<Option<TraceConfigurationAccessControl.TraceConfigurationAccess>> accessP) {
        Collection<Map<String, String>> aces = this.accessAcesP(acl, user, accessP, Mode.FIRST_ACE_ONLY);
        return !aces.isEmpty();
    }

    public Collection<Map<String, String>> accessAcesP(Collection<Map<String, String>> acl, ApplicationUser user, Predicate<Option<TraceConfigurationAccessControl.TraceConfigurationAccess>> accessP, Mode mode) {
        if (acl == null || acl.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, String>> aces = new ArrayList<Map<String, String>>();
        for (Map<String, String> ace : acl) {
            String id;
            String type;
            Option<TraceConfigurationAccessControl.TraceConfigurationAccess> access = TraceConfigurationAccessControl.TraceConfigurationAccess.getByValue(ace.get("aspect"));
            if (!accessP.test(access) || !this.isMemberP(user, type = ace.get("type"), id = ace.get("id"))) continue;
            if (mode == Mode.FIRST_ACE_ONLY) {
                return Collections.singletonList(ace);
            }
            aces.add(ace);
        }
        return aces;
    }

    private boolean isMemberP(ApplicationUser user, String type, String id) {
        switch (type) {
            case "group": {
                if (!this.factory.groupManager.isUserInGroup(user, id)) break;
                return true;
            }
            case "project-role": {
                Option<ProjectRole> projectRole = ProjectRoleACPrincipal.projectRoleForId(id, this.factory);
                if (!projectRole.isDefined()) break;
                List projects = this.factory.projectManager.getProjects();
                for (Project project : projects) {
                    if (!this.factory.projectRoleManager.isUserInProjectRole(user, projectRole.get(), project)) continue;
                    return true;
                }
                break;
            }
            case "system": {
                if ("signed-in-users".equals(id)) {
                    return user != null && user.isActive();
                }
                if (!"everyone".equals(id)) break;
                return true;
            }
            case "user": {
                if (user == null || !user.getKey().equals(id)) break;
                ApplicationUser idUser = this.factory.userManager.getUserByKey(id);
                return idUser != null && idUser.isActive();
            }
            default: {
                return false;
            }
        }
        return false;
    }

    public static enum Mode {
        FIRST_ACE_ONLY,
        ALL_ACES;

    }
}

