/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.accesscontrols;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.vavr.collection.HashMap;
import io.vavr.collection.List;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import net.java.ao.Entity;
import net.java.ao.Query;
import vivid.lib.atlassian.ActiveObjectz;
import vivid.trace.ao.AccessControlAO;

@Named
public class AccessControls {
    public static final String INTERCHANGE_PRINCIPAL_ASPECT_KEY = "aspect";
    public static final String INTERCHANGE_PRINCIPAL_TYPE_KEY = "type";
    public static final String INTERCHANGE_PRINCIPAL_ID_KEY = "id";
    private final ActiveObjects activeObjects;
    private static final String GET_VALUE_SELECT = String.format("ID, %s, %s", "PTYPE", "PID");

    @Inject
    public AccessControls(@ComponentImport ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    static Map<String, String> makeInterchangeValue(String type, String id) {
        return HashMap.of(INTERCHANGE_PRINCIPAL_TYPE_KEY, type, INTERCHANGE_PRINCIPAL_ID_KEY, id).toJavaMap();
    }

    public void deleteObject(String objectType, String objectId) {
        this.activeObjects.executeInTransaction(() -> this.activeObjects.deleteWithSQL(AccessControlAO.class, ActiveObjectz.buildWhereStr("OBJ", "OI"), new Object[]{objectType, objectId}));
    }

    void deleteObjectAspect(String objectType, String objectId, String aspect) {
        this.activeObjects.executeInTransaction(() -> this.activeObjects.deleteWithSQL(AccessControlAO.class, ActiveObjectz.buildWhereStr("OBJ", "OI", "ASPECT"), new Object[]{objectType, objectId, aspect}));
    }

    public void deletePrincipal(String principalType, String principalId) {
        this.activeObjects.executeInTransaction(() -> this.activeObjects.deleteWithSQL(AccessControlAO.class, ActiveObjectz.buildWhereStr("PTYPE", "PID"), new Object[]{principalType, principalId}));
    }

    Collection<Map<String, String>> getValues(String objectType, String objectId, Collection<String> aspects) {
        String whereClause = "OBJ = ? AND OI = ? AND ASPECT" + ActiveObjectz.buildInStr(aspects);
        Object[] params = List.of(objectType, objectId).appendAll(aspects).toJavaArray();
        AccessControlAO[] entities = (AccessControlAO[])this.activeObjects.executeInTransaction(() -> (AccessControlAO[])this.activeObjects.find(AccessControlAO.class, Query.select((String)GET_VALUE_SELECT).where(whereClause, params).order("ID")));
        return Arrays.stream(entities).map(e -> HashMap.of(INTERCHANGE_PRINCIPAL_ASPECT_KEY, e.getAspect(), INTERCHANGE_PRINCIPAL_TYPE_KEY, e.getPrincipalType(), INTERCHANGE_PRINCIPAL_ID_KEY, e.getPrincipalId()).toJavaMap()).collect(Collectors.toList());
    }

    void setValues(String objectType, String objectId, Collection<Map<String, String>> acl, Collection<String> allPossibleAclAspectValues) {
        this.activeObjects.executeInTransaction(() -> {
            Entity[] prior = (AccessControlAO[])this.activeObjects.find(AccessControlAO.class, Query.select().where("OBJ = ? AND OI = ? AND ASPECT " + ActiveObjectz.buildInStr(allPossibleAclAspectValues), List.of(objectType, objectId).appendAll(allPossibleAclAspectValues).toJavaArray()));
            ActiveObjectz.deleteEntities(this.activeObjects, prior);
            for (Map entry : acl) {
                this.activeObjects.create(AccessControlAO.class, HashMap.of("OBJ", objectType, "OI", objectId, "ASPECT", entry.get(INTERCHANGE_PRINCIPAL_ASPECT_KEY), "PTYPE", entry.get(INTERCHANGE_PRINCIPAL_TYPE_KEY), "PID", entry.get(INTERCHANGE_PRINCIPAL_ID_KEY)).toJavaMap());
            }
            return null;
        });
    }

    void setValues(String objectType, String objectId, String aspect, Collection<Map<String, String>> membership) {
        this.activeObjects.executeInTransaction(() -> {
            this.activeObjects.deleteWithSQL(AccessControlAO.class, ActiveObjectz.buildWhereStr("OBJ", "OI", "ASPECT"), new Object[]{objectType, objectId, aspect});
            for (Map entry : membership) {
                this.activeObjects.create(AccessControlAO.class, HashMap.of("OBJ", objectType, "OI", objectId, "ASPECT", aspect, "PTYPE", entry.get(INTERCHANGE_PRINCIPAL_TYPE_KEY), "PID", entry.get(INTERCHANGE_PRINCIPAL_ID_KEY)).toJavaMap());
            }
            return null;
        });
    }
}

